/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import java.util.Collections;
import org.geotools.data.DefaultQuery;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.FeatureLock;
import org.geotools.data.FeatureLockException;
import org.geotools.data.FeatureLockFactory;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.jdbc.JDBCFeatureStore;
import org.geotools.jdbc.JDBCTestSupport;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.Id;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.expression.Expression;

public abstract class JDBCFeatureLockingTest
extends JDBCTestSupport {
    JDBCFeatureStore store;

    protected void connect() throws Exception {
        super.connect();
        this.store = (JDBCFeatureStore)this.dataStore.getFeatureSource(this.tname("ft1"));
        this.store.setFeatureLock(FeatureLock.TRANSACTION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLockFeatures() throws Exception {
        FeatureLock lock = FeatureLockFactory.generate((String)this.tname("ft1"), (long)3600000L);
        DefaultTransaction tx = new DefaultTransaction();
        this.store.setTransaction((Transaction)tx);
        this.store.setFeatureLock(lock);
        int locked = this.store.lockFeatures();
        JDBCFeatureLockingTest.assertTrue((locked > 0 ? 1 : 0) != 0);
        DefaultQuery query = new DefaultQuery(this.tname("ft1"));
        FeatureReader reader = this.dataStore.getFeatureReader((Query)query, (Transaction)tx);
        int count = 0;
        while (reader.hasNext()) {
            ++count;
            reader.next();
        }
        JDBCFeatureLockingTest.assertTrue((count > 0 ? 1 : 0) != 0);
        reader.close();
        FeatureWriter writer = this.dataStore.getFeatureWriter(this.tname("ft1"), (Transaction)tx);
        JDBCFeatureLockingTest.assertTrue((boolean)writer.hasNext());
        SimpleFeature feature = (SimpleFeature)writer.next();
        feature.setAttribute(this.aname("intProperty"), (Object)new Integer(100));
        try {
            writer.write();
            JDBCFeatureLockingTest.fail((String)"should have thrown feature lock exception");
        }
        catch (FeatureLockException e) {
        }
        finally {
            writer.close();
        }
        tx.addAuthorization(lock.getAuthorization());
        writer = this.dataStore.getFeatureWriter(this.tname("ft1"), (Transaction)tx);
        JDBCFeatureLockingTest.assertTrue((boolean)writer.hasNext());
        feature = (SimpleFeature)writer.next();
        feature.setAttribute(this.aname("intProperty"), (Object)new Integer(100));
        writer.write();
        writer.close();
        tx.close();
    }

    public void testLockFeaturesWithFilter() throws Exception {
        FeatureLock lock = FeatureLockFactory.generate((String)this.tname("ft1"), (long)3600000L);
        DefaultTransaction tx = new DefaultTransaction();
        this.store.setTransaction((Transaction)tx);
        this.store.setFeatureLock(lock);
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyIsEqualTo f = ff.equals((Expression)ff.property(this.aname("intProperty")), (Expression)ff.literal(1));
        int locked = this.store.lockFeatures((Filter)f);
        JDBCFeatureLockingTest.assertEquals((int)1, (int)locked);
        FeatureWriter writer = this.dataStore.getFeatureWriter(this.tname("ft1"), (Transaction)tx);
        boolean failure = false;
        while (writer.hasNext()) {
            SimpleFeature feature = (SimpleFeature)writer.next();
            Number old = (Number)feature.getAttribute(this.aname("intProperty"));
            feature.setAttribute(this.aname("intProperty"), (Object)new Integer(100));
            if (new Integer(1).equals(old.intValue())) {
                try {
                    writer.write();
                    JDBCFeatureLockingTest.fail((String)"writer should have thrown exception for locked feature");
                }
                catch (FeatureLockException e) {
                    failure = true;
                }
                continue;
            }
            writer.write();
        }
        writer.close();
        JDBCFeatureLockingTest.assertTrue((boolean)failure);
        tx.close();
    }

    public void testLockFeaturesWithInvalidFilter() throws Exception {
        FeatureLock lock = FeatureLockFactory.generate((String)this.tname("ft1"), (long)3600000L);
        DefaultTransaction tx = new DefaultTransaction();
        this.store.setTransaction((Transaction)tx);
        this.store.setFeatureLock(lock);
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyIsEqualTo f = ff.equals((Expression)ff.property(this.aname("invalidProperty")), (Expression)ff.literal(1));
        try {
            this.store.lockFeatures((Filter)f);
            JDBCFeatureLockingTest.fail((String)"Should have failed with an exception, the filter is not valid");
        }
        catch (Exception e) {
            // empty catch block
        }
        tx.close();
    }

    public void testLockFeaturesWithInvalidQuery() throws Exception {
        FeatureLock lock = FeatureLockFactory.generate((String)this.tname("ft1"), (long)3600000L);
        DefaultTransaction tx = new DefaultTransaction();
        this.store.setTransaction((Transaction)tx);
        this.store.setFeatureLock(lock);
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyIsEqualTo f = ff.equals((Expression)ff.property(this.aname("invalidProperty")), (Expression)ff.literal(1));
        try {
            this.store.lockFeatures((Query)new DefaultQuery(this.store.getSchema().getTypeName(), (Filter)f));
            JDBCFeatureLockingTest.fail((String)"Should have failed with an exception, the filter is not valid");
        }
        catch (Exception e) {
            // empty catch block
        }
        tx.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUnlockFeatures() throws Exception {
        FeatureLock lock = FeatureLockFactory.generate((String)this.tname("ft1"), (long)3600000L);
        DefaultTransaction tx = new DefaultTransaction();
        this.store.setTransaction((Transaction)tx);
        this.store.setFeatureLock(lock);
        this.store.lockFeatures();
        FeatureWriter writer = this.dataStore.getFeatureWriter(this.tname("ft1"), (Transaction)tx);
        JDBCFeatureLockingTest.assertTrue((boolean)writer.hasNext());
        SimpleFeature feature = (SimpleFeature)writer.next();
        feature.setAttribute(this.aname("intProperty"), (Object)new Integer(100));
        try {
            writer.write();
            JDBCFeatureLockingTest.fail((String)"write should have thrown exception");
        }
        catch (FeatureLockException e) {
        }
        finally {
            writer.close();
        }
        try {
            this.store.unLockFeatures();
            JDBCFeatureLockingTest.fail((String)"unlock should have thrown an exception");
        }
        catch (FeatureLockException e) {
            // empty catch block
        }
        tx.addAuthorization(lock.getAuthorization());
        this.store.unLockFeatures();
        writer = this.dataStore.getFeatureWriter(this.tname("ft1"), (Transaction)tx);
        JDBCFeatureLockingTest.assertTrue((boolean)writer.hasNext());
        feature = (SimpleFeature)writer.next();
        feature.setAttribute(this.aname("intProperty"), (Object)new Integer(100));
        writer.write();
        writer.close();
        tx.close();
    }

    public void testUnlockFeaturesInvalidFilter() throws Exception {
        FeatureLock lock = FeatureLockFactory.generate((String)this.tname("ft1"), (long)3600000L);
        DefaultTransaction tx = new DefaultTransaction();
        this.store.setTransaction((Transaction)tx);
        this.store.setFeatureLock(lock);
        tx.addAuthorization(lock.getAuthorization());
        this.store.lockFeatures();
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyIsEqualTo f = ff.equals((Expression)ff.property(this.aname("invalidProperty")), (Expression)ff.literal(1));
        try {
            this.store.unLockFeatures((Query)new DefaultQuery(this.store.getSchema().getTypeName(), (Filter)f));
            JDBCFeatureLockingTest.fail((String)"Should have failed with an exception, the filter is not valid");
        }
        catch (Exception e) {
            // empty catch block
        }
        this.store.unLockFeatures();
        tx.close();
    }

    public void testDeleteLockedFeatures() throws Exception {
        FeatureLock lock = FeatureLockFactory.generate((String)this.tname("ft1"), (long)3600000L);
        DefaultTransaction tx = new DefaultTransaction();
        this.store.setTransaction((Transaction)tx);
        this.store.setFeatureLock(lock);
        tx.addAuthorization(lock.getAuthorization());
        FilterFactory ff = this.dataStore.getFilterFactory();
        Id f1 = ff.id(Collections.singleton(ff.featureId(this.tname("ft1") + ".1")));
        JDBCFeatureLockingTest.assertEquals((int)1, (int)this.store.lockFeatures((Filter)f1));
        DefaultTransaction tx1 = new DefaultTransaction();
        this.store.setTransaction((Transaction)tx1);
        try {
            this.store.removeFeatures((Filter)f1);
            JDBCFeatureLockingTest.fail((String)"Locked feature should not be deleted.");
        }
        catch (FeatureLockException e) {
            // empty catch block
        }
        tx1.close();
        this.store.setTransaction((Transaction)tx);
        this.store.removeFeatures((Filter)f1);
        tx.commit();
        tx.close();
    }

    public void testModifyLockedFeatures() throws Exception {
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyIsEqualTo f0 = ff.equal((Expression)ff.property(this.aname("intProperty")), (Expression)ff.literal(1000), true);
        JDBCFeatureLockingTest.assertEquals((int)0, (int)this.store.getCount((Query)new DefaultQuery(this.tname("ft1"), (Filter)f0)));
        FeatureLock lock = FeatureLockFactory.generate((String)this.tname("ft1"), (long)3600000L);
        DefaultTransaction tx = new DefaultTransaction();
        this.store.setTransaction((Transaction)tx);
        this.store.setFeatureLock(lock);
        tx.addAuthorization(lock.getAuthorization());
        Id f1 = ff.id(Collections.singleton(ff.featureId(this.tname("ft1") + ".1")));
        this.store.lockFeatures((Filter)f1);
        DefaultTransaction tx1 = new DefaultTransaction();
        this.store.setTransaction((Transaction)tx1);
        AttributeDescriptor ad = this.store.getSchema().getDescriptor(this.aname("intProperty"));
        Integer v = new Integer(1000);
        try {
            this.store.modifyFeatures(ad, (Object)v, (Filter)f1);
            JDBCFeatureLockingTest.fail((String)"Locked feature should not be modified.");
        }
        catch (FeatureLockException e) {
            // empty catch block
        }
        tx1.close();
        this.store.setTransaction((Transaction)tx);
        this.store.modifyFeatures(ad, (Object)v, (Filter)f1);
        tx.commit();
        JDBCFeatureLockingTest.assertEquals((int)1, (int)this.store.getCount((Query)new DefaultQuery(this.tname("ft1"), (Filter)f0)));
        tx.close();
    }
}

