/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import java.awt.RenderingHints;
import org.geotools.data.DefaultQuery;
import org.geotools.data.FeatureReader;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.factory.Hints;
import org.geotools.jdbc.JDBCTestSupport;
import org.opengis.feature.Association;
import org.opengis.feature.Property;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;

public abstract class JDBCForeignKeyTest
extends JDBCTestSupport {
    protected void connect() throws Exception {
        super.connect();
        this.dataStore.setAssociations(true);
    }

    public void testGetSchema() throws Exception {
        SimpleFeatureType featureType = this.dataStore.getSchema("fk");
        JDBCForeignKeyTest.assertNotNull((Object)featureType);
        AttributeDescriptor att = featureType.getDescriptor("ft1");
        JDBCForeignKeyTest.assertNotNull((Object)att);
        JDBCForeignKeyTest.assertEquals(Association.class, (Object)att.getType().getBinding());
    }

    public void testGetFeatures() throws Exception {
        Hints hints = new Hints((RenderingHints.Key)Hints.ASSOCIATION_TRAVERSAL_DEPTH, (Object)new Integer(1));
        DefaultQuery query = new DefaultQuery();
        query.setTypeName("fk");
        query.setHints(hints);
        FeatureReader reader = this.dataStore.getFeatureReader((Query)query, Transaction.AUTO_COMMIT);
        JDBCForeignKeyTest.assertTrue((boolean)reader.hasNext());
        SimpleFeature feature = (SimpleFeature)reader.next();
        Association association = (Association)feature.getAttribute("ft1");
        JDBCForeignKeyTest.assertEquals((Object)"ft1.0", association.getUserData().get("gml:id"));
        SimpleFeature associated = (SimpleFeature)association.getValue();
        JDBCForeignKeyTest.assertNotNull((Object)associated);
        JDBCForeignKeyTest.assertEquals((Object)"zero", (Object)associated.getAttribute("stringProperty"));
        Property attribute = feature.getProperty("ft1");
        JDBCForeignKeyTest.assertEquals((Object)"ft1.0", attribute.getUserData().get("gml:id"));
        reader.close();
    }

    public void testGetFeaturesWithZeroDepth() throws Exception {
        Hints hints = new Hints((RenderingHints.Key)Hints.ASSOCIATION_TRAVERSAL_DEPTH, (Object)new Integer(0));
        DefaultQuery query = new DefaultQuery();
        query.setTypeName("fk");
        query.setHints(hints);
        FeatureReader reader = this.dataStore.getFeatureReader((Query)query, Transaction.AUTO_COMMIT);
        JDBCForeignKeyTest.assertTrue((boolean)reader.hasNext());
        SimpleFeature feature = (SimpleFeature)reader.next();
        Association association = (Association)feature.getAttribute("ft1");
        JDBCForeignKeyTest.assertNull((Object)association.getValue());
        Property attribute = feature.getProperty("ft1");
        JDBCForeignKeyTest.assertEquals((Object)"ft1.0", attribute.getUserData().get("gml:id"));
        reader.close();
    }
}

