/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.Point;
import java.awt.RenderingHints;
import java.util.Map;
import org.geotools.data.DefaultQuery;
import org.geotools.data.FeatureReader;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.factory.Hints;
import org.geotools.jdbc.JDBCTestSupport;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.identity.GmlObjectId;

public abstract class JDBCGeometryAssociationTestSupport
extends JDBCTestSupport {
    protected void connect() throws Exception {
        super.connect();
        this.dataStore.setAssociations(true);
    }

    public void testGetFeatureNoAssociation() throws Exception {
        Hints hints = new Hints((RenderingHints.Key)Hints.ASSOCIATION_TRAVERSAL_DEPTH, (Object)new Integer(1));
        DefaultQuery query = new DefaultQuery();
        query.setTypeName("ga");
        query.setHints(hints);
        FeatureReader reader = this.dataStore.getFeatureReader((Query)query, Transaction.AUTO_COMMIT);
        JDBCGeometryAssociationTestSupport.assertTrue((boolean)reader.hasNext());
        SimpleFeature feature = (SimpleFeature)reader.next();
        JDBCGeometryAssociationTestSupport.assertNotNull((Object)feature);
        JDBCGeometryAssociationTestSupport.assertEquals((String)"ga.0", (String)feature.getID());
        Geometry g = (Geometry)feature.getDefaultGeometry();
        JDBCGeometryAssociationTestSupport.assertNotNull((Object)g);
        JDBCGeometryAssociationTestSupport.assertEquals((Object)new Coordinate(0.0, 0.0), (Object)g.getCoordinate());
        Map ud = (Map)g.getUserData();
        JDBCGeometryAssociationTestSupport.assertEquals((Object)"0", ud.get("gml:id"));
        reader.close();
    }

    public void testGetFeatureWithAssociation() throws Exception {
        Hints hints = new Hints((RenderingHints.Key)Hints.ASSOCIATION_TRAVERSAL_DEPTH, (Object)new Integer(1));
        DefaultQuery query = new DefaultQuery();
        query.setTypeName("ga");
        query.setHints(hints);
        FeatureReader reader = this.dataStore.getFeatureReader((Query)query, Transaction.AUTO_COMMIT);
        JDBCGeometryAssociationTestSupport.assertTrue((boolean)reader.hasNext());
        reader.next();
        JDBCGeometryAssociationTestSupport.assertTrue((boolean)reader.hasNext());
        SimpleFeature feature = (SimpleFeature)reader.next();
        JDBCGeometryAssociationTestSupport.assertNotNull((Object)feature);
        JDBCGeometryAssociationTestSupport.assertEquals((String)"ga.1", (String)feature.getID());
        Geometry g = (Geometry)feature.getDefaultGeometry();
        JDBCGeometryAssociationTestSupport.assertNotNull((Object)g);
        JDBCGeometryAssociationTestSupport.assertEquals((Object)new Coordinate(1.0, 1.0), (Object)g.getCoordinate());
        JDBCGeometryAssociationTestSupport.assertTrue((boolean)(g.getUserData() instanceof Map));
        JDBCGeometryAssociationTestSupport.assertEquals((Object)"1", ((Map)g.getUserData()).get("gml:id"));
        reader.close();
        query.setHints(new Hints((RenderingHints.Key)Hints.ASSOCIATION_TRAVERSAL_DEPTH, (Object)new Integer(0)));
        reader = this.dataStore.getFeatureReader((Query)query, Transaction.AUTO_COMMIT);
        JDBCGeometryAssociationTestSupport.assertTrue((boolean)reader.hasNext());
        reader.next();
        JDBCGeometryAssociationTestSupport.assertTrue((boolean)reader.hasNext());
        feature = (SimpleFeature)reader.next();
        JDBCGeometryAssociationTestSupport.assertNotNull((Object)feature);
        JDBCGeometryAssociationTestSupport.assertEquals((String)"ga.1", (String)feature.getID());
        g = (Geometry)feature.getDefaultGeometry();
        JDBCGeometryAssociationTestSupport.assertNotNull((Object)g);
        JDBCGeometryAssociationTestSupport.assertTrue((boolean)g.isEmpty());
        JDBCGeometryAssociationTestSupport.assertTrue((boolean)(g.getUserData() instanceof Map));
        JDBCGeometryAssociationTestSupport.assertEquals((Object)"1", ((Map)g.getUserData()).get("gml:id"));
        reader.close();
    }

    public void testMultiGeometryAssociation() throws Exception {
        Hints hints = new Hints((RenderingHints.Key)Hints.ASSOCIATION_TRAVERSAL_DEPTH, (Object)new Integer(1));
        DefaultQuery query = new DefaultQuery();
        query.setTypeName("ga");
        query.setHints(hints);
        FeatureReader reader = this.dataStore.getFeatureReader((Query)query, Transaction.AUTO_COMMIT);
        JDBCGeometryAssociationTestSupport.assertTrue((boolean)reader.hasNext());
        reader.next();
        JDBCGeometryAssociationTestSupport.assertTrue((boolean)reader.hasNext());
        reader.next();
        JDBCGeometryAssociationTestSupport.assertTrue((boolean)reader.hasNext());
        SimpleFeature feature = (SimpleFeature)reader.next();
        Geometry g = (Geometry)feature.getDefaultGeometry();
        JDBCGeometryAssociationTestSupport.assertNotNull((Object)g);
        JDBCGeometryAssociationTestSupport.assertTrue((boolean)(g instanceof MultiPoint));
        MultiPoint mp = (MultiPoint)g;
        JDBCGeometryAssociationTestSupport.assertEquals((Object)"2", ((Map)mp.getUserData()).get("gml:id"));
        JDBCGeometryAssociationTestSupport.assertEquals((int)2, (int)mp.getNumGeometries());
        Point p = (Point)mp.getGeometryN(0);
        JDBCGeometryAssociationTestSupport.assertEquals((Object)new Coordinate(0.0, 0.0), (Object)p.getCoordinate());
        JDBCGeometryAssociationTestSupport.assertEquals((Object)"0", ((Map)p.getUserData()).get("gml:id"));
        p = (Point)mp.getGeometryN(1);
        JDBCGeometryAssociationTestSupport.assertEquals((Object)new Coordinate(1.0, 1.0), (Object)p.getCoordinate());
        JDBCGeometryAssociationTestSupport.assertEquals((Object)"1", ((Map)p.getUserData()).get("gml:id"));
        reader.close();
    }

    public void testGetGmlObjectGeometry() throws Exception {
        GmlObjectId id = this.dataStore.getFilterFactory().gmlObjectId("0");
        Object o = this.dataStore.getGmlObject(id, null);
        JDBCGeometryAssociationTestSupport.assertNotNull((Object)o);
        JDBCGeometryAssociationTestSupport.assertTrue((boolean)(o instanceof Point));
        JDBCGeometryAssociationTestSupport.assertEquals((Object)new Coordinate(0.0, 0.0), (Object)((Point)o).getCoordinate());
        id = this.dataStore.getFilterFactory().gmlObjectId("ft1.0");
        o = this.dataStore.getGmlObject(id, null);
        JDBCGeometryAssociationTestSupport.assertNotNull((Object)o);
        JDBCGeometryAssociationTestSupport.assertTrue((boolean)(o instanceof SimpleFeature));
    }
}

