/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.jdbc;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataStore;
import org.geotools.data.DefaultQuery;
import org.geotools.data.FeatureListener;
import org.geotools.data.FeatureSource;
import org.geotools.data.FeatureStore;
import org.geotools.data.Query;
import org.geotools.data.QueryCapabilities;
import org.geotools.data.ResourceInfo;
import org.geotools.data.Transaction;
import org.geotools.data.jdbc.JDBC1DataStore;
import org.geotools.data.jdbc.JDBCFeatureCollection;
import org.geotools.data.jdbc.JDBCUtils;
import org.geotools.data.jdbc.SQLBuilder;
import org.geotools.data.jdbc.fidmapper.FIDMapper;
import org.geotools.data.jdbc.fidmapper.NullFIDMapper;
import org.geotools.data.jdbc.fidmapper.TypedFIDMapper;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.filter.SQLEncoderException;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.sort.SortBy;
import org.opengis.filter.sort.SortOrder;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class JDBCFeatureSource
implements SimpleFeatureSource {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.data.jdbc");
    private SimpleFeatureType featureType;
    private JDBC1DataStore dataStore;
    protected QueryCapabilities queryCapabilities;

    public JDBCFeatureSource(JDBC1DataStore jdbcDataStore, SimpleFeatureType featureType) {
        this.featureType = featureType;
        this.dataStore = jdbcDataStore;
        this.queryCapabilities = new JDBCQueryCapabilities(featureType);
    }

    public Name getName() {
        return this.getSchema().getName();
    }

    public ResourceInfo getInfo() {
        return new ResourceInfo(){
            final Set<String> words = new HashSet<String>();
            {
                this.words.add("features");
                this.words.add(JDBCFeatureSource.this.getSchema().getTypeName());
            }

            public ReferencedEnvelope getBounds() {
                try {
                    return JDBCFeatureSource.this.getBounds();
                }
                catch (IOException e) {
                    return null;
                }
            }

            public CoordinateReferenceSystem getCRS() {
                return JDBCFeatureSource.this.getSchema().getCoordinateReferenceSystem();
            }

            public String getDescription() {
                return null;
            }

            public Set<String> getKeywords() {
                return this.words;
            }

            public String getName() {
                return JDBCFeatureSource.this.getSchema().getTypeName();
            }

            public URI getSchema() {
                Name name = JDBCFeatureSource.this.getSchema().getName();
                try {
                    URI namespace = new URI(name.getNamespaceURI());
                    return namespace;
                }
                catch (URISyntaxException e) {
                    return null;
                }
            }

            public String getTitle() {
                Name name = JDBCFeatureSource.this.getSchema().getName();
                return name.getLocalPart();
            }
        };
    }

    public DataStore getDataStore() {
        return this.getJDBCDataStore();
    }

    public JDBC1DataStore getJDBCDataStore() {
        return this.dataStore;
    }

    public void addFeatureListener(FeatureListener listener) {
        this.getJDBCDataStore().listenerManager.addFeatureListener((FeatureSource)this, listener);
    }

    public void removeFeatureListener(FeatureListener listener) {
        this.getJDBCDataStore().listenerManager.removeFeatureListener((FeatureSource)this, listener);
    }

    public Transaction getTransaction() {
        return Transaction.AUTO_COMMIT;
    }

    public SimpleFeatureCollection getFeatures(Query request) throws IOException {
        QueryCapabilities queryCapabilities;
        String typeName = this.featureType.getTypeName();
        if (request.getTypeName() != null && !typeName.equals(request.getTypeName())) {
            throw new IOException("Cannot query " + typeName + " with:" + request);
        }
        if (request.getTypeName() == null) {
            request = new DefaultQuery(request);
            ((DefaultQuery)request).setTypeName(this.featureType.getTypeName());
        }
        if (!(queryCapabilities = this.getQueryCapabilities()).supportsSorting(request.getSortBy())) {
            throw new DataSourceException("DataStore cannot provide the requested sort order");
        }
        return new JDBCFeatureCollection(this, request);
    }

    public SimpleFeatureCollection getFeatures(Filter filter) throws IOException {
        return this.getFeatures((Query)new DefaultQuery(this.featureType.getTypeName(), filter));
    }

    public SimpleFeatureCollection getFeatures() throws IOException {
        return this.getFeatures((Filter)Filter.INCLUDE);
    }

    public ReferencedEnvelope getBounds() throws IOException {
        return this.getBounds(Query.ALL);
    }

    public ReferencedEnvelope getBounds(Query query) throws IOException {
        if (query.getFilter() == Filter.EXCLUDE) {
            if (this.featureType != null) {
                return new ReferencedEnvelope(new Envelope(), this.featureType.getGeometryDescriptor().getCoordinateReferenceSystem());
            }
            return new ReferencedEnvelope();
        }
        return null;
    }

    public int getCount(Query query) throws IOException {
        return this.count(query, this.getTransaction());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int count(Query query, Transaction transaction) throws IOException {
        Filter filter = query.getFilter();
        if (Filter.EXCLUDE.equals(filter)) {
            return 0;
        }
        JDBC1DataStore jdbc = this.getJDBCDataStore();
        SQLBuilder sqlBuilder = jdbc.getSqlBuilder(this.featureType.getTypeName());
        Filter preFilter = sqlBuilder.getPreQueryFilter(filter);
        Filter postFilter = sqlBuilder.getPostQueryFilter(filter);
        if (postFilter != null && !Filter.INCLUDE.equals(postFilter)) {
            return -1;
        }
        Connection conn = null;
        try {
            conn = jdbc.getConnection(transaction);
            String typeName = this.getSchema().getTypeName();
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT COUNT(*) as cnt");
            sqlBuilder.sqlFrom(sql, typeName);
            sqlBuilder.sqlWhere(sql, preFilter);
            LOGGER.finer("SQL: " + sql);
            Statement statement = conn.createStatement();
            ResultSet results = statement.executeQuery(sql.toString());
            results.next();
            int count = results.getInt("cnt");
            results.close();
            statement.close();
            int n = count;
            return n;
        }
        catch (SQLException sqlException) {
            JDBCUtils.close(conn, transaction, sqlException);
            conn = null;
            throw new DataSourceException("Could not count " + query.getHandle(), (Throwable)sqlException);
        }
        catch (SQLEncoderException e) {
            int n = -1;
            return n;
        }
        finally {
            JDBCUtils.close(conn, transaction, null);
        }
    }

    public SimpleFeatureType getSchema() {
        return this.featureType;
    }

    protected Connection getConnection() throws IOException {
        return this.getJDBCDataStore().getConnection(this.getTransaction());
    }

    protected void close(Connection conn, Transaction trans, SQLException sqle) {
        JDBCUtils.close(conn, trans, sqle);
    }

    protected void close(ResultSet rs) {
        JDBCUtils.close(rs);
    }

    protected void close(Statement statement) {
        JDBCUtils.close(statement);
    }

    public Set getSupportedHints() {
        return this.dataStore.getSupportedHints();
    }

    public QueryCapabilities getQueryCapabilities() {
        return this.queryCapabilities;
    }

    protected class JDBCQueryCapabilities
    extends QueryCapabilities {
        private SimpleFeatureType featureType;

        public JDBCQueryCapabilities(SimpleFeatureType fullFeatureType) {
            this.featureType = fullFeatureType;
        }

        public boolean supportsSorting(SortBy[] sortAttributes) {
            if (super.supportsSorting(sortAttributes)) {
                return true;
            }
            for (int i = 0; i < sortAttributes.length; ++i) {
                SortOrder sortOrder;
                PropertyName propertyName;
                SortBy sortBy = sortAttributes[i];
                if (!(SortBy.NATURAL_ORDER == sortBy ? !this.supportsNaturalOrderSorting() : (SortBy.REVERSE_ORDER == sortBy ? !this.supportsReverseOrderSorting() : !this.supportsPropertySorting(propertyName = sortBy.getPropertyName(), sortOrder = sortBy.getSortOrder())))) continue;
                return false;
            }
            return true;
        }

        protected boolean supportsNaturalOrderSorting() {
            return false;
        }

        protected boolean supportsReverseOrderSorting() {
            return false;
        }

        protected boolean supportsPropertySorting(PropertyName propertyName, SortOrder sortOrder) {
            AttributeDescriptor descriptor = (AttributeDescriptor)propertyName.evaluate((Object)this.featureType);
            if (descriptor != null) {
                return true;
            }
            String attName = propertyName.getPropertyName();
            AttributeDescriptor attribute = this.featureType.getDescriptor(attName);
            return attribute != null;
        }

        public boolean isReliableFIDSupported() {
            FIDMapper mapper;
            try {
                mapper = JDBCFeatureSource.this.dataStore.getFIDMapper(this.featureType.getTypeName());
            }
            catch (IOException e) {
                LOGGER.warning("Unable to access fid mapper");
                LOGGER.log(Level.FINE, "", e);
                return super.isReliableFIDSupported();
            }
            return !this.isNullFidMapper(mapper);
        }

        protected boolean isNullFidMapper(FIDMapper mapper) {
            if (mapper instanceof TypedFIDMapper) {
                mapper = ((TypedFIDMapper)mapper).getWrappedMapper();
            }
            return mapper instanceof NullFIDMapper;
        }

        public boolean isUseProvidedFIDSupported() {
            return this instanceof FeatureStore;
        }
    }
}

