/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.jdbc;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.geotools.data.jdbc.fidmapper.FIDMapper;
import org.opengis.feature.simple.SimpleFeatureType;

public class FeatureTypeInfo {
    private String featureTypeName;
    private SimpleFeatureType schema;
    private Map sridMap = new HashMap();
    private FIDMapper mapper;

    public FeatureTypeInfo(String typeName, SimpleFeatureType schema, FIDMapper mapper) {
        this.featureTypeName = typeName;
        this.schema = schema;
        this.mapper = mapper;
    }

    public String getFeatureTypeName() {
        return this.featureTypeName;
    }

    public SimpleFeatureType getSchema() {
        return this.schema;
    }

    public int getSRID(String geometryAttributeName) {
        int srid = -1;
        Integer integer = (Integer)this.sridMap.get(geometryAttributeName);
        if (integer != null) {
            srid = integer;
        }
        return srid;
    }

    public Map getSRIDs() {
        return Collections.unmodifiableMap(this.sridMap);
    }

    void putSRID(String geometryColumnName, int srid) {
        this.sridMap.put(geometryColumnName, new Integer(srid));
    }

    public String toString() {
        return "typeName = " + this.featureTypeName + " schema: " + this.schema + "srids: " + this.sridMap;
    }

    public FIDMapper getFIDMapper() {
        return this.mapper;
    }

    public void setFIDMapper(FIDMapper mapper) {
        this.mapper = mapper;
    }
}

