/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import java.sql.Connection;
import java.util.logging.Logger;
import org.geotools.data.store.ContentEntry;
import org.geotools.data.store.ContentState;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.PrimaryKey;

public final class JDBCState
extends ContentState {
    private Connection connection;
    private PrimaryKey primaryKey;
    private boolean exposePrimaryKeyColumns;

    public JDBCState(JDBCState state) {
        super((ContentState)state);
        this.primaryKey = state.getPrimaryKey();
        this.exposePrimaryKeyColumns = state.isExposePrimaryKeyColumns();
    }

    public JDBCState(ContentEntry entry) {
        super(entry);
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public PrimaryKey getPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(PrimaryKey primaryKey) {
        this.primaryKey = primaryKey;
    }

    public boolean isExposePrimaryKeyColumns() {
        return this.exposePrimaryKeyColumns;
    }

    public void setExposePrimaryKeyColumns(boolean exposePrimaryKeyColumns) {
        if (exposePrimaryKeyColumns != this.exposePrimaryKeyColumns) {
            this.featureType = null;
        }
        this.exposePrimaryKeyColumns = exposePrimaryKeyColumns;
    }

    public void flush() {
        this.connection = null;
        this.primaryKey = null;
        super.flush();
    }

    public ContentState copy() {
        return new JDBCState(this);
    }

    public void close() {
        ((JDBCDataStore)this.entry.getDataStore()).closeSafe(this.connection);
        super.close();
    }

    protected void finalize() throws Throwable {
        if (this.connection != null && !this.connection.isClosed()) {
            Logger.getLogger("org.geotools.jdbc").severe("State finalized with open connection.");
        }
    }
}

