/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Logger;
import org.geotools.data.Transaction;
import org.geotools.jdbc.JDBCDataStore;

public final class JDBCTransactionState
implements Transaction.State {
    JDBCDataStore dataStore;
    Transaction tx;
    Connection cx;

    public JDBCTransactionState(Connection cx, JDBCDataStore dataStore) {
        this.cx = cx;
        this.dataStore = dataStore;
    }

    public void setTransaction(Transaction tx) {
        if (tx != null && this.tx != null) {
            throw new IllegalStateException("New transaction set without closing old transaction first.");
        }
        if (tx == null) {
            if (this.cx != null) {
                try {
                    this.cx.close();
                }
                catch (SQLException sQLException) {}
            } else {
                this.dataStore.getLogger().warning("Transaction is attempting to close an already closed connection");
            }
            this.cx = null;
        }
        this.tx = tx;
    }

    public void addAuthorization(String AuthID) throws IOException {
    }

    public void commit() throws IOException {
        try {
            this.cx.commit();
        }
        catch (SQLException e) {
            String msg = "Error occured on commit";
            throw (IOException)new IOException(msg).initCause(e);
        }
    }

    public void rollback() throws IOException {
        try {
            this.cx.rollback();
        }
        catch (SQLException e) {
            String msg = "Error occured on rollback";
            throw (IOException)new IOException(msg).initCause(e);
        }
    }

    protected void finalize() throws Throwable {
        if (this.cx != null && !this.cx.isClosed()) {
            Logger.getLogger("org.geotools.jdbc").severe("State finalized with open connection.");
        }
    }
}

