/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverageio.jp2k;

import it.geosolutions.imageio.stream.input.FileImageInputStreamExt;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.imageio.GeoToolsWriteParams;
import org.geotools.coverageio.jp2k.JP2KReader;
import org.geotools.coverageio.jp2k.Utils;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataUtilities;
import org.geotools.factory.Hints;
import org.geotools.parameter.DefaultParameterDescriptor;
import org.geotools.parameter.DefaultParameterDescriptorGroup;
import org.geotools.parameter.ParameterGroup;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.grid.Format;
import org.opengis.coverage.grid.GridCoverageWriter;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;

public final class JP2KFormat
extends AbstractGridFormat
implements Format {
    private ImageReaderSpi spi = null;
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.coverageio.jp2k");
    private static final String USE_MT = "USE_MULTITHREADING";
    public static final DefaultParameterDescriptor<Boolean> USE_MULTITHREADING = new DefaultParameterDescriptor("USE_MULTITHREADING", Boolean.class, (Object[])new Boolean[]{Boolean.TRUE, Boolean.FALSE}, (Object)Boolean.FALSE);
    private static final String SUGGESTED_TILESIZE = "SUGGESTED_TILE_SIZE";
    public static final DefaultParameterDescriptor<String> SUGGESTED_TILE_SIZE = new DefaultParameterDescriptor("SUGGESTED_TILE_SIZE", String.class, null, (Object)"512,512");
    public static final String TILE_SIZE_SEPARATOR = ",";
    public static final ParameterDescriptor<Color> INPUT_TRANSPARENT_COLOR = new DefaultParameterDescriptor("InputTransparentColor", Color.class, null, null);

    public JP2KFormat() {
        this.setInfo();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Creating a new JP2KFormat.");
        }
    }

    protected void setInfo() {
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("name", "JP2K (Direct) ");
        info.put("description", "JP2K (Direct) Coverage Format");
        info.put("vendor", "Geotools");
        info.put("docURL", "");
        info.put("version", "1.0");
        this.mInfo = info;
        this.writeParameters = null;
        this.readParameters = new ParameterGroup((ParameterDescriptorGroup)new DefaultParameterDescriptorGroup(this.mInfo, new GeneralParameterDescriptor[]{READ_GRIDGEOMETRY2D, INPUT_TRANSPARENT_COLOR, USE_JAI_IMAGEREAD, USE_MULTITHREADING, SUGGESTED_TILE_SIZE}));
    }

    public AbstractGridCoverage2DReader getReader(Object source, Hints hints) {
        try {
            return new JP2KReader(source, hints);
        }
        catch (MismatchedDimensionException e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
            return null;
        }
        catch (DataSourceException e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
            return null;
        }
        catch (IOException e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
            return null;
        }
    }

    public AbstractGridCoverage2DReader getReader(Object source) {
        return this.getReader(source, null);
    }

    public GridCoverageWriter getWriter(Object destination) {
        throw new UnsupportedOperationException("This plugin does not support writing at this time.");
    }

    public GeoToolsWriteParams getDefaultImageIOWriteParameters() {
        throw new UnsupportedOperationException("This plugin does not support writing parameters");
    }

    public GridCoverageWriter getWriter(Object destination, Hints hints) {
        throw new UnsupportedOperationException("This plugin does not support writing at this time.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean accepts(Object input) {
        boolean closeMe = false;
        ImageInputStream stream = null;
        try {
            if (input == null) {
                throw new NullPointerException("Null input provided");
            }
            if (input instanceof URL) {
                input = DataUtilities.urlToFile((URL)((URL)input));
                closeMe = true;
            }
            if (input instanceof URI) {
                input = DataUtilities.urlToFile((URL)((URI)input).toURL());
                closeMe = true;
            }
            if (input instanceof File) {
                File source = (File)input;
                if (!source.exists() || !source.canRead() || source.isDirectory()) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, "Provided file cannot be read or is it not a file.");
                    }
                    boolean bl = false;
                    return bl;
                }
                closeMe = true;
            }
            if (!(input instanceof File) && !(input instanceof FileImageInputStreamExt)) {
                boolean source = false;
                return source;
            }
            ImageInputStream imageInputStream = stream = input instanceof File ? ImageIO.createImageInputStream(input) : (FileImageInputStreamExt)input;
            if (this.spi == null) {
                ImageReader reader = Utils.getReader(stream);
                if (reader == null) {
                    boolean t = false;
                    return t;
                }
                this.spi = reader.getOriginatingProvider();
            }
            boolean reader = this.spi.canDecodeInput(stream);
            return reader;
        }
        catch (IOException e) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (closeMe && stream != null) {
                try {
                    stream.close();
                }
                catch (Throwable t) {}
            }
        }
    }
}

