/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import junit.framework.TestCase;
import org.easymock.EasyMock;
import org.geotools.data.DataStore;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultFeatureResults;
import org.geotools.data.DefaultQuery;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.opengis.feature.simple.SimpleFeatureType;

public class DefaultFeatureResultsTest
extends TestCase {
    public void testMaxFeatureOptimized() throws Exception {
        DefaultQuery q = new DefaultQuery("roads");
        q.setMaxFeatures(10);
        SimpleFeatureType type = DataUtilities.createType((String)"roads", (String)"_=the_geom:Point,FID:String,NAME:String");
        FeatureSource fs = (FeatureSource)EasyMock.createMock(FeatureSource.class);
        EasyMock.expect((Object)fs.getSchema()).andReturn((Object)type).anyTimes();
        EasyMock.expect((Object)fs.getCount((Query)q)).andReturn((Object)20);
        EasyMock.replay((Object[])new Object[]{fs});
        DefaultFeatureResults results = new DefaultFeatureResults(fs, (Query)q);
        DefaultFeatureResultsTest.assertEquals((int)10, (int)results.size());
    }

    public void testMaxfeaturesHandCount() throws Exception {
        DefaultQuery q = new DefaultQuery("roads");
        q.setMaxFeatures(1);
        FeatureReader fr = (FeatureReader)EasyMock.createNiceMock(FeatureReader.class);
        EasyMock.expect((Object)fr.hasNext()).andReturn((Object)true).times(2).andReturn((Object)false);
        EasyMock.replay((Object[])new Object[]{fr});
        DataStore ds = (DataStore)EasyMock.createMock(DataStore.class);
        EasyMock.expect((Object)ds.getFeatureReader((Query)q, Transaction.AUTO_COMMIT)).andReturn((Object)fr);
        EasyMock.replay((Object[])new Object[]{ds});
        SimpleFeatureType type = DataUtilities.createType((String)"roads", (String)"_=the_geom:Point,FID:String,NAME:String");
        FeatureSource fs = (FeatureSource)EasyMock.createMock(FeatureSource.class);
        EasyMock.expect((Object)fs.getSchema()).andReturn((Object)type).anyTimes();
        EasyMock.expect((Object)fs.getCount((Query)q)).andReturn((Object)-1);
        EasyMock.expect((Object)fs.getDataStore()).andReturn((Object)ds);
        EasyMock.replay((Object[])new Object[]{fs});
        DefaultFeatureResults results = new DefaultFeatureResults(fs, (Query)q);
        DefaultFeatureResultsTest.assertEquals((int)1, (int)results.size());
    }
}

