/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature;

import com.vividsolutions.jts.geom.Point;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.AttributeTypeBuilder;
import org.geotools.feature.FeatureTypes;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.PropertyDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;

public class FeatureTypesTest {
    @Test
    public void testNoLength() {
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName("NoLength");
        builder.add("name", String.class);
        builder.add("geom", Point.class);
        SimpleFeatureType ft = builder.buildFeatureType();
        Assert.assertEquals((long)-1L, (long)FeatureTypes.getFieldLength((PropertyDescriptor)ft.getDescriptor("name")));
        Assert.assertEquals((long)-1L, (long)FeatureTypes.getFieldLength((PropertyDescriptor)ft.getDescriptor("geom")));
    }

    @Test
    public void testStandardLength() {
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName("StdLength");
        builder.length(20);
        builder.add("name", String.class);
        builder.add("geom", Point.class);
        SimpleFeatureType ft = builder.buildFeatureType();
        Assert.assertEquals((long)20L, (long)FeatureTypes.getFieldLength((PropertyDescriptor)ft.getDescriptor("name")));
        Assert.assertEquals((long)-1L, (long)FeatureTypes.getFieldLength((PropertyDescriptor)ft.getDescriptor("geom")));
    }

    @Test
    public void testCustomLengthExpressions() {
        AttributeTypeBuilder builder = new AttributeTypeBuilder();
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        Function length = ff.function("LengthFunction", new Expression[]{ff.property(".")});
        builder.addRestriction((Filter)ff.less((Expression)length, (Expression)ff.literal(20)));
        builder.setBinding(String.class);
        AttributeDescriptor attribute = builder.buildDescriptor("attribute");
        Assert.assertEquals((long)19L, (long)FeatureTypes.getFieldLength((PropertyDescriptor)attribute));
        builder.addRestriction((Filter)ff.greater((Expression)ff.literal(20), (Expression)length));
        builder.setBinding(String.class);
        attribute = builder.buildDescriptor("attribute");
        Assert.assertEquals((long)19L, (long)FeatureTypes.getFieldLength((PropertyDescriptor)attribute));
    }
}

