/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.jts;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.impl.CoordinateArraySequence;
import org.geotools.geometry.jts.Geometries;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.junit.Assert;
import org.junit.Test;

public class GeometriesTest {
    private static GeometryFactory geomFactory = JTSFactoryFinder.getGeometryFactory(null);
    private static final Coordinate[] coords = new Coordinate[]{new Coordinate(0.0, 0.0), new Coordinate(0.0, 10.0), new Coordinate(10.0, 10.0), new Coordinate(10.0, 0.0), new Coordinate(0.0, 0.0)};

    @Test
    public void testGetBinding() {
        System.out.println("   getBinding");
        Assert.assertEquals(Point.class, (Object)Geometries.POINT.getBinding());
        Assert.assertEquals(MultiPoint.class, (Object)Geometries.MULTIPOINT.getBinding());
        Assert.assertEquals(LineString.class, (Object)Geometries.LINESTRING.getBinding());
        Assert.assertEquals(MultiLineString.class, (Object)Geometries.MULTILINESTRING.getBinding());
        Assert.assertEquals(Polygon.class, (Object)Geometries.POLYGON.getBinding());
        Assert.assertEquals(MultiPolygon.class, (Object)Geometries.MULTIPOLYGON.getBinding());
        Assert.assertEquals(Geometry.class, (Object)Geometries.GEOMETRY.getBinding());
        Assert.assertEquals(GeometryCollection.class, (Object)Geometries.GEOMETRYCOLLECTION.getBinding());
    }

    @Test
    public void testGetByObject() {
        System.out.println("   get (by object)");
        Point point = geomFactory.createPoint(coords[0]);
        Assert.assertEquals((Object)Geometries.POINT, (Object)Geometries.get((Geometry)point));
        MultiPoint multiPoint = geomFactory.createMultiPoint(coords);
        Assert.assertEquals((Object)Geometries.MULTIPOINT, (Object)Geometries.get((Geometry)multiPoint));
        LineString line = geomFactory.createLineString(coords);
        Assert.assertEquals((Object)Geometries.LINESTRING, (Object)Geometries.get((Geometry)line));
        LineString[] lines = new LineString[]{geomFactory.createLineString(new Coordinate[]{coords[0], coords[1]}), geomFactory.createLineString(new Coordinate[]{coords[2], coords[3]})};
        MultiLineString multiLine = geomFactory.createMultiLineString(lines);
        Assert.assertEquals((Object)Geometries.MULTILINESTRING, (Object)Geometries.get((Geometry)multiLine));
        Polygon poly = geomFactory.createPolygon(geomFactory.createLinearRing(coords), null);
        Assert.assertEquals((Object)Geometries.POLYGON, (Object)Geometries.get((Geometry)poly));
        Polygon[] polys = new Polygon[]{poly, poly};
        MultiPolygon multiPoly = geomFactory.createMultiPolygon(polys);
        Assert.assertEquals((Object)Geometries.MULTIPOLYGON, (Object)Geometries.get((Geometry)multiPoly));
        GeometryCollection gc = geomFactory.createGeometryCollection((Geometry[])polys);
        Assert.assertEquals((Object)Geometries.GEOMETRYCOLLECTION, (Object)Geometries.get((Geometry)gc));
    }

    @Test
    public void testGetSubclass() {
        class DerivedLine
        extends LineString {
            DerivedLine(CoordinateSequence seq, GeometryFactory gf) {
                super(seq, gf);
            }
        }
        Assert.assertEquals((Object)Geometries.LINESTRING, (Object)Geometries.getForBinding(DerivedLine.class));
        abstract class DerivedGeometry
        extends Geometry {
            DerivedGeometry(GeometryFactory gf) {
                super(gf);
            }
        }
        Assert.assertEquals((Object)Geometries.GEOMETRY, (Object)Geometries.getForBinding(DerivedGeometry.class));
    }

    @Test
    public void testGetSubclassByObject() {
        class DerivedLine
        extends LineString {
            DerivedLine(CoordinateSequence seq, GeometryFactory gf) {
                super(seq, gf);
            }
        }
        DerivedLine p = new DerivedLine((CoordinateSequence)new CoordinateArraySequence(coords), geomFactory);
        Assert.assertEquals((Object)Geometries.LINESTRING, (Object)Geometries.getForBinding(DerivedLine.class));
    }

    @Test
    public void testGetName() {
        System.out.println("   getName and getSimpleName");
        for (Geometries type : Geometries.values()) {
            String className = type.getBinding().getSimpleName();
            Assert.assertTrue((boolean)type.getName().equalsIgnoreCase(className));
            if (className.startsWith("Multi")) {
                Assert.assertTrue((boolean)type.getSimpleName().equalsIgnoreCase(className.substring(5)));
                continue;
            }
            Assert.assertTrue((boolean)type.getSimpleName().equalsIgnoreCase(className));
        }
    }

    @Test
    public void testGetForSQLType() {
        System.out.println("   getSQLType and getForSQLType");
        for (Geometries type : Geometries.values()) {
            int sqlType = type.getSQLType();
            Assert.assertEquals((Object)type, (Object)Geometries.getForSQLType((int)sqlType));
        }
    }
}

