/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import java.awt.Color;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import junit.framework.Assert;
import org.custommonkey.xmlunit.NamespaceContext;
import org.custommonkey.xmlunit.SimpleNamespaceContext;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.styling.ChannelSelectionImpl;
import org.geotools.styling.ColorMap;
import org.geotools.styling.ContrastEnhancementImpl;
import org.geotools.styling.Displacement;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Graphic;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.Mark;
import org.geotools.styling.NamedLayer;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.SLD;
import org.geotools.styling.SLDParser;
import org.geotools.styling.SLDTransformer;
import org.geotools.styling.SelectedChannelType;
import org.geotools.styling.SelectedChannelTypeImpl;
import org.geotools.styling.Stroke;
import org.geotools.styling.Style;
import org.geotools.styling.StyleBuilder;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.StyleFactory2;
import org.geotools.styling.StyledLayer;
import org.geotools.styling.StyledLayerDescriptor;
import org.geotools.styling.Symbolizer;
import org.geotools.styling.TextSymbolizer;
import org.geotools.styling.UomOgcMapping;
import org.junit.Before;
import org.junit.Test;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.PropertyName;
import org.opengis.style.ChannelSelection;
import org.opengis.style.ContrastEnhancement;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class SLDTransformerTest {
    static StyleFactory2 sf = (StyleFactory2)CommonFactoryFinder.getStyleFactory(null);
    static FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2(null);
    static SLDTransformer transformer;

    @Before
    public void setUp() throws Exception {
        transformer = new SLDTransformer();
        transformer.setIndentation(4);
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put("sld", "http://www.opengis.net/sld");
        namespaces.put("ogc", "http://www.opengis.net/ogc");
        namespaces.put("gml", "http://www.opengis.net/gml");
        XMLUnit.setXpathNamespaceContext((NamespaceContext)new SimpleNamespaceContext(namespaces));
    }

    @Test
    public void testEncodingRasterSymbolizer() throws Exception {
        RasterSymbolizer defaultRasterSymbolizer = sf.createRasterSymbolizer();
        String xmlFragment = transformer.transform((Object)defaultRasterSymbolizer);
        Assert.assertNotNull((Object)xmlFragment);
        RasterSymbolizer opacityRasterSymbolizer = sf.createRasterSymbolizer();
        opacityRasterSymbolizer.setOpacity((Expression)ff.literal(1.0));
        xmlFragment = transformer.transform((Object)opacityRasterSymbolizer);
        Assert.assertNotNull((Object)xmlFragment);
        SLDParser parser = new SLDParser((StyleFactory)sf);
        parser.setInput((Reader)new StringReader(xmlFragment));
        StyledLayerDescriptor out = parser.parseSLD();
        Assert.assertNotNull((Object)out);
    }

    @Test
    public void testEncodingStyle() throws Exception {
        RasterSymbolizer defaultRasterSymbolizer = sf.createRasterSymbolizer();
        String xmlFragment = transformer.transform((Object)defaultRasterSymbolizer);
        Assert.assertNotNull((Object)xmlFragment);
        StyleFactory styleFactory = CommonFactoryFinder.getStyleFactory((Hints)GeoTools.getDefaultHints());
        StyleBuilder styleBuilder = new StyleBuilder(styleFactory);
        RasterSymbolizer rasterSymbolizer = styleFactory.createRasterSymbolizer();
        rasterSymbolizer.setOpacity((Expression)CommonFactoryFinder.getFilterFactory((Hints)GeoTools.getDefaultHints()).literal(0.25));
        ChannelSelectionImpl csi = new ChannelSelectionImpl();
        SelectedChannelTypeImpl redChannel = new SelectedChannelTypeImpl();
        redChannel.setChannelName("1");
        ContrastEnhancementImpl rcei = new ContrastEnhancementImpl();
        rcei.setHistogram();
        redChannel.setContrastEnhancement((ContrastEnhancement)rcei);
        SelectedChannelTypeImpl greenChannel = new SelectedChannelTypeImpl();
        greenChannel.setChannelName("4");
        ContrastEnhancementImpl gcei = new ContrastEnhancementImpl();
        gcei.setGammaValue((Expression)ff.literal(2.5));
        greenChannel.setContrastEnhancement((ContrastEnhancement)gcei);
        SelectedChannelTypeImpl blueChannel = new SelectedChannelTypeImpl();
        blueChannel.setChannelName("2");
        ContrastEnhancementImpl bcei = new ContrastEnhancementImpl();
        bcei.setNormalize();
        blueChannel.setContrastEnhancement((ContrastEnhancement)bcei);
        csi.setRGBChannels((SelectedChannelType)redChannel, (SelectedChannelType)greenChannel, (SelectedChannelType)blueChannel);
        rasterSymbolizer.setChannelSelection((ChannelSelection)csi);
        Style style = styleBuilder.createStyle((Symbolizer)rasterSymbolizer);
        style.setName("simpleStyle");
        NamedLayer layer = styleFactory.createNamedLayer();
        layer.addStyle(style);
        StyledLayerDescriptor sld = styleFactory.createStyledLayerDescriptor();
        sld.addStyledLayer((StyledLayer)layer);
        xmlFragment = transformer.transform((Object)sld);
        Assert.assertNotNull((Object)xmlFragment);
        SLDParser parser = new SLDParser((StyleFactory)sf);
        parser.setInput((Reader)new StringReader(xmlFragment));
        Style[] stuff = parser.readXML();
        Style out = stuff[0];
        Assert.assertNotNull((Object)out);
        Assert.assertEquals((Object)0.25, (Object)SLD.rasterOpacity((Style)out));
    }

    @Test
    public void testStroke() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><sld:UserStyle xmlns=\"http://www.opengis.net/sld\" xmlns:sld=\"http://www.opengis.net/sld\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:gml=\"http://www.opengis.net/gml\"><sld:Name>Default Styler</sld:Name><sld:Title>Default Styler</sld:Title><sld:FeatureTypeStyle><sld:Name>simple</sld:Name><sld:Title>title</sld:Title><sld:Abstract>abstract</sld:Abstract><sld:FeatureTypeName>Feature</sld:FeatureTypeName><sld:SemanticTypeIdentifier>generic:geometry</sld:SemanticTypeIdentifier><sld:SemanticTypeIdentifier>simple</sld:SemanticTypeIdentifier><sld:Rule><sld:Title>title</sld:Title><sld:Abstract>abstract</sld:Abstract><sld:MaxScaleDenominator>1.7976931348623157E308</sld:MaxScaleDenominator><sld:LineSymbolizer><sld:Stroke><sld:CssParameter name=\"stroke\"><ogc:Literal>#0000FF</ogc:Literal></sld:CssParameter><sld:CssParameter name=\"stroke-linecap\"><ogc:Literal>butt</ogc:Literal></sld:CssParameter><sld:CssParameter name=\"stroke-linejoin\"><ogc:Literal>miter</ogc:Literal></sld:CssParameter><sld:CssParameter name=\"stroke-opacity\"><ogc:Literal>1.0</ogc:Literal></sld:CssParameter><sld:CssParameter name=\"stroke-width\"><ogc:Literal>2.0</ogc:Literal></sld:CssParameter><sld:CssParameter name=\"stroke-dashoffset\"><ogc:Literal>0.0</ogc:Literal></sld:CssParameter></sld:Stroke></sld:LineSymbolizer></sld:Rule></sld:FeatureTypeStyle></sld:UserStyle>";
        StringReader reader = new StringReader(xml);
        SLDParser sldParser = new SLDParser((StyleFactory)sf, (Reader)reader);
        Style[] parsed = sldParser.readXML();
        Assert.assertNotNull((String)"parsed xml", (Object)parsed);
        Assert.assertTrue((String)"parsed xml into style", (parsed.length > 0 ? 1 : 0) != 0);
        Style style = parsed[0];
        Assert.assertNotNull((Object)style);
        org.opengis.style.Rule rule = (org.opengis.style.Rule)((FeatureTypeStyle)style.featureTypeStyles().get(0)).rules().get(0);
        LineSymbolizer lineSymbolize = (LineSymbolizer)rule.symbolizers().get(0);
        Stroke stroke = lineSymbolize.getStroke();
        Expression color = stroke.getColor();
        Color value = (Color)color.evaluate(null, Color.class);
        Assert.assertNotNull((String)"color", (Object)value);
        Assert.assertEquals((String)"blue", (Object)Color.BLUE, (Object)value);
        Assert.assertEquals((String)"expected width", (int)2, (int)((Integer)stroke.getWidth().evaluate(null, Integer.class)));
    }

    @Test
    public void testTextSymbolizerLabelPalcement() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?><StyledLayerDescriptor version=\"1.0.0\"               xsi:schemaLocation=\"http://www.opengis.net/sld StyledLayerDescriptor.xsd\"               xmlns=\"http://www.opengis.net/sld\"               xmlns:ogc=\"http://www.opengis.net/ogc\"               xmlns:xlink=\"http://www.w3.org/1999/xlink\"               xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">      <NamedLayer>              <Name>Default Line</Name>              <UserStyle>                      <Title>A boring default style</Title>                      <Abstract>A sample style that just prints out a blue line</Abstract>                              <FeatureTypeStyle>                              <Rule>                                      <Name>Rule 1</Name>                                      <Title>Blue Line</Title>                                      <Abstract>A blue line with a 1 pixel width</Abstract>                                      <LineSymbolizer>                                              <Stroke>                                                      <CssParameter name=\"stroke\">#0000ff</CssParameter>                                              </Stroke>                                      </LineSymbolizer>                              </Rule>                              <Rule>                              <TextSymbolizer>                <Label><ogc:PropertyName>name</ogc:PropertyName></Label>                <Font>                    <CssParameter name=\"font-family\">Arial</CssParameter>                    <CssParameter name=\"font-style\">normal</CssParameter>                    <CssParameter name=\"font-size\">12</CssParameter>                    <CssParameter name=\"font-weight\">normal</CssParameter>                </Font>                <LabelPlacement>                      <LinePlacement>                              <PerpendicularOffset>0</PerpendicularOffset>                      </LinePlacement>                </LabelPlacement>                </TextSymbolizer>                              </Rule>                  </FeatureTypeStyle>              </UserStyle>      </NamedLayer></StyledLayerDescriptor>";
        StringReader reader = new StringReader(xml);
        SLDParser sldParser = new SLDParser((StyleFactory)sf, (Reader)reader);
        Style[] parsed = sldParser.readXML();
        Assert.assertNotNull((String)"parsed xml", (Object)parsed);
        Assert.assertTrue((String)"parsed xml into style", (parsed.length > 0 ? 1 : 0) != 0);
        Style style = parsed[0];
        Assert.assertNotNull((Object)style);
        org.opengis.style.Rule rule = (org.opengis.style.Rule)((FeatureTypeStyle)style.featureTypeStyles().get(0)).rules().get(0);
        LineSymbolizer lineSymbolize = (LineSymbolizer)rule.symbolizers().get(0);
        Stroke stroke = lineSymbolize.getStroke();
        Expression color = stroke.getColor();
        Color value = (Color)color.evaluate(null, Color.class);
        Assert.assertNotNull((String)"color", (Object)value);
        Assert.assertEquals((String)"blue", (Object)Color.BLUE, (Object)value);
    }

    @Test
    public void testPointSymbolizer() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><sld:StyledLayerDescriptor xmlns:sld=\"http://www.opengis.net/sld\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:gml=\"http://www.opengis.net/gml\" version=\"1.0.0\">    <sld:UserLayer>       <sld:LayerFeatureConstraints>            <sld:FeatureTypeConstraint/>        </sld:LayerFeatureConstraints>        <sld:UserStyle>            <sld:Name>Default Styler</sld:Name>             <sld:Title>Default Styler</sld:Title>            <sld:Abstract/>            <sld:FeatureTypeStyle>                <sld:Name>simple</sld:Name>                <sld:Title>title</sld:Title>                <sld:Abstract>abstract</sld:Abstract>                <sld:FeatureTypeName>Feature</sld:FeatureTypeName>                <sld:SemanticTypeIdentifier>generic:geometry</sld:SemanticTypeIdentifier>                <sld:SemanticTypeIdentifier>simple</sld:SemanticTypeIdentifier>                <sld:Rule>                    <sld:Name>name</sld:Name>                    <sld:Title>title</sld:Title>                    <sld:Abstract>Abstract</sld:Abstract>                    <sld:MaxScaleDenominator>1.7976931348623157E308</sld:MaxScaleDenominator>                    <sld:PointSymbolizer>                        <sld:Graphic>                            <sld:Mark>                                <sld:WellKnownName>triangle</sld:WellKnownName>                                <sld:Fill>                                    <sld:CssParameter name=\"fill\">                                        <ogc:Literal>#FFFF00</ogc:Literal>                                    </sld:CssParameter>                                    <sld:CssParameter name=\"fill-opacity\">                                        <ogc:Literal>1.0</ogc:Literal>                                    </sld:CssParameter>                                </sld:Fill>                                <sld:Stroke>                                    <sld:CssParameter name=\"stroke\">                                        <ogc:Literal>#008000</ogc:Literal>                                    </sld:CssParameter>                                    <sld:CssParameter name=\"stroke-linecap\">                                        <ogc:Literal>butt</ogc:Literal>                                    </sld:CssParameter>                                    <sld:CssParameter name=\"stroke-linejoin\">                                        <ogc:Literal>miter</ogc:Literal>                                    </sld:CssParameter>                                    <sld:CssParameter name=\"stroke-opacity\">                                        <ogc:Literal>1.0</ogc:Literal>                                    </sld:CssParameter>                                    <sld:CssParameter name=\"stroke-width\">                                        <ogc:Literal>1.0</ogc:Literal>                                    </sld:CssParameter>                                    <sld:CssParameter name=\"stroke-dashoffset\">                                        <ogc:Literal>0.0</ogc:Literal>                                    </sld:CssParameter>                                </sld:Stroke>                            </sld:Mark>                            <sld:Opacity>                                <ogc:Literal>1.0</ogc:Literal>                            </sld:Opacity>                            <sld:Size>                                <ogc:Literal>10.0</ogc:Literal>                            </sld:Size>                            <sld:Rotation>                                <ogc:Literal>0.0</ogc:Literal>                            </sld:Rotation>                        </sld:Graphic>                    </sld:PointSymbolizer>                </sld:Rule>            </sld:FeatureTypeStyle>        </sld:UserStyle>    </sld:UserLayer></sld:StyledLayerDescriptor>";
        StringReader reader = new StringReader(xml);
        SLDParser sldParser = new SLDParser((StyleFactory)sf, (Reader)reader);
        Style[] parsed = sldParser.readXML();
        Assert.assertNotNull((String)"parsed xml", (Object)parsed);
        Assert.assertTrue((String)"parsed xml into style", (parsed.length > 0 ? 1 : 0) != 0);
        Style style = parsed[0];
        Assert.assertNotNull((Object)style);
        org.opengis.style.Rule rule = (org.opengis.style.Rule)((FeatureTypeStyle)style.featureTypeStyles().get(0)).rules().get(0);
        List symbolizers = rule.symbolizers();
        Assert.assertEquals((int)1, (int)symbolizers.size());
        PointSymbolizer symbolize = (PointSymbolizer)symbolizers.get(0);
        Graphic graphic = symbolize.getGraphic();
        List symbols = graphic.graphicalSymbols();
        Assert.assertEquals((int)1, (int)symbols.size());
        Mark mark = (Mark)symbols.get(0);
        Expression color = mark.getFill().getColor();
        Color value = (Color)color.evaluate(null, Color.class);
        Assert.assertNotNull((String)"color", (Object)value);
        Assert.assertEquals((String)"blue", (Object)Color.YELLOW, (Object)value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStrokeWithLogging() throws Exception {
        Logger logger = Logger.getLogger("org.geotools.styling");
        Level before = logger.getLevel();
        try {
            logger.setLevel(Level.FINEST);
            String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><sld:UserStyle xmlns=\"http://www.opengis.net/sld\" xmlns:sld=\"http://www.opengis.net/sld\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:gml=\"http://www.opengis.net/gml\"><sld:Name>Default Styler</sld:Name><sld:Title>Default Styler</sld:Title><sld:FeatureTypeStyle><sld:Name>simple</sld:Name><sld:Title>title</sld:Title><sld:Abstract>abstract</sld:Abstract><sld:FeatureTypeName>Feature</sld:FeatureTypeName><sld:SemanticTypeIdentifier>generic:geometry</sld:SemanticTypeIdentifier><sld:SemanticTypeIdentifier>simple</sld:SemanticTypeIdentifier><sld:Rule><sld:Title>title</sld:Title><sld:Abstract>abstract</sld:Abstract><sld:MaxScaleDenominator>1.7976931348623157E308</sld:MaxScaleDenominator><sld:LineSymbolizer><sld:Stroke><sld:CssParameter name=\"stroke\"><ogc:Literal>#0000FF</ogc:Literal></sld:CssParameter><sld:CssParameter name=\"stroke-linecap\"><ogc:Literal>butt</ogc:Literal></sld:CssParameter><sld:CssParameter name=\"stroke-linejoin\"><ogc:Literal>miter</ogc:Literal></sld:CssParameter><sld:CssParameter name=\"stroke-opacity\"><ogc:Literal>1.0</ogc:Literal></sld:CssParameter><sld:CssParameter name=\"stroke-width\"><ogc:Literal>2.0</ogc:Literal></sld:CssParameter><sld:CssParameter name=\"stroke-dashoffset\"><ogc:Literal>0.0</ogc:Literal></sld:CssParameter></sld:Stroke></sld:LineSymbolizer></sld:Rule></sld:FeatureTypeStyle></sld:UserStyle>";
            StringReader reader = new StringReader(xml);
            SLDParser sldParser = new SLDParser((StyleFactory)sf, (Reader)reader);
            Style[] parsed = sldParser.readXML();
            Assert.assertNotNull((String)"parsed xml", (Object)parsed);
            Assert.assertTrue((String)"parsed xml into style", (parsed.length > 0 ? 1 : 0) != 0);
            Style style = parsed[0];
            Assert.assertNotNull((Object)style);
            org.opengis.style.Rule rule = (org.opengis.style.Rule)((FeatureTypeStyle)style.featureTypeStyles().get(0)).rules().get(0);
            LineSymbolizer lineSymbolize = (LineSymbolizer)rule.symbolizers().get(0);
            Stroke stroke = lineSymbolize.getStroke();
            Expression color = stroke.getColor();
            Color value = (Color)color.evaluate(null, Color.class);
            Assert.assertNotNull((String)"color", (Object)value);
            Assert.assertEquals((String)"blue", (Object)Color.BLUE, (Object)value);
            Assert.assertEquals((String)"expected width", (int)2, (int)((Integer)stroke.getWidth().evaluate(null, Integer.class)));
        }
        finally {
            logger.setLevel(before);
        }
    }

    @Test
    public void testUOMEncodingPointSymbolizer() throws Exception {
        PointSymbolizer pointSymbolizer = sf.createPointSymbolizer();
        pointSymbolizer.setUnitOfMeasure(UomOgcMapping.FOOT.getUnit());
        String xmlFragment = transformer.transform((Object)pointSymbolizer);
        Assert.assertNotNull((Object)xmlFragment);
        SLDParser parser = new SLDParser((StyleFactory)sf);
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            Document dom = null;
            DocumentBuilder db = null;
            db = dbf.newDocumentBuilder();
            dom = db.parse(new InputSource(new StringReader(xmlFragment)));
            PointSymbolizer pointSymbolizer2 = parser.parsePointSymbolizer(dom.getFirstChild());
            Assert.assertTrue((boolean)pointSymbolizer.getUnitOfMeasure().equals((Object)pointSymbolizer2.getUnitOfMeasure()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testUOMEncodingPolygonSymbolizer() throws Exception {
        PolygonSymbolizer polygonSymbolizer = sf.createPolygonSymbolizer();
        polygonSymbolizer.setUnitOfMeasure(UomOgcMapping.METRE.getUnit());
        String xmlFragment = transformer.transform((Object)polygonSymbolizer);
        Assert.assertNotNull((Object)xmlFragment);
        SLDParser parser = new SLDParser((StyleFactory)sf);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        Document dom = null;
        DocumentBuilder db = null;
        db = dbf.newDocumentBuilder();
        dom = db.parse(new InputSource(new StringReader(xmlFragment)));
        PolygonSymbolizer polygonSymbolizer2 = parser.parsePolygonSymbolizer(dom.getFirstChild());
        Assert.assertTrue((boolean)polygonSymbolizer.getUnitOfMeasure().equals((Object)polygonSymbolizer2.getUnitOfMeasure()));
    }

    @Test
    public void testUOMEncodingRasterSymbolizer2() throws Exception {
        RasterSymbolizer rasterSymbolizer = sf.createRasterSymbolizer();
        rasterSymbolizer.setUnitOfMeasure(UomOgcMapping.PIXEL.getUnit());
        String xmlFragment = transformer.transform((Object)rasterSymbolizer);
        Assert.assertNotNull((Object)xmlFragment);
        SLDParser parser = new SLDParser((StyleFactory)sf);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        Document dom = null;
        DocumentBuilder db = null;
        db = dbf.newDocumentBuilder();
        dom = db.parse(new InputSource(new StringReader(xmlFragment)));
        RasterSymbolizer rasterSymbolizer2 = parser.parseRasterSymbolizer(dom.getFirstChild());
        Assert.assertTrue((boolean)rasterSymbolizer.getUnitOfMeasure().equals((Object)rasterSymbolizer2.getUnitOfMeasure()));
    }

    @Test
    public void testUOMEncodingLineSymbolizer() throws Exception {
        LineSymbolizer lineSymbolizer = sf.createLineSymbolizer();
        lineSymbolizer.setUnitOfMeasure(UomOgcMapping.METRE.getUnit());
        String xmlFragment = transformer.transform((Object)lineSymbolizer);
        Assert.assertNotNull((Object)xmlFragment);
        SLDParser parser = new SLDParser((StyleFactory)sf);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        Document dom = null;
        DocumentBuilder db = null;
        db = dbf.newDocumentBuilder();
        dom = db.parse(new InputSource(new StringReader(xmlFragment)));
        LineSymbolizer lineSymbolizer2 = parser.parseLineSymbolizer(dom.getFirstChild());
        Assert.assertTrue((boolean)lineSymbolizer.getUnitOfMeasure().equals((Object)lineSymbolizer2.getUnitOfMeasure()));
    }

    @Test
    public void testUOMEncodingTextSymbolizer() throws Exception {
        TextSymbolizer textSymbolizer = sf.createTextSymbolizer();
        textSymbolizer.setUnitOfMeasure(UomOgcMapping.FOOT.getUnit());
        String xmlFragment = transformer.transform((Object)textSymbolizer);
        Assert.assertNotNull((Object)xmlFragment);
        xmlFragment = transformer.transform((Object)textSymbolizer);
        Assert.assertNotNull((Object)xmlFragment);
        SLDParser parser = new SLDParser((StyleFactory)sf);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        Document dom = null;
        DocumentBuilder db = null;
        db = dbf.newDocumentBuilder();
        dom = db.parse(new InputSource(new StringReader(xmlFragment)));
        TextSymbolizer textSymbolizer2 = parser.parseTextSymbolizer(dom.getFirstChild());
        Assert.assertTrue((boolean)textSymbolizer.getUnitOfMeasure().equals((Object)textSymbolizer2.getUnitOfMeasure()));
    }

    @Test
    public void testNullUOMEncodingPointSymbolizer() throws Exception {
        PointSymbolizer pointSymbolizer = sf.createPointSymbolizer();
        String xmlFragment = transformer.transform((Object)pointSymbolizer);
        Assert.assertNotNull((Object)xmlFragment);
        SLDParser parser = new SLDParser((StyleFactory)sf);
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            Document dom = null;
            DocumentBuilder db = null;
            db = dbf.newDocumentBuilder();
            dom = db.parse(new InputSource(new StringReader(xmlFragment)));
            PointSymbolizer pointSymbolizer2 = parser.parsePointSymbolizer(dom.getFirstChild());
            Assert.assertTrue((pointSymbolizer2.getUnitOfMeasure() == null ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testNullUOMEncodingPolygonSymbolizer() throws Exception {
        PolygonSymbolizer polygonSymbolizer = sf.createPolygonSymbolizer();
        String xmlFragment = transformer.transform((Object)polygonSymbolizer);
        Assert.assertNotNull((Object)xmlFragment);
        SLDParser parser = new SLDParser((StyleFactory)sf);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        Document dom = null;
        DocumentBuilder db = null;
        db = dbf.newDocumentBuilder();
        dom = db.parse(new InputSource(new StringReader(xmlFragment)));
        PolygonSymbolizer polygonSymbolizer2 = parser.parsePolygonSymbolizer(dom.getFirstChild());
        Assert.assertTrue((polygonSymbolizer2.getUnitOfMeasure() == null ? 1 : 0) != 0);
    }

    @Test
    public void testNullUOMEncodingRasterSymbolizer2() throws Exception {
        RasterSymbolizer rasterSymbolizer = sf.createRasterSymbolizer();
        String xmlFragment = transformer.transform((Object)rasterSymbolizer);
        Assert.assertNotNull((Object)xmlFragment);
        SLDParser parser = new SLDParser((StyleFactory)sf);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        Document dom = null;
        DocumentBuilder db = null;
        db = dbf.newDocumentBuilder();
        dom = db.parse(new InputSource(new StringReader(xmlFragment)));
        RasterSymbolizer rasterSymbolizer2 = parser.parseRasterSymbolizer(dom.getFirstChild());
        Assert.assertTrue((rasterSymbolizer2.getUnitOfMeasure() == null ? 1 : 0) != 0);
    }

    @Test
    public void testNullUOMEncodingLineSymbolizer() throws Exception {
        LineSymbolizer lineSymbolizer = sf.createLineSymbolizer();
        String xmlFragment = transformer.transform((Object)lineSymbolizer);
        Assert.assertNotNull((Object)xmlFragment);
        SLDParser parser = new SLDParser((StyleFactory)sf);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        Document dom = null;
        DocumentBuilder db = null;
        db = dbf.newDocumentBuilder();
        dom = db.parse(new InputSource(new StringReader(xmlFragment)));
        LineSymbolizer lineSymbolizer2 = parser.parseLineSymbolizer(dom.getFirstChild());
        Assert.assertTrue((lineSymbolizer2.getUnitOfMeasure() == null ? 1 : 0) != 0);
    }

    @Test
    public void testNullUOMEncodingTextSymbolizer() throws Exception {
        TextSymbolizer textSymbolizer = sf.createTextSymbolizer();
        String xmlFragment = transformer.transform((Object)textSymbolizer);
        Assert.assertNotNull((Object)xmlFragment);
        SLDParser parser = new SLDParser((StyleFactory)sf);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        Document dom = null;
        DocumentBuilder db = null;
        db = dbf.newDocumentBuilder();
        dom = db.parse(new InputSource(new StringReader(xmlFragment)));
        TextSymbolizer textSymbolizer2 = parser.parseTextSymbolizer(dom.getFirstChild());
        Assert.assertTrue((textSymbolizer2.getUnitOfMeasure() == null ? 1 : 0) != 0);
    }

    @Test
    public void testDisplacement() throws Exception {
        StyleBuilder sb = new StyleBuilder();
        Graphic graphic = sb.createGraphic();
        Displacement disp = sb.createDisplacement(10.1, -5.5);
        graphic.setDisplacement((org.opengis.style.Displacement)disp);
        SLDTransformer st = new SLDTransformer();
        String xml = st.transform((Object)graphic);
        Assert.assertTrue((String)"XML transformation of this GraphicImpl does not contain the word 'Displacement' ", (boolean)xml.contains("Displacement"));
    }

    @Test
    public void testTextSymbolizerTransformOutAndInAndOutAgain() throws Exception {
        StyleBuilder sb = new StyleBuilder();
        Style style = sb.createStyle((Symbolizer)sb.createTextSymbolizer());
        SLDTransformer st = new SLDTransformer();
        String firstExport = st.transform((Object)style);
        SLDParser sldp = new SLDParser(CommonFactoryFinder.getStyleFactory(null));
        sldp.setInput((Reader)new StringReader(firstExport));
        Style[] firstImport = sldp.readXML();
        Assert.assertNotNull((Object)firstImport[0]);
        String secondExport = st.transform((Object)firstImport);
    }

    @Test
    public void testPriorityTransformOutAndIn() throws Exception {
        StyleBuilder sb = new StyleBuilder();
        TextSymbolizer ts = sb.createTextSymbolizer();
        PropertyName literalPrio = CommonFactoryFinder.getFilterFactory2(null).property("quantVariable");
        ts.setPriority((Expression)literalPrio);
        Style style = sb.createStyle((Symbolizer)ts);
        SLDTransformer st = new SLDTransformer();
        String firstExport = st.transform((Object)style);
        SLDParser sldp = new SLDParser(CommonFactoryFinder.getStyleFactory(null));
        sldp.setInput((Reader)new StringReader(firstExport));
        Style[] firstImport = sldp.readXML();
        Assert.assertNotNull((Object)firstImport[0]);
        Style reimportedStyle = firstImport[0];
        TextSymbolizer reimportedTs = (TextSymbolizer)((Rule)((FeatureTypeStyle)reimportedStyle.featureTypeStyles().get(0)).rules().get(0)).symbolizers().get(0);
        Assert.assertNotNull((Object)reimportedTs.getPriority());
        Assert.assertEquals((String)"quantVariable", (String)reimportedTs.getPriority().toString());
        String secondExport = st.transform((Object)firstImport);
        SLDParser sldp2 = new SLDParser(CommonFactoryFinder.getStyleFactory(null));
        sldp2.setInput((Reader)new StringReader(secondExport));
        Style[] readXML = sldp2.readXML();
        Style reimportedStyle2 = readXML[0];
        TextSymbolizer reimportedTs2 = (TextSymbolizer)((Rule)((FeatureTypeStyle)reimportedStyle2.featureTypeStyles().get(0)).rules().get(0)).symbolizers().get(0);
        Assert.assertNotNull((Object)reimportedTs2.getPriority());
        Assert.assertEquals((String)"quantVariable", (String)reimportedTs2.getPriority().toString());
    }

    @Test
    public void testColorMap() throws Exception {
        SLDTransformer st = new SLDTransformer();
        ColorMap cm = sf.createColorMap();
        cm.setType(3);
        Assert.assertTrue((String)"parsed xml must contain attribbute type with correct value", (boolean)st.transform((Object)cm).contains("type=\"values\""));
        cm.setType(2);
        Assert.assertTrue((String)"parsed xml must contain attribbute type with correct value", (boolean)st.transform((Object)cm).contains("type=\"intervals\""));
        cm.setType(1);
        Assert.assertEquals((String)"parsed xml must contain attribbute type with correct value", (int)-1, (int)st.transform((Object)cm).indexOf("type="));
    }

    @Test
    public void testMinimumLineSymbolizer() throws Exception {
        StyleBuilder sb = new StyleBuilder();
        LineSymbolizer ls = sb.createLineSymbolizer();
        String xml = transformer.transform((Object)ls);
        Document doc = XMLUnit.buildTestDocument((String)xml);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/sld:LineSymbolizer/*)", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(/sld:LineSymbolizer/sld:Stroke/*)", (Document)doc);
        ls.getStroke().setWidth((Expression)ff.literal(3));
        ls.getStroke().setColor((Expression)ff.literal((Object)Color.YELLOW));
        ls.getStroke().setOpacity((Expression)ff.literal(1));
        xml = transformer.transform((Object)ls);
        doc = XMLUnit.buildTestDocument((String)xml);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/sld:LineSymbolizer/*)", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"2", (String)"count(/sld:LineSymbolizer/sld:Stroke/*)", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"#FFFF00", (String)"/sld:LineSymbolizer/sld:Stroke/sld:CssParameter[@name='stroke']", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"3", (String)"/sld:LineSymbolizer/sld:Stroke/sld:CssParameter[@name='stroke-width']", (Document)doc);
    }

    @Test
    public void testMinimumPolygonSymbolizer() throws Exception {
        StyleBuilder sb = new StyleBuilder();
        PolygonSymbolizer ps = sb.createPolygonSymbolizer();
        String xml = transformer.transform((Object)ps);
        Document doc = XMLUnit.buildTestDocument((String)xml);
        XMLAssert.assertXpathEvaluatesTo((String)"2", (String)"count(/sld:PolygonSymbolizer/*)", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(/sld:PolygonSymbolizer/sld:Stroke/*)", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(/sld:PolygonSymbolizer/sld:Fill/*)", (Document)doc);
        ps.getFill().setColor((Expression)ff.literal((Object)Color.BLUE));
        xml = transformer.transform((Object)ps);
        doc = XMLUnit.buildTestDocument((String)xml);
        XMLAssert.assertXpathEvaluatesTo((String)"2", (String)"count(/sld:PolygonSymbolizer/*)", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(/sld:PolygonSymbolizer/sld:Stroke/*)", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/sld:PolygonSymbolizer/sld:Fill/*)", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"#0000FF", (String)"/sld:PolygonSymbolizer/sld:Fill/sld:CssParameter[@name='fill']", (Document)doc);
    }

    @Test
    public void testMinimumPointSymbolizer() throws Exception {
        StyleBuilder sb = new StyleBuilder();
        PointSymbolizer ps = sb.createPointSymbolizer();
        String xml = transformer.transform((Object)ps);
        Document doc = XMLUnit.buildTestDocument((String)xml);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/sld:PointSymbolizer/*)", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/sld:PointSymbolizer/sld:Graphic/*)", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"2", (String)"count(/sld:PointSymbolizer/sld:Graphic/sld:Mark/*)", (Document)doc);
        XMLAssert.assertXpathExists((String)"/sld:PointSymbolizer/sld:Graphic/sld:Mark/sld:Fill", (Document)doc);
        XMLAssert.assertXpathExists((String)"/sld:PointSymbolizer/sld:Graphic/sld:Mark/sld:Stroke", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(/sld:PointSymbolizer/sld:Graphic/sld:Mark/sld:Fill/*)", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(/sld:PointSymbolizer/sld:Graphic/sld:Mark/sld:Stroke/*)", (Document)doc);
    }

    @Test
    public void testMinimumRasterSymbolizer() throws Exception {
        StyleBuilder sb = new StyleBuilder();
        RasterSymbolizer rs = sb.getStyleFactory().createRasterSymbolizer();
        String xml = transformer.transform((Object)rs);
        Document doc = XMLUnit.buildTestDocument((String)xml);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/sld:RasterSymbolizer/*)", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"grid", (String)"/sld:RasterSymbolizer/sld:Geometry/ogc:PropertyName", (Document)doc);
    }

    @Test
    public void testMinimumStyle() throws Exception {
        StyleBuilder sb = new StyleBuilder();
        Style s = sb.createStyle((Symbolizer)sb.createPointSymbolizer());
        String xml = transformer.transform((Object)s);
        Document doc = XMLUnit.buildTestDocument((String)xml);
        XMLAssert.assertXpathEvaluatesTo((String)"2", (String)"count(/sld:UserStyle/sld:FeatureTypeStyle/*)", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/sld:UserStyle/sld:FeatureTypeStyle/sld:Name)", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/sld:UserStyle/sld:FeatureTypeStyle/sld:Rule)", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/sld:UserStyle/sld:FeatureTypeStyle/sld:Rule/*)", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/sld:UserStyle/sld:FeatureTypeStyle/sld:Rule/sld:PointSymbolizer)", (Document)doc);
    }

    @Test
    public void testDefaultStyle() throws Exception {
        StyleBuilder sb = new StyleBuilder();
        Style s = sb.createStyle((Symbolizer)sb.createPointSymbolizer());
        s.setDefault(true);
        StyleFactory sf = sb.getStyleFactory();
        StyledLayerDescriptor sld = sf.createStyledLayerDescriptor();
        NamedLayer layer = sf.createNamedLayer();
        layer.setName("layerName");
        layer.addStyle(s);
        sld.addStyledLayer((StyledLayer)layer);
        String xml = transformer.transform((Object)sld);
        Document doc = XMLUnit.buildTestDocument((String)xml);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"/sld:StyledLayerDescriptor/sld:NamedLayer/sld:UserStyle/sld:IsDefault", (Document)doc);
    }
}

