/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import junit.framework.TestCase;
import org.geotools.factory.Hints;
import org.geotools.util.Converter;
import org.geotools.util.ConverterFactory;
import org.geotools.util.TemporalConverterFactory;

public class TemporalConverterFactoryTest
extends TestCase {
    TemporalConverterFactory factory;

    protected void setUp() throws Exception {
        this.factory = new TemporalConverterFactory();
    }

    public void testStitchInTime() throws Exception {
        Converter converter = this.factory.createConverter(Calendar.class, Date.class, null);
        Calendar calendar = Calendar.getInstance();
        calendar.set(2004, 6, 1);
        for (int i = 1; i <= 12; ++i) {
            calendar.set(5, 1);
            Date date = (Date)converter.convert((Object)calendar, Date.class);
            TemporalConverterFactoryTest.pause();
            TemporalConverterFactoryTest.assertNotNull((Object)date);
            TemporalConverterFactoryTest.assertEquals((Object)calendar.getTime(), (Object)date);
        }
        calendar.set(2004, 6, 1, 12, 30);
        Date date = (Date)converter.convert((Object)calendar, Date.class);
        TemporalConverterFactoryTest.pause();
        TemporalConverterFactoryTest.assertNotNull((Object)date);
        TemporalConverterFactoryTest.assertEquals((Object)calendar.getTime(), (Object)date);
    }

    public static void pause() {
        long pause = System.currentTimeMillis() + 15L;
        while (System.currentTimeMillis() < pause) {
            Thread.yield();
        }
    }

    public void testCalendarToDate() throws Exception {
        Calendar calendar = Calendar.getInstance();
        TemporalConverterFactoryTest.assertNotNull((Object)this.factory.createConverter(Calendar.class, Date.class, null));
        Date date = (Date)this.factory.createConverter(Calendar.class, Date.class, null).convert((Object)calendar, Date.class);
        TemporalConverterFactoryTest.assertNotNull((Object)date);
        TemporalConverterFactoryTest.assertEquals((Object)calendar.getTime(), (Object)date);
    }

    public void testCalendarToTime() throws Exception {
        Calendar calendar = Calendar.getInstance();
        TemporalConverterFactoryTest.assertNotNull((Object)this.factory.createConverter(Calendar.class, Time.class, null));
        Time time = (Time)this.factory.createConverter(Calendar.class, Time.class, null).convert((Object)calendar, Time.class);
        TemporalConverterFactoryTest.assertNotNull((Object)time);
        TemporalConverterFactoryTest.assertEquals((Object)new Time(calendar.getTime().getTime()), (Object)time);
    }

    public void testCalendarToTimestamp() throws Exception {
        Calendar calendar = Calendar.getInstance();
        TemporalConverterFactoryTest.assertNotNull((Object)this.factory.createConverter(Calendar.class, Timestamp.class, null));
        Timestamp timeStamp = (Timestamp)this.factory.createConverter(Calendar.class, Timestamp.class, null).convert((Object)calendar, Timestamp.class);
        TemporalConverterFactoryTest.assertNotNull((Object)timeStamp);
        TemporalConverterFactoryTest.assertEquals((Object)new Timestamp(calendar.getTime().getTime()), (Object)timeStamp);
    }

    public void testDateToCalendar() throws Exception {
        Date date = new Date();
        TemporalConverterFactoryTest.assertNotNull((Object)this.factory.createConverter(Date.class, Calendar.class, null));
        Calendar calendar = (Calendar)this.factory.createConverter(Date.class, Calendar.class, null).convert((Object)date, Calendar.class);
        TemporalConverterFactoryTest.assertNotNull((Object)calendar);
        TemporalConverterFactoryTest.assertEquals((Object)date, (Object)calendar.getTime());
    }

    public void testDateToTime() throws Exception {
        Date date = new Date();
        TemporalConverterFactoryTest.assertNotNull((Object)this.factory.createConverter(Date.class, Time.class, null));
        Time time = (Time)this.factory.createConverter(Date.class, Time.class, null).convert((Object)date, Time.class);
        TemporalConverterFactoryTest.assertNotNull((Object)time);
        TemporalConverterFactoryTest.assertEquals((Object)new Time(date.getTime()), (Object)time);
    }

    public void testDateToTimestamp() throws Exception {
        Date date = new Date();
        TemporalConverterFactoryTest.assertNotNull((Object)this.factory.createConverter(Date.class, Timestamp.class, null));
        Timestamp timeStamp = (Timestamp)this.factory.createConverter(Date.class, Timestamp.class, null).convert((Object)date, Timestamp.class);
        TemporalConverterFactoryTest.assertNotNull((Object)timeStamp);
        TemporalConverterFactoryTest.assertEquals((Object)new Timestamp(date.getTime()), (Object)timeStamp);
        Hints h = new Hints();
        h.put((Object)ConverterFactory.SAFE_CONVERSION, (Object)new Boolean(true));
        TemporalConverterFactoryTest.assertNull((Object)this.factory.createConverter(Timestamp.class, Calendar.class, h));
        h.put((Object)ConverterFactory.SAFE_CONVERSION, (Object)new Boolean(false));
        TemporalConverterFactoryTest.assertNotNull((Object)this.factory.createConverter(Timestamp.class, Calendar.class, h));
    }

    public void testTimeToCalendar() throws Exception {
        Time time = new Time(new Date().getTime());
        TemporalConverterFactoryTest.assertNotNull((Object)this.factory.createConverter(Time.class, Calendar.class, null));
        Calendar calendar = (Calendar)this.factory.createConverter(Time.class, Calendar.class, null).convert((Object)time, Calendar.class);
        TemporalConverterFactoryTest.assertNotNull((Object)calendar);
        TemporalConverterFactoryTest.assertEquals((Object)time, (Object)new Time(calendar.getTime().getTime()));
    }

    public void testTimestampToCalendar() throws Exception {
        Timestamp timeStamp = new Timestamp(new Date().getTime());
        TemporalConverterFactoryTest.assertNotNull((Object)this.factory.createConverter(Timestamp.class, Calendar.class, null));
        Calendar calendar = (Calendar)this.factory.createConverter(Timestamp.class, Calendar.class, null).convert((Object)timeStamp, Calendar.class);
        TemporalConverterFactoryTest.assertNotNull((Object)calendar);
        TemporalConverterFactoryTest.assertEquals((Object)timeStamp, (Object)new Timestamp(calendar.getTime().getTime()));
    }

    public void testXMLGregorianCalendarToCalendar() throws Exception {
        XMLGregorianCalendar gc = DatatypeFactory.newInstance().newXMLGregorianCalendar("1981-06-20T12:00:00");
        TemporalConverterFactoryTest.assertNotNull((Object)this.factory.createConverter(XMLGregorianCalendar.class, Calendar.class, null));
        Calendar calendar = (Calendar)this.factory.createConverter(XMLGregorianCalendar.class, Calendar.class, null).convert((Object)gc, Calendar.class);
        TemporalConverterFactoryTest.assertNotNull((Object)calendar);
        TemporalConverterFactoryTest.assertEquals((int)1981, (int)calendar.get(1));
        TemporalConverterFactoryTest.assertEquals((int)5, (int)calendar.get(2));
        TemporalConverterFactoryTest.assertEquals((int)20, (int)calendar.get(5));
        TemporalConverterFactoryTest.assertEquals((int)12, (int)calendar.get(11));
        TemporalConverterFactoryTest.assertEquals((int)0, (int)calendar.get(12));
        TemporalConverterFactoryTest.assertEquals((int)0, (int)calendar.get(13));
    }

    public void testCalendarToXMLGregorianCalendar() throws Exception {
        Calendar calendar = Calendar.getInstance();
        TemporalConverterFactoryTest.assertNotNull((Object)this.factory.createConverter(Calendar.class, XMLGregorianCalendar.class, null));
        XMLGregorianCalendar gc = (XMLGregorianCalendar)this.factory.createConverter(Calendar.class, XMLGregorianCalendar.class, null).convert((Object)calendar, XMLGregorianCalendar.class);
        TemporalConverterFactoryTest.assertNotNull((Object)gc);
        GregorianCalendar actual = gc.toGregorianCalendar();
        TemporalConverterFactoryTest.assertEquals((int)calendar.get(1), (int)actual.get(1));
        TemporalConverterFactoryTest.assertEquals((int)calendar.get(2), (int)actual.get(2));
        TemporalConverterFactoryTest.assertEquals((int)calendar.get(5), (int)actual.get(5));
        TemporalConverterFactoryTest.assertEquals((int)calendar.get(11), (int)actual.get(11));
        TemporalConverterFactoryTest.assertEquals((int)calendar.get(12), (int)actual.get(12));
        TemporalConverterFactoryTest.assertEquals((int)calendar.get(13), (int)actual.get(13));
        TemporalConverterFactoryTest.assertEquals((int)calendar.get(14), (int)actual.get(14));
    }

    public void testXMLGregorianCalendarToDate() throws Exception {
        XMLGregorianCalendar gc = DatatypeFactory.newInstance().newXMLGregorianCalendar("1981-06-20T12:00:00");
        TemporalConverterFactoryTest.assertNotNull((Object)this.factory.createConverter(XMLGregorianCalendar.class, Date.class, null));
        Date date = (Date)this.factory.createConverter(XMLGregorianCalendar.class, Date.class, null).convert((Object)gc, Date.class);
        TemporalConverterFactoryTest.assertNotNull((Object)date);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        TemporalConverterFactoryTest.assertEquals((int)1981, (int)calendar.get(1));
        TemporalConverterFactoryTest.assertEquals((int)5, (int)calendar.get(2));
        TemporalConverterFactoryTest.assertEquals((int)20, (int)calendar.get(5));
        TemporalConverterFactoryTest.assertEquals((int)12, (int)calendar.get(11));
        TemporalConverterFactoryTest.assertEquals((int)0, (int)calendar.get(12));
        TemporalConverterFactoryTest.assertEquals((int)0, (int)calendar.get(13));
    }

    public void testDateToXMLGregorianCalendar() throws Exception {
        Date date = new Date();
        TemporalConverterFactoryTest.assertNotNull((Object)this.factory.createConverter(Date.class, XMLGregorianCalendar.class, null));
        XMLGregorianCalendar gc = (XMLGregorianCalendar)this.factory.createConverter(Date.class, XMLGregorianCalendar.class, null).convert((Object)date, XMLGregorianCalendar.class);
        TemporalConverterFactoryTest.assertNotNull((Object)gc);
        TemporalConverterFactoryTest.assertEquals((Object)date, (Object)gc.toGregorianCalendar().getTime());
    }
}

