/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.geotools.data.FeatureReader;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.IllegalAttributeException;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionFeatureReader
implements FeatureReader<SimpleFeatureType, SimpleFeature> {
    private SimpleFeatureCollection collection;
    private Iterator features;
    private SimpleFeatureType type;
    private boolean closed = false;

    public CollectionFeatureReader(Collection featuresArg, SimpleFeatureType typeArg) {
        assert (!featuresArg.isEmpty());
        if (featuresArg instanceof FeatureCollection) {
            this.collection = (SimpleFeatureCollection)featuresArg;
        }
        this.features = featuresArg.iterator();
        this.type = typeArg;
    }

    public CollectionFeatureReader(SimpleFeatureCollection featuresArg, SimpleFeatureType typeArg) {
        assert (!featuresArg.isEmpty());
        this.collection = featuresArg;
        this.features = featuresArg.iterator();
        this.type = typeArg;
    }

    public CollectionFeatureReader(SimpleFeature[] featuresArg) {
        assert (featuresArg.length > 0);
        this.features = Arrays.asList(featuresArg).iterator();
        this.type = featuresArg[0].getFeatureType();
    }

    public SimpleFeatureType getFeatureType() {
        return this.type;
    }

    public SimpleFeature next() throws IOException, IllegalAttributeException, NoSuchElementException {
        if (this.closed) {
            throw new NoSuchElementException("Reader has been closed");
        }
        return (SimpleFeature)this.features.next();
    }

    public boolean hasNext() throws IOException {
        return this.features.hasNext() && !this.closed;
    }

    public void close() throws IOException {
        this.closed = true;
        if (this.collection != null) {
            this.collection.close(this.features);
        }
    }
}

