/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.collection;

import com.vividsolutions.jts.geom.Envelope;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.geotools.data.Query;
import org.geotools.data.collection.CollectionFeatureSource;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.collection.AbstractFeatureCollection;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.sort.SortBy;
import org.opengis.geometry.BoundingBox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListFeatureCollection
extends AbstractFeatureCollection {
    private List<SimpleFeature> list;
    private ReferencedEnvelope bounds = null;

    public ListFeatureCollection(SimpleFeatureType schema) {
        this(schema, new ArrayList<SimpleFeature>());
    }

    public ListFeatureCollection(SimpleFeatureType schema, List<SimpleFeature> list) {
        super(schema);
        this.list = list;
    }

    @Override
    public int size() {
        return this.list.size();
    }

    protected Iterator openIterator() {
        Iterator<SimpleFeature> it = this.list.iterator();
        return it;
    }

    protected void closeIterator(Iterator close) {
    }

    @Override
    public boolean add(SimpleFeature f) {
        BoundingBox boundingBox = f.getBounds();
        if (this.bounds == null) {
            this.bounds = new ReferencedEnvelope(boundingBox.getMinX(), boundingBox.getMaxX(), boundingBox.getMinY(), boundingBox.getMaxY(), this.schema.getCoordinateReferenceSystem());
        } else {
            this.bounds.expandToInclude(boundingBox.getMinX(), boundingBox.getMinY());
            this.bounds.expandToInclude(boundingBox.getMaxX(), boundingBox.getMaxY());
        }
        return this.list.add(f);
    }

    @Override
    public void clear() {
        this.bounds = null;
        super.clear();
    }

    @Override
    public SimpleFeatureIterator features() {
        return new ListFeatureIterator(this.list);
    }

    @Override
    public synchronized ReferencedEnvelope getBounds() {
        if (this.bounds == null) {
            this.bounds = this.calculateBounds();
        }
        return this.bounds;
    }

    private ReferencedEnvelope calculateBounds() {
        ReferencedEnvelope extent = new ReferencedEnvelope();
        for (SimpleFeature feature : this.list) {
            ReferencedEnvelope bbox;
            if (feature == null || (bbox = ReferencedEnvelope.reference((BoundingBox)feature.getBounds())) == null || bbox.isEmpty() || bbox.isNull()) continue;
            extent.expandToInclude((Envelope)bbox);
        }
        return new ReferencedEnvelope((Envelope)extent, this.schema.getCoordinateReferenceSystem());
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public SimpleFeatureCollection subCollection(Filter filter) {
        CollectionFeatureSource temp = new CollectionFeatureSource(this);
        return temp.getFeatures(filter);
    }

    @Override
    public SimpleFeatureCollection sort(SortBy order) {
        Query subQuery = new Query(this.getSchema().getTypeName());
        subQuery.setSortBy(new SortBy[]{order});
        CollectionFeatureSource temp = new CollectionFeatureSource(this);
        return temp.getFeatures(subQuery);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ListFeatureIterator
    implements SimpleFeatureIterator {
        private Iterator<SimpleFeature> iter;

        public ListFeatureIterator(List<SimpleFeature> features) {
            this.iter = features.iterator();
        }

        public void close() {
            if (this.iter instanceof FeatureIterator) {
                ((FeatureIterator)this.iter).close();
            }
        }

        public boolean hasNext() {
            return this.iter.hasNext();
        }

        public SimpleFeature next() throws NoSuchElementException {
            return this.iter.next();
        }
    }
}

