/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import java.util.logging.Logger;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.filter.IllegalFilterException;
import org.geotools.styling.LinePlacement;
import org.geotools.styling.StyleVisitor;
import org.geotools.util.Utilities;
import org.geotools.util.logging.Logging;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;
import org.opengis.style.LabelPlacement;
import org.opengis.util.Cloneable;

public class LinePlacementImpl
implements LinePlacement,
Cloneable {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.core");
    private FilterFactory filterFactory;
    private Expression perpendicularOffset;
    private boolean generalized;
    private boolean aligned;
    private boolean repeated;
    private Expression gap;
    private Expression initialGap;

    public LinePlacementImpl() {
        this(CommonFactoryFinder.getFilterFactory((Hints)GeoTools.getDefaultHints()));
    }

    public LinePlacementImpl(org.opengis.style.LinePlacement placement) {
        this.gap = placement.getGap();
        this.initialGap = placement.getInitialGap();
        this.generalized = placement.isGeneralizeLine();
        this.perpendicularOffset = placement.getPerpendicularOffset();
        this.repeated = placement.isRepeated();
        this.aligned = placement.IsAligned();
    }

    public LinePlacementImpl(FilterFactory factory) {
        this(factory, false, false, false, null, null);
    }

    public LinePlacementImpl(FilterFactory factory, boolean aligned, boolean repeated, boolean generalized, Expression gap, Expression initialGap) {
        this.filterFactory = factory;
        this.gap = gap;
        this.initialGap = initialGap;
        this.generalized = generalized;
        this.aligned = aligned;
        this.repeated = repeated;
        this.init();
    }

    @Deprecated
    public void setFilterFactory(FilterFactory factory) {
        this.filterFactory = factory;
        this.init();
    }

    private void init() {
        try {
            this.perpendicularOffset = this.filterFactory.literal(0);
        }
        catch (IllegalFilterException ife) {
            LOGGER.severe("Failed to build defaultLinePlacement: " + (Object)((Object)ife));
        }
    }

    public Expression getPerpendicularOffset() {
        return this.perpendicularOffset;
    }

    public void setPerpendicularOffset(Expression perpendicularOffset) {
        this.perpendicularOffset = perpendicularOffset;
    }

    public Expression getInitialGap() {
        return this.initialGap;
    }

    public Expression getGap() {
        return this.gap;
    }

    public boolean isRepeated() {
        return this.repeated;
    }

    public boolean IsAligned() {
        return this.aligned;
    }

    public boolean isAligned() {
        return this.aligned;
    }

    public boolean isGeneralizeLine() {
        return this.generalized;
    }

    public Object accept(org.opengis.style.StyleVisitor visitor, Object data) {
        return visitor.visit((org.opengis.style.LinePlacement)this, data);
    }

    public void accept(StyleVisitor visitor) {
        visitor.visit((LinePlacement)this);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("This can not happen");
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof LinePlacementImpl) {
            LinePlacementImpl other = (LinePlacementImpl)obj;
            return Utilities.equals((Object)this.perpendicularOffset, (Object)other.perpendicularOffset) && Utilities.equals((boolean)this.repeated, (boolean)other.repeated) && Utilities.equals((boolean)this.generalized, (boolean)other.generalized) && Utilities.equals((boolean)this.aligned, (boolean)other.aligned) && Utilities.equals((Object)this.initialGap, (Object)other.initialGap) && Utilities.equals((Object)this.gap, (Object)other.gap);
        }
        return false;
    }

    public int hashCode() {
        int PRIME = 37;
        int result = 17;
        if (this.perpendicularOffset != null) {
            result = result * 37 + this.perpendicularOffset.hashCode();
        }
        if (this.gap != null) {
            result = result * 37 + this.gap.hashCode();
        }
        if (this.initialGap != null) {
            result = result * 37 + this.initialGap.hashCode();
        }
        result = result * 37 + new Boolean(this.generalized).hashCode();
        result = result * 37 + new Boolean(this.aligned).hashCode();
        result = result * 37 + new Boolean(this.repeated).hashCode();
        return result;
    }

    static LinePlacementImpl cast(LabelPlacement placement) {
        if (placement == null) {
            return null;
        }
        if (placement instanceof LinePlacementImpl) {
            return (LinePlacementImpl)placement;
        }
        if (placement instanceof LinePlacement) {
            LinePlacementImpl copy = new LinePlacementImpl((org.opengis.style.LinePlacement)((LinePlacement)placement));
            return copy;
        }
        return null;
    }

    public void setRepeated(boolean repeated) {
        this.repeated = repeated;
    }

    public void setGeneralized(boolean generalized) {
        this.generalized = generalized;
    }

    public void setAligned(boolean aligned) {
        this.aligned = aligned;
    }

    public void setGap(Expression gap) {
        this.gap = gap;
    }

    public void setInitialGap(Expression initialGap) {
        this.initialGap = initialGap;
    }
}

