/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.collection;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import java.util.ArrayList;
import java.util.Random;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.crs.DefaultEngineeringCRS;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class ListFeatureCollectionTest {
    private static final double TOL = 1.0E-8;
    private static final CoordinateReferenceSystem DEFAULT_CRS = DefaultEngineeringCRS.CARTESIAN_2D;
    private static final ReferencedEnvelope WORLD = new ReferencedEnvelope(-10.0, 10.0, -5.0, 5.0, DEFAULT_CRS);
    private static final SimpleFeatureType TYPE = ListFeatureCollectionTest.createType();
    private static final GeometryFactory geomFactory = new GeometryFactory();
    private static final Random rand = new Random();
    private SimpleFeatureBuilder fb;
    private ArrayList<SimpleFeature> featureList;
    private ListFeatureCollection featureCollection;

    @Before
    public void setup() {
        this.featureList = new ArrayList();
        this.fb = new SimpleFeatureBuilder(TYPE);
    }

    @Test
    public void size() {
        this.createPointFeatures(WORLD, 42);
        Assert.assertEquals((long)42L, (long)this.featureCollection.size());
    }

    @Test
    public void clear() {
        this.createPointFeatures(WORLD, 42);
        this.featureCollection.clear();
        Assert.assertTrue((boolean)this.featureCollection.isEmpty());
    }

    @Test
    public void getBounds() {
        this.createPointFeaturesAtCorners(WORLD);
        ReferencedEnvelope bounds = this.featureCollection.getBounds();
        Assert.assertTrue((boolean)WORLD.boundsEquals2D((Envelope)bounds, 1.0E-8));
        Assert.assertEquals((Object)DEFAULT_CRS, (Object)bounds.getCoordinateReferenceSystem());
    }

    @Test
    public void addFeatureIncrementsSize() {
        this.createPointFeatures(WORLD, 1);
        this.featureCollection.add(this.createPointFeature(WORLD.getMinX(), WORLD.getMinY()));
        Assert.assertEquals((long)2L, (long)this.featureCollection.size());
    }

    @Test
    public void addFeatureExpandsBounds() {
        this.createPointFeaturesAtCorners(WORLD);
        double x = WORLD.getMaxX() + WORLD.getWidth();
        double y = WORLD.getMaxY() + WORLD.getHeight();
        this.featureCollection.add(this.createPointFeature(x, y));
        ReferencedEnvelope bounds = this.featureCollection.getBounds();
        Assert.assertEquals((double)x, (double)bounds.getMaxX(), (double)1.0E-8);
        Assert.assertEquals((double)y, (double)bounds.getMaxY(), (double)1.0E-8);
    }

    @Test
    public void iterator() {
        this.createPointFeaturesAtCorners(WORLD);
        SimpleFeatureIterator iter = this.featureCollection.features();
        Assert.assertNotNull((Object)iter);
        Assert.assertTrue((boolean)iter.hasNext());
        ArrayList<SimpleFeature> copy = new ArrayList<SimpleFeature>(this.featureList);
        while (iter.hasNext()) {
            SimpleFeature f = (SimpleFeature)iter.next();
            Assert.assertTrue((boolean)copy.remove(f));
        }
        Assert.assertTrue((boolean)copy.isEmpty());
    }

    private void createPointFeaturesAtCorners(ReferencedEnvelope env) {
        double[] xy = new double[]{env.getMinX(), env.getMinY(), env.getMinX(), env.getMaxY(), env.getMaxX(), env.getMinY(), env.getMaxX(), env.getMaxY()};
        for (int i = 0; i < xy.length; i += 2) {
            Coordinate c = new Coordinate(xy[i], xy[i + 1]);
            this.fb.add((Object)geomFactory.createPoint(c));
            this.fb.add((Object)i);
            this.featureList.add(this.fb.buildFeature(null));
        }
        this.featureCollection = new ListFeatureCollection(TYPE, this.featureList);
    }

    private void createPointFeatures(ReferencedEnvelope env, int count) {
        for (int i = 0; i < count; ++i) {
            double x = WORLD.getMinX() + rand.nextDouble() * WORLD.getWidth();
            double y = WORLD.getMinY() + rand.nextDouble() * WORLD.getHeight();
            this.featureList.add(this.createPointFeature(x, y));
        }
        this.featureCollection = new ListFeatureCollection(TYPE, this.featureList);
    }

    private SimpleFeature createPointFeature(double x, double y) {
        this.fb.add((Object)geomFactory.createPoint(new Coordinate(x, y)));
        this.fb.add((Object)(this.featureList.size() + 1));
        return this.fb.buildFeature(null);
    }

    private static SimpleFeatureType createType() {
        SimpleFeatureTypeBuilder typeBuilder = new SimpleFeatureTypeBuilder();
        typeBuilder.setName("foo");
        typeBuilder.add("point", Point.class, DEFAULT_CRS);
        typeBuilder.add("id", Integer.class);
        return typeBuilder.buildFeatureType();
    }
}

