/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.collection;

import java.util.Comparator;
import org.geotools.data.DataUtilities;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.store.FeatureCollectionWrapperTestSupport;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.collection.SortedSimpleFeatureCollection;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.sort.SortBy;
import org.opengis.filter.sort.SortOrder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortedFeatureCollectionTest
extends FeatureCollectionWrapperTestSupport {
    FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2(null);

    public void testNaturalSort() throws Exception {
        SortedSimpleFeatureCollection sorted = new SortedSimpleFeatureCollection(this.delegate, new SortBy[]{SortBy.NATURAL_ORDER});
        this.checkSorted(sorted, DataUtilities.sortComparator((SortBy)SortBy.NATURAL_ORDER));
    }

    public void testReverseSort() throws Exception {
        SortedSimpleFeatureCollection sorted = new SortedSimpleFeatureCollection(this.delegate, new SortBy[]{SortBy.REVERSE_ORDER});
        this.checkSorted(sorted, DataUtilities.sortComparator((SortBy)SortBy.REVERSE_ORDER));
    }

    public void testSortAttribute() throws Exception {
        SortBy sort = this.ff.sort("someAtt", SortOrder.ASCENDING);
        SortedSimpleFeatureCollection sorted = new SortedSimpleFeatureCollection(this.delegate, new SortBy[]{sort});
        this.checkSorted(sorted, DataUtilities.sortComparator((SortBy)sort));
    }

    private void checkSorted(SortedSimpleFeatureCollection sorted, Comparator<SimpleFeature> comparator) {
        SimpleFeatureIterator fi = sorted.features();
        SimpleFeature prev = null;
        while (fi.hasNext()) {
            SimpleFeature curr = (SimpleFeature)fi.next();
            if (prev != null) {
                SortedFeatureCollectionTest.assertTrue((String)("Failed on " + prev + " / " + curr), (comparator.compare(prev, curr) <= 0 ? 1 : 0) != 0);
            }
            prev = curr;
        }
        fi.close();
    }
}

