/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.WKTReader;
import java.util.HashMap;
import java.util.LinkedHashSet;
import junit.framework.TestCase;
import org.custommonkey.xmlunit.NamespaceContext;
import org.custommonkey.xmlunit.SimpleNamespaceContext;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.FilterTransformer;
import org.geotools.referencing.CRS;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.Id;
import org.opengis.filter.PropertyIsGreaterThan;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.identity.FeatureId;
import org.opengis.filter.spatial.Overlaps;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.w3c.dom.Document;

public class FilterTransformerTest
extends TestCase {
    FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2(null);
    FilterTransformer transform = new FilterTransformer();

    protected void setUp() throws Exception {
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put("ogc", "http://www.opengis.net/ogc");
        namespaces.put("gml", "http://www.opengis.net/gml");
        namespaces.put("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        XMLUnit.setXpathNamespaceContext((NamespaceContext)new SimpleNamespaceContext(namespaces));
    }

    public void testIdEncode() throws Exception {
        LinkedHashSet<FeatureId> set = new LinkedHashSet<FeatureId>();
        set.add(this.ff.featureId("FID.1"));
        set.add(this.ff.featureId("FID.2"));
        Id filter = this.ff.id(set);
        String output = this.transform.transform((Filter)filter);
        FilterTransformerTest.assertNotNull((String)"got xml", (Object)output);
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><ogc:FeatureId xmlns=\"http://www.opengis.net/ogc\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:gml=\"http://www.opengis.net/gml\" fid=\"FID.1\"/><ogc:FeatureId fid=\"FID.2\"/>";
        FilterTransformerTest.assertEquals((String)"expected id filters", (String)xml, (String)output);
    }

    public void testEncodeLong() throws Exception {
        PropertyIsGreaterThan filter = this.ff.greater((Expression)this.ff.property("MYATT"), (Expression)this.ff.literal(50000000L));
        String output = this.transform.transform((Filter)filter);
        FilterTransformerTest.assertNotNull((String)"got xml", (Object)output);
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><ogc:PropertyIsGreaterThan xmlns=\"http://www.opengis.net/ogc\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:gml=\"http://www.opengis.net/gml\"><ogc:PropertyName>MYATT</ogc:PropertyName><ogc:Literal>50000000</ogc:Literal></ogc:PropertyIsGreaterThan>";
        FilterTransformerTest.assertEquals((String)xml, (String)output);
    }

    public void testEncodeSRSNameLonLat() throws Exception {
        CoordinateReferenceSystem wgs84 = CRS.decode((String)"EPSG:4326", (boolean)true);
        Geometry point = new WKTReader().read("POINT(10 0)");
        point.setUserData((Object)wgs84);
        Overlaps filter = this.ff.overlaps((Expression)this.ff.property("geom"), (Expression)this.ff.literal((Object)point));
        String output = this.transform.transform((Filter)filter);
        Document doc = XMLUnit.buildControlDocument((String)output);
        XMLAssert.assertXpathEvaluatesTo((String)"EPSG:4326", (String)"//gml:Point/@srsName", (Document)doc);
    }

    public void testEncodeSRSNameLatLon() throws Exception {
        CoordinateReferenceSystem wgs84 = CRS.decode((String)"urn:ogc:def:crs:EPSG::4326");
        System.out.println(wgs84);
        Geometry point = new WKTReader().read("POINT(10 0)");
        point.setUserData((Object)wgs84);
        Overlaps filter = this.ff.overlaps((Expression)this.ff.property("geom"), (Expression)this.ff.literal((Object)point));
        String output = this.transform.transform((Filter)filter);
        Document doc = XMLUnit.buildControlDocument((String)output);
        XMLAssert.assertXpathEvaluatesTo((String)"urn:ogc:def:crs:EPSG::4326", (String)"//gml:Point/@srsName", (Document)doc);
    }
}

