/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.visitor;

import junit.framework.TestCase;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.visitor.DuplicatingFilterVisitor;
import org.opengis.filter.And;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.Not;
import org.opengis.filter.PropertyIsGreaterThan;
import org.opengis.filter.PropertyIsLessThan;
import org.opengis.filter.PropertyIsLike;
import org.opengis.filter.expression.Add;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.spatial.BBOX;
import org.xml.sax.helpers.NamespaceSupport;

public class DuplicateFilterVisitorTest
extends TestCase {
    private FilterFactory2 fac;

    public DuplicateFilterVisitorTest(String testName) {
        super(testName);
    }

    protected void setUp() throws Exception {
        this.fac = CommonFactoryFinder.getFilterFactory2((Hints)GeoTools.getDefaultHints());
    }

    public void testLogicFilterDuplication() throws IllegalFilterException {
        PropertyIsGreaterThan greater = this.fac.greater((Expression)this.fac.literal(2), (Expression)this.fac.literal(1));
        PropertyIsLessThan less = this.fac.less((Expression)this.fac.literal(3), (Expression)this.fac.literal(4));
        And and = this.fac.and((Filter)greater, (Filter)less);
        DuplicatingFilterVisitor visitor = new DuplicatingFilterVisitor();
        Filter newFilter = (Filter)and.accept((FilterVisitor)visitor, (Object)this.fac);
        DuplicateFilterVisitorTest.assertNotNull((Object)newFilter);
        DuplicateFilterVisitorTest.assertEquals((Object)and, (Object)newFilter);
    }

    public void testOptimizationExample() {
        Add add = this.fac.add((Expression)this.fac.literal(1), (Expression)this.fac.literal(2));
        class Optimization
        extends DuplicatingFilterVisitor {
            Optimization() {
            }

            public Object visit(Add expression, Object extraData) {
                Expression expr1 = expression.getExpression1();
                Expression expr2 = expression.getExpression2();
                if (expr1 instanceof Literal && expr2 instanceof Literal) {
                    Double number1 = (Double)expr1.evaluate(null, Double.class);
                    Double number2 = (Double)expr2.evaluate(null, Double.class);
                    return this.ff.literal(number1 + number2);
                }
                return super.visit(expression, extraData);
            }
        }
        Expression modified = (Expression)add.accept((ExpressionVisitor)new Optimization(), null);
        DuplicateFilterVisitorTest.assertTrue((boolean)(modified instanceof Literal));
    }

    public void testNotFilter() {
        PropertyIsLike like = this.fac.like((Expression)this.fac.property("stringProperty"), "ab*");
        Not not = this.fac.not((Filter)like);
        DuplicatingFilterVisitor visitor = new DuplicatingFilterVisitor(this.fac);
        Not clone = (Not)not.accept((FilterVisitor)visitor, null);
        DuplicateFilterVisitorTest.assertEquals((Object)not, (Object)clone);
        DuplicateFilterVisitorTest.assertNotSame((Object)not, (Object)clone);
        DuplicateFilterVisitorTest.assertNotSame((Object)like, (Object)clone.getFilter());
    }

    public void testPreservedNamespaceContext() {
        NamespaceSupport nsContext = new NamespaceSupport();
        nsContext.declarePrefix("f", "http://feature.example.org");
        PropertyName geometry = this.fac.property("f:name", nsContext);
        BBOX bbox = this.fac.bbox((Expression)geometry, 0.0, 0.0, 1.0, 1.0, "EPSG:4326");
        DuplicatingFilterVisitor visitor = new DuplicatingFilterVisitor(this.fac);
        BBOX clone = (BBOX)bbox.accept((FilterVisitor)visitor, null);
        DuplicateFilterVisitorTest.assertEquals((Object)bbox, (Object)clone);
        DuplicateFilterVisitorTest.assertNotSame((Object)bbox, (Object)clone);
        DuplicateFilterVisitorTest.assertSame((Object)nsContext, (Object)((PropertyName)clone.getExpression1()).getNamespaceContext());
    }
}

