/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import java.util.LinkedList;
import java.util.Queue;
import org.geotools.util.NullProgressListener;
import org.geotools.util.ProgressListener;
import org.opengis.util.InternationalString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultProgressListener
extends NullProgressListener
implements ProgressListener,
org.opengis.util.ProgressListener {
    private final Queue<Warning> warnings = new LinkedList<Warning>();
    private final Queue<Throwable> exceptionQueue = new LinkedList<Throwable>();
    private boolean completed;
    private float progress;
    private InternationalString task;
    private boolean started;

    public String toString() {
        return "DefaultProgressListener [completed=" + this.completed + ", progress=" + this.progress + ", started=" + this.started + ", task=" + this.task + "]";
    }

    @Override
    public void complete() {
        this.completed = true;
    }

    @Override
    public void dispose() {
        this.exceptionQueue.clear();
        this.warnings.clear();
    }

    @Override
    public void exceptionOccurred(Throwable exception) {
        this.exceptionQueue.add(exception);
    }

    @Override
    public void progress(float percent) {
        this.progress = percent;
    }

    @Override
    public void started() {
        this.started = true;
    }

    @Override
    public void warningOccurred(String source, String margin, String warning) {
        Warning w = new Warning();
        w.setMargin(margin);
        w.setSource(source);
        w.setWarning(warning);
        this.warnings.add(w);
    }

    @Override
    public float getProgress() {
        return this.progress;
    }

    @Override
    public InternationalString getTask() {
        return this.task;
    }

    @Override
    public void setTask(InternationalString task) {
        this.task = task;
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public Queue<Throwable> getExceptions() {
        return new LinkedList<Throwable>(this.exceptionQueue);
    }

    public boolean hasExceptions() {
        return this.exceptionQueue.size() > 0;
    }

    public boolean isStarted() {
        return this.started;
    }

    public Queue<Warning> getWarnings() {
        return new LinkedList<Warning>(this.warnings);
    }

    public static class Warning {
        private String source;
        private String margin;
        private String warning;

        public String toString() {
            return "Warning [margin=" + this.margin + ", source=" + this.source + ", warning=" + this.warning + "]";
        }

        public String getSource() {
            return this.source;
        }

        public void setSource(String source) {
            this.source = source;
        }

        public String getMargin() {
            return this.margin;
        }

        public void setMargin(String margin) {
            this.margin = margin;
        }

        public String getWarning() {
            return this.warning;
        }

        public void setWarning(String warning) {
            this.warning = warning;
        }
    }
}

