/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.jts;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import org.geotools.geometry.jts.Decimator;
import org.geotools.geometry.jts.LiteCoordinateSequenceFactory;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.referencing.operation.MathTransform;

public class DecimatorTest {
    GeometryFactory gf = new GeometryFactory();
    LiteCoordinateSequenceFactory csf = new LiteCoordinateSequenceFactory();

    @Test
    public void testDecimateRing() {
        LinearRing g = this.gf.createLinearRing(this.csf.create(new double[]{0.0, 0.0, 0.0, 10.0, 2.0, 10.0, 2.0, 0.0, 0.0, 0.0}));
        Assert.assertTrue((boolean)g.isValid());
        Decimator d = new Decimator(4.0, 4.0);
        d.decimate((Geometry)g);
        g.geometryChanged();
        Assert.assertTrue((boolean)g.isValid());
        Assert.assertEquals((long)4L, (long)g.getCoordinateSequence().size());
    }

    @Test
    public void testDecimateRingEnvelope() {
        LinearRing g = this.gf.createLinearRing(this.csf.create(new double[]{0.0, 0.0, 0.0, 10.0, 2.0, 10.0, 2.0, 0.0, 0.0, 0.0}));
        Assert.assertTrue((boolean)g.isValid());
        Decimator d = new Decimator(20.0, 20.0);
        d.decimate((Geometry)g);
        g.geometryChanged();
        Assert.assertTrue((boolean)g.isValid());
        Assert.assertEquals((long)4L, (long)g.getCoordinateSequence().size());
    }

    @Test
    public void testNoDecimation() {
        LinearRing g = this.gf.createLinearRing(this.csf.create(new double[]{0.0, 0.0, 0.0, 10.0, 2.0, 10.0, 2.0, 0.0, 0.0, 0.0}));
        LinearRing original = (LinearRing)g.clone();
        Assert.assertTrue((boolean)g.isValid());
        Decimator d = new Decimator(-1.0, -1.0);
        d.decimate((Geometry)g);
        g.geometryChanged();
        Assert.assertTrue((boolean)g.isValid());
        Assert.assertTrue((boolean)original.equals((Geometry)g));
    }

    @Test
    public void testDistance() throws Exception {
        LineString ls = this.gf.createLineString(this.csf.create(new double[]{0.0, 0.0, 1.0, 1.0, 2.0, 2.0, 3.0, 3.0, 4.0, 4.0, 5.0, 5.0}));
        AffineTransform2D identity = new AffineTransform2D(new AffineTransform());
        Decimator d = new Decimator((MathTransform)identity, new Rectangle(0, 0, 5, 5), 0.8);
        d.decimateTransformGeneralize((Geometry)ls.clone(), (MathTransform)identity);
        Assert.assertEquals((long)6L, (long)ls.getNumPoints());
        d = new Decimator((MathTransform)identity, new Rectangle(0, 0, 5, 5), 1.0);
        d.decimateTransformGeneralize((Geometry)ls, (MathTransform)identity);
        Assert.assertEquals((long)4L, (long)ls.getNumPoints());
        d = new Decimator((MathTransform)identity, new Rectangle(0, 0, 5, 5), 6.0);
        d.decimateTransformGeneralize((Geometry)ls, (MathTransform)identity);
        Assert.assertEquals((long)2L, (long)ls.getNumPoints());
    }

    @Test
    public void testDecimate3DPoint() throws Exception {
        Point p = this.gf.createPoint(this.csf.create(new double[]{0.0, 1.0, 2.0}, 3));
        AffineTransform2D identity = new AffineTransform2D(new AffineTransform());
        Decimator d = new Decimator((MathTransform)identity, new Rectangle(0, 0, 5, 5), 0.8);
        d.decimateTransformGeneralize((Geometry)p, (MathTransform)identity);
        Assert.assertEquals((long)1L, (long)p.getNumPoints());
        Assert.assertEquals((long)2L, (long)p.getCoordinateSequence().getDimension());
    }

    @Test
    public void testDecimate3DLine() throws Exception {
        LineString ls = this.gf.createLineString(this.csf.create(new double[]{0.0, 0.0, 1.0, 1.0, 2.0, 1.0, 3.0, 3.0, 4.0, 4.0, 5.0, 5.0}, 3));
        Assert.assertEquals((long)4L, (long)ls.getNumPoints());
        AffineTransform2D identity = new AffineTransform2D(new AffineTransform());
        Decimator d = new Decimator((MathTransform)identity, new Rectangle(0, 0, 5, 5), 0.8);
        d.decimateTransformGeneralize((Geometry)ls, (MathTransform)identity);
        Assert.assertEquals((long)4L, (long)ls.getNumPoints());
        Assert.assertEquals((long)2L, (long)ls.getCoordinateSequence().getDimension());
    }
}

