/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.memory;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import org.geotools.data.AbstractDataStore;
import org.geotools.data.DataSourceException;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Query;
import org.geotools.data.SchemaNotFoundException;
import org.geotools.data.Transaction;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.Feature;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.IllegalAttributeException;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryDataStore
extends AbstractDataStore {
    protected Map<String, Map<String, SimpleFeature>> memory = new LinkedHashMap<String, Map<String, SimpleFeature>>();
    protected Map<String, SimpleFeatureType> schema = new HashMap<String, SimpleFeatureType>();

    public MemoryDataStore() {
        super(true);
    }

    public MemoryDataStore(SimpleFeatureType featureType) {
        HashMap featureMap = new HashMap();
        String typeName = featureType.getTypeName();
        this.schema.put(typeName, featureType);
        this.memory.put(typeName, featureMap);
    }

    public MemoryDataStore(FeatureCollection<SimpleFeatureType, SimpleFeature> collection) {
        this.addFeatures(collection);
    }

    public MemoryDataStore(SimpleFeature[] array) {
        this.addFeatures(array);
    }

    public MemoryDataStore(FeatureReader<SimpleFeatureType, SimpleFeature> reader) throws IOException {
        this.addFeatures(reader);
    }

    public MemoryDataStore(FeatureIterator<SimpleFeature> reader) throws IOException {
        this.addFeatures(reader);
    }

    public void addFeatures(FeatureReader<SimpleFeatureType, SimpleFeature> reader) throws IOException {
        try {
            LinkedHashMap<String, SimpleFeature> featureMap = new LinkedHashMap<String, SimpleFeature>();
            SimpleFeature feature = (SimpleFeature)reader.next();
            if (feature == null) {
                throw new IllegalArgumentException("Provided  FeatureReader<SimpleFeatureType, SimpleFeature> is closed");
            }
            SimpleFeatureType featureType = feature.getFeatureType();
            String typeName = featureType.getTypeName();
            featureMap.put(feature.getID(), feature);
            while (reader.hasNext()) {
                feature = (SimpleFeature)reader.next();
                featureMap.put(feature.getID(), feature);
            }
            this.schema.put(typeName, featureType);
            this.memory.put(typeName, featureMap);
        }
        catch (IllegalAttributeException e) {
            throw new DataSourceException("Problem using reader", (Throwable)e);
        }
        finally {
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFeatures(FeatureIterator<SimpleFeature> reader) throws IOException {
        try {
            LinkedHashMap<String, SimpleFeature> featureMap = new LinkedHashMap<String, SimpleFeature>();
            SimpleFeature feature = (SimpleFeature)reader.next();
            if (feature == null) {
                throw new IllegalArgumentException("Provided  FeatureReader<SimpleFeatureType, SimpleFeature> is closed");
            }
            SimpleFeatureType featureType = feature.getFeatureType();
            String typeName = featureType.getTypeName();
            featureMap.put(feature.getID(), feature);
            while (reader.hasNext()) {
                feature = (SimpleFeature)reader.next();
                featureMap.put(feature.getID(), feature);
            }
            this.schema.put(typeName, featureType);
            this.memory.put(typeName, featureMap);
        }
        finally {
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFeatures(Collection<?> collection) {
        if (collection == null || collection.isEmpty()) {
            throw new IllegalArgumentException("Provided FeatureCollection<SimpleFeatureType, SimpleFeature> is empty");
        }
        Map<String, Map<String, SimpleFeature>> map = this.memory;
        synchronized (map) {
            Iterator<?> i = collection.iterator();
            while (i.hasNext()) {
                this.addFeatureInternal((SimpleFeature)i.next());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFeatures(FeatureCollection<SimpleFeatureType, SimpleFeature> collection) {
        if (collection == null) {
            throw new IllegalArgumentException("Provided FeatureCollection<SimpleFeatureType, SimpleFeature> is empty");
        }
        Map<String, Map<String, SimpleFeature>> map = this.memory;
        synchronized (map) {
            try {
                collection.accepts(new FeatureVisitor(){

                    public void visit(Feature feature) {
                        MemoryDataStore.this.addFeatureInternal((SimpleFeature)feature);
                    }
                }, null);
            }
            catch (IOException ignore) {
                LOGGER.log(Level.FINE, "Unable to add all features", ignore);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFeatures(SimpleFeature[] features) {
        if (features == null || features.length == 0) {
            throw new IllegalArgumentException("Provided features are empty");
        }
        Map<String, Map<String, SimpleFeature>> map = this.memory;
        synchronized (map) {
            for (int i = 0; i < features.length; ++i) {
                this.addFeatureInternal(features[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFeature(SimpleFeature feature) {
        Map<String, Map<String, SimpleFeature>> map = this.memory;
        synchronized (map) {
            this.addFeatureInternal(feature);
        }
    }

    private void addFeatureInternal(SimpleFeature feature) {
        if (feature == null) {
            throw new IllegalArgumentException("Provided Feature is empty");
        }
        SimpleFeatureType featureType = feature.getFeatureType();
        String typeName = featureType.getTypeName();
        if (!this.memory.containsKey(typeName)) {
            try {
                this.createSchema(featureType);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        Map<String, SimpleFeature> featuresMap = this.memory.get(typeName);
        featuresMap.put(feature.getID(), feature);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, SimpleFeature> features(String typeName) throws IOException {
        Map<String, Map<String, SimpleFeature>> map = this.memory;
        synchronized (map) {
            if (this.memory.containsKey(typeName)) {
                return this.memory.get(typeName);
            }
        }
        throw new IOException("Type name " + typeName + " not found");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getTypeNames() {
        Map<String, Map<String, SimpleFeature>> map = this.memory;
        synchronized (map) {
            String[] types = new String[this.schema.size()];
            int index = 0;
            Iterator<String> i = this.schema.keySet().iterator();
            while (i.hasNext()) {
                types[index] = i.next();
                ++index;
            }
            return types;
        }
    }

    @Override
    public SimpleFeatureType getSchema(String typeName) throws IOException {
        Map<String, Map<String, SimpleFeature>> map = this.memory;
        synchronized (map) {
            if (this.schema.containsKey(typeName)) {
                return this.schema.get(typeName);
            }
            throw new SchemaNotFoundException(typeName);
        }
    }

    @Override
    public void createSchema(SimpleFeatureType featureType) throws IOException {
        String typeName = featureType.getTypeName();
        if (this.memory.containsKey(typeName)) {
            throw new IOException(typeName + " already exists");
        }
        LinkedHashMap featuresMap = new LinkedHashMap();
        this.schema.put(typeName, featureType);
        this.memory.put(typeName, featuresMap);
    }

    @Override
    public FeatureReader<SimpleFeatureType, SimpleFeature> getFeatureReader(final String typeName) throws IOException {
        return new FeatureReader<SimpleFeatureType, SimpleFeature>(){
            SimpleFeatureType featureType;
            Iterator<SimpleFeature> iterator;
            {
                this.featureType = MemoryDataStore.this.getSchema(typeName);
                this.iterator = MemoryDataStore.this.features(typeName).values().iterator();
            }

            public SimpleFeatureType getFeatureType() {
                return this.featureType;
            }

            public SimpleFeature next() throws IOException, IllegalAttributeException, NoSuchElementException {
                if (this.iterator == null) {
                    throw new IOException("Feature Reader has been closed");
                }
                try {
                    return SimpleFeatureBuilder.copy(this.iterator.next());
                }
                catch (NoSuchElementException end) {
                    throw new DataSourceException("There are no more Features", (Throwable)end);
                }
            }

            public boolean hasNext() {
                return this.iterator != null && this.iterator.hasNext();
            }

            public void close() {
                if (this.iterator != null) {
                    this.iterator = null;
                }
                if (this.featureType != null) {
                    this.featureType = null;
                }
            }
        };
    }

    @Override
    public FeatureWriter<SimpleFeatureType, SimpleFeature> createFeatureWriter(final String typeName, final Transaction transaction) throws IOException {
        return new FeatureWriter<SimpleFeatureType, SimpleFeature>(){
            SimpleFeatureType featureType;
            Map<String, SimpleFeature> contents;
            Iterator<SimpleFeature> iterator;
            SimpleFeature live;
            SimpleFeature current;
            {
                this.featureType = MemoryDataStore.this.getSchema(typeName);
                this.contents = MemoryDataStore.this.features(typeName);
                this.iterator = this.contents.values().iterator();
                this.live = null;
                this.current = null;
            }

            public SimpleFeatureType getFeatureType() {
                return this.featureType;
            }

            public SimpleFeature next() throws IOException, NoSuchElementException {
                if (this.hasNext()) {
                    this.live = this.iterator.next();
                    try {
                        this.current = SimpleFeatureBuilder.copy(this.live);
                    }
                    catch (IllegalAttributeException e) {
                        throw new DataSourceException("Unable to edit " + this.live.getID() + " of " + typeName);
                    }
                }
                this.live = null;
                try {
                    this.current = SimpleFeatureBuilder.template(this.featureType, null);
                }
                catch (IllegalAttributeException e) {
                    throw new DataSourceException("Unable to add additional Features of " + typeName);
                }
                return this.current;
            }

            public void remove() throws IOException {
                if (this.contents == null) {
                    throw new IOException("FeatureWriter has been closed");
                }
                if (this.current == null) {
                    throw new IOException("No feature available to remove");
                }
                if (this.live != null) {
                    this.iterator.remove();
                    MemoryDataStore.this.listenerManager.fireFeaturesRemoved(typeName, transaction, new ReferencedEnvelope(this.live.getBounds()), true);
                    this.live = null;
                    this.current = null;
                } else {
                    this.current = null;
                }
            }

            public void write() throws IOException {
                if (this.contents == null) {
                    throw new IOException("FeatureWriter has been closed");
                }
                if (this.current == null) {
                    throw new IOException("No feature available to write");
                }
                if (this.live != null) {
                    if (this.live.equals(this.current)) {
                        this.live = null;
                        this.current = null;
                    } else {
                        try {
                            this.live.setAttributes(this.current.getAttributes());
                        }
                        catch (Exception e) {
                            throw new DataSourceException("Unable to accept modifications to " + this.live.getID() + " on " + typeName);
                        }
                        ReferencedEnvelope bounds = new ReferencedEnvelope();
                        bounds.expandToInclude((Envelope)new ReferencedEnvelope(this.live.getBounds()));
                        bounds.expandToInclude((Envelope)new ReferencedEnvelope(this.current.getBounds()));
                        MemoryDataStore.this.listenerManager.fireFeaturesChanged(typeName, transaction, bounds, true);
                        this.live = null;
                        this.current = null;
                    }
                } else {
                    this.contents.put(this.current.getID(), this.current);
                    MemoryDataStore.this.listenerManager.fireFeaturesAdded(typeName, transaction, new ReferencedEnvelope(this.current.getBounds()), true);
                    this.current = null;
                }
            }

            public boolean hasNext() throws IOException {
                if (this.contents == null) {
                    throw new IOException("FeatureWriter has been closed");
                }
                return this.iterator != null && this.iterator.hasNext();
            }

            public void close() {
                if (this.iterator != null) {
                    this.iterator = null;
                }
                if (this.featureType != null) {
                    this.featureType = null;
                }
                this.contents = null;
                this.current = null;
                this.live = null;
            }
        };
    }

    @Override
    protected ReferencedEnvelope getBounds(Query query) throws IOException {
        String typeName = query.getTypeName();
        Map<String, SimpleFeature> contents = this.features(typeName);
        Iterator<SimpleFeature> iterator = contents.values().iterator();
        CoordinateReferenceSystem coordinateSystem = query.getCoordinateSystem();
        ReferencedEnvelope envelope = null;
        Filter filter = query.getFilter();
        int count = 0;
        while (iterator.hasNext() && count < query.getMaxFeatures()) {
            ++count;
            SimpleFeature feature = iterator.next();
            if (!filter.evaluate((Object)feature)) continue;
            ++count;
            Envelope env = ((Geometry)feature.getDefaultGeometry()).getEnvelopeInternal();
            if (null == envelope) {
                envelope = new ReferencedEnvelope(coordinateSystem);
            }
            envelope.expandToInclude(env);
        }
        return envelope;
    }

    @Override
    protected int getCount(Query query) throws IOException {
        String typeName = query.getTypeName();
        Map<String, SimpleFeature> contents = this.features(typeName);
        Iterator<SimpleFeature> iterator = contents.values().iterator();
        int count = 0;
        Filter filter = query.getFilter();
        while (iterator.hasNext() && count < query.getMaxFeatures()) {
            if (!filter.evaluate((Object)iterator.next())) continue;
            ++count;
        }
        return count;
    }
}

