/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import org.geotools.factory.CommonFactoryFinder;
import org.geotools.styling.ContrastEnhancement;
import org.geotools.styling.ContrastEnhancementImpl;
import org.geotools.styling.SelectedChannelType;
import org.geotools.styling.StyleVisitor;
import org.geotools.util.Utilities;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;

public class SelectedChannelTypeImpl
implements SelectedChannelType {
    private FilterFactory filterFactory;
    private ContrastEnhancement contrastEnhancement;
    private String name = "channel";

    public SelectedChannelTypeImpl() {
        this(CommonFactoryFinder.getFilterFactory(null));
    }

    public SelectedChannelTypeImpl(FilterFactory factory) {
        this.filterFactory = factory;
        this.contrastEnhancement = this.contrastEnhancement((Expression)this.filterFactory.literal(1.0));
    }

    public SelectedChannelTypeImpl(FilterFactory factory, ContrastEnhancement contrast) {
        this.filterFactory = factory;
        this.contrastEnhancement = contrast;
    }

    public SelectedChannelTypeImpl(org.opengis.style.SelectedChannelType gray) {
        this.filterFactory = CommonFactoryFinder.getFilterFactory2(null);
        this.name = gray.getChannelName();
        this.contrastEnhancement = new ContrastEnhancementImpl(gray.getContrastEnhancement());
    }

    public String getChannelName() {
        return this.name;
    }

    public ContrastEnhancement getContrastEnhancement() {
        return this.contrastEnhancement;
    }

    public void setChannelName(String name) {
        this.name = name;
    }

    public void setContrastEnhancement(org.opengis.style.ContrastEnhancement enhancement) {
        this.contrastEnhancement = ContrastEnhancementImpl.cast(enhancement);
    }

    public void setContrastEnhancement(Expression gammaValue) {
        this.contrastEnhancement.setGammaValue(gammaValue);
    }

    protected ContrastEnhancement contrastEnhancement(Expression expr) {
        ContrastEnhancementImpl enhancement = new ContrastEnhancementImpl();
        enhancement.setGammaValue((Expression)this.filterFactory.literal(1.0));
        return enhancement;
    }

    public Object accept(org.opengis.style.StyleVisitor visitor, Object data) {
        return visitor.visit((org.opengis.style.SelectedChannelType)this, data);
    }

    public void accept(StyleVisitor visitor) {
        visitor.visit((SelectedChannelType)this);
    }

    public int hashCode() {
        int PRIME = 1000003;
        int result = 0;
        if (this.name != null) {
            result = 1000003 * result + this.name.hashCode();
        }
        if (this.contrastEnhancement != null) {
            result = 1000003 * result + this.contrastEnhancement.hashCode();
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SelectedChannelTypeImpl) {
            SelectedChannelTypeImpl other = (SelectedChannelTypeImpl)obj;
            return Utilities.equals((Object)this.name, (Object)other.name) && Utilities.equals((Object)this.contrastEnhancement, (Object)other.contrastEnhancement);
        }
        return false;
    }
}

