/*
 *    GeoTools - The Open Source Java GIS Toolkit
 *    http://geotools.org
 *
 *    (C) 2008, Open Source Geospatial Foundation (OSGeo)
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation;
 *    version 2.1 of the License.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 */
package org.geotools.console;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;


/**
 * A command-line option.
 *
 * @since 2.5
 * @source $URL: http://svn.osgeo.org/geotools/tags/2.6.4/modules/library/metadata/src/main/java/org/geotools/console/Option.java $
 * @version $Id: Option.java 30640 2008-06-12 17:34:32Z acuster $
 * @author Martin Desruisseaux
 */
@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.FIELD)
public @interface Option {
    /**
     * The argument name. The default is the same name than the field.
     *
     * @return The argument name, or {@code ""} for the default.
     */
    String name() default "";

    /**
     * {@code true} if this option is mandatory. Options are optional by default.
     *
     * @return Whatever this option is mandatory or optional.
     */
    boolean mandatory() default false;

    /**
     * A description of this option to be printed when the {@code --help} option is provided.
     *
     * @return The description, or {@code ""} for none.
     */
    String description() default "";
}
