/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.math;

import org.geotools.resources.Java6;
import org.geotools.resources.XArray;

public final class XMath {
    private static final double[] POW10 = new double[]{1.0, 10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0, 1.0E7, 1.0E8, 1.0E9, 1.0E10, 1.0E11, 1.0E12, 1.0E13, 1.0E14, 1.0E15, 1.0E16, 1.0E17, 1.0E18, 1.0E19, 1.0E20, 1.0E21, 1.0E22};
    private static short[] primes = new short[]{2, 3};
    private static final int MAX_PRIMES_LENGTH = 6542;

    private XMath() {
    }

    public static double pow10(double x) {
        int ix = (int)x;
        if ((double)ix == x) {
            return XMath.pow10(ix);
        }
        return Math.pow(10.0, x);
    }

    public static strictfp double pow10(int x) {
        int nx;
        if (x >= 0) {
            if (x < POW10.length) {
                return POW10[x];
            }
        } else if (x != Integer.MIN_VALUE && (nx = -x) < POW10.length) {
            return 1.0 / POW10[nx];
        }
        try {
            return Double.parseDouble("1E" + x);
        }
        catch (NumberFormatException exception) {
            return StrictMath.pow(10.0, x);
        }
    }

    public static int sgn(double x) {
        if (x > 0.0) {
            return 1;
        }
        if (x < 0.0) {
            return -1;
        }
        return 0;
    }

    public static int sgn(float x) {
        if (x > 0.0f) {
            return 1;
        }
        if (x < 0.0f) {
            return -1;
        }
        return 0;
    }

    public static int sgn(long x) {
        if (x > 0L) {
            return 1;
        }
        if (x < 0L) {
            return -1;
        }
        return 0;
    }

    public static int sgn(int x) {
        if (x > 0) {
            return 1;
        }
        if (x < 0) {
            return -1;
        }
        return 0;
    }

    public static short sgn(short x) {
        if (x > 0) {
            return 1;
        }
        if (x < 0) {
            return -1;
        }
        return 0;
    }

    public static byte sgn(byte x) {
        if (x > 0) {
            return 1;
        }
        if (x < 0) {
            return -1;
        }
        return 0;
    }

    public static double roundIfAlmostInteger(double value, int maxULP) {
        double target = Math.rint(value);
        if (value != target) {
            boolean pos = value < target;
            double candidate = value;
            while (--maxULP >= 0) {
                double d = candidate = pos ? org.geotools.resources.XMath.next(candidate) : org.geotools.resources.XMath.previous(candidate);
                if (candidate != target) continue;
                return target;
            }
        }
        return value;
    }

    public static double trimDecimalFractionDigits(double value, int maxULP, int n) {
        double lower = value;
        double upper = value;
        n = XMath.countDecimalFractionDigits(value) - n;
        if (n > 0) {
            int i = 0;
            while (i < maxULP) {
                if (XMath.countDecimalFractionDigits(lower = org.geotools.resources.XMath.previous(lower)) <= n) {
                    return lower;
                }
                if (XMath.countDecimalFractionDigits(upper = org.geotools.resources.XMath.next(upper)) <= n) {
                    return upper;
                }
                ++i;
            }
        }
        return value;
    }

    public static int countDecimalFractionDigits(double value) {
        int power;
        int upper;
        String asText = Double.toString(value);
        int exp = asText.indexOf(69);
        if (exp >= 0) {
            upper = exp;
            power = Integer.parseInt(asText.substring(exp + 1));
        } else {
            upper = asText.length();
            power = 0;
        }
        while (asText.charAt(--upper) == '0') {
        }
        return Math.max(upper - asText.indexOf(46) - power, 0);
    }

    public static float toNaN(int index) throws IndexOutOfBoundsException {
        if ((index += 0x200000) >= 0 && index <= 0x3FFFFF) {
            float value = Float.intBitsToFloat(2143289344 + index);
            assert (Float.isNaN(value)) : value;
            return value;
        }
        throw new IndexOutOfBoundsException(Integer.toHexString(index));
    }

    public static synchronized int primeNumber(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= 6542) {
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }
        short[] primes = XMath.primes;
        if (index >= primes.length) {
            int i = primes.length;
            int n = primes[i - 1] & 0xFFFF;
            primes = XArray.resize(primes, Math.min((index | 0xF) + 1, 6542));
            block0: while (true) {
                n += 2;
                int j = 1;
                while (j < i) {
                    if (n % (primes[j] & 0xFFFF) == 0) continue block0;
                    ++j;
                }
                assert (n < 65535) : i;
                primes[i] = (short)n;
                if (++i >= primes.length) break;
            }
            XMath.primes = primes;
        }
        return primes[index] & 0xFFFF;
    }

    public static int[] divisors(int number) {
        int d2;
        int d1;
        int p;
        if (number == 0) {
            return new int[0];
        }
        number = Math.abs(number);
        int[] divisors = new int[16];
        divisors[0] = 1;
        int count = 1;
        int sqrt = (int)(Math.sqrt(number) + 1.0E-6);
        int i = 0;
        while ((p = XMath.primeNumber(i)) <= sqrt) {
            if (number % p == 0) {
                if (count == divisors.length) {
                    divisors = XArray.resize(divisors, count * 2);
                }
                divisors[count++] = p;
            }
            ++i;
        }
        int source = count;
        if (count * 2 > divisors.length) {
            divisors = XArray.resize(divisors, count * 2);
        }
        if ((d1 = divisors[--source]) != (d2 = number / d1)) {
            divisors[count++] = d2;
        }
        while (--source >= 0) {
            divisors[count++] = number / divisors[source];
        }
        int i2 = 1;
        while (i2 < count) {
            d1 = divisors[i2];
            int j = i2;
            while (j < count) {
                int p2;
                d2 = d1 * divisors[j];
                if (number % d2 == 0 && (p2 = Java6.binarySearch(divisors, j, count, d2)) < 0) {
                    p2 ^= 0xFFFFFFFF;
                    if (count == divisors.length) {
                        divisors = XArray.resize(divisors, count * 2);
                    }
                    System.arraycopy(divisors, p2, divisors, p2 + 1, count - p2);
                    divisors[p2] = d2;
                    ++count;
                }
                ++j;
            }
            ++i2;
        }
        divisors = XArray.resize(divisors, count);
        assert (XArray.isStrictlySorted(divisors));
        return divisors;
    }
}

