/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.metadata.iso.quality;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.measure.unit.Unit;
import org.geotools.metadata.iso.quality.ResultImpl;
import org.opengis.metadata.quality.QuantitativeResult;
import org.opengis.metadata.quality.Result;
import org.opengis.util.InternationalString;
import org.opengis.util.MemberName;
import org.opengis.util.Record;
import org.opengis.util.RecordType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuantitativeResultImpl
extends ResultImpl
implements QuantitativeResult {
    private static final long serialVersionUID = 1230713599561236060L;
    private List<Record> values;
    private RecordType valueType;
    private Unit valueUnit;
    private InternationalString errorStatistic;

    public QuantitativeResultImpl() {
    }

    public QuantitativeResultImpl(QuantitativeResult source) {
        super((Result)source);
    }

    public QuantitativeResultImpl(double[] values) {
        this.setValues(values);
    }

    public synchronized List<Record> getValues() {
        this.values = this.nonNullList(this.values, Record.class);
        return this.values;
    }

    public synchronized void setValues(List<Record> newValues) {
        this.values = this.copyList(newValues, this.values, Record.class);
    }

    public synchronized void setValues(double[] newValues) {
        List<Record> records;
        if (newValues == null) {
            records = null;
        } else {
            Record[] data = new Record[newValues.length];
            int i = 0;
            while (i < newValues.length) {
                data[i] = new SimpleRecord(newValues[i]);
                ++i;
            }
            records = Arrays.asList(data);
        }
        this.setValues(records);
    }

    public RecordType getValueType() {
        return this.valueType;
    }

    public synchronized void setValueType(RecordType newValue) {
        this.checkWritePermission();
        this.valueType = newValue;
    }

    public Unit getValueUnit() {
        return this.valueUnit;
    }

    public synchronized void setValueUnit(Unit newValue) {
        this.checkWritePermission();
        this.valueUnit = newValue;
    }

    public InternationalString getErrorStatistic() {
        return this.errorStatistic;
    }

    public synchronized void setErrorStatistic(InternationalString newValue) {
        this.checkWritePermission();
        this.errorStatistic = newValue;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SimpleRecord
    implements Record,
    Serializable {
        private final Map<MemberName, Object> map;

        public SimpleRecord(double value) {
            this.map = Collections.singletonMap(null, value);
        }

        public RecordType getRecordType() {
            throw new UnsupportedOperationException();
        }

        public Map<MemberName, Object> getAttributes() {
            return this.map;
        }

        public Object locate(MemberName name) {
            throw new UnsupportedOperationException();
        }

        public void set(MemberName name, Object value) {
            throw new UnsupportedOperationException();
        }

        public boolean equals(Object other) {
            if (other instanceof SimpleRecord) {
                return this.map.equals(((SimpleRecord)other).map);
            }
            return false;
        }

        public int hashCode() {
            return this.map.hashCode();
        }
    }
}

