/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import java.util.Set;
import org.geotools.factory.FactoryRegistryException;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.util.DefaultObjectCache;
import org.geotools.util.FixedSizeObjectCache;
import org.geotools.util.NameFactory;
import org.geotools.util.NullObjectCache;
import org.geotools.util.ObjectCache;
import org.geotools.util.SoftObjectCache;
import org.geotools.util.Utilities;
import org.geotools.util.WeakObjectCache;
import org.opengis.metadata.citation.Citation;
import org.opengis.util.GenericName;

public final class ObjectCaches {
    private ObjectCaches() {
    }

    public static ObjectCache chain(final ObjectCache level1, final ObjectCache level2) {
        if (level1 == level2) {
            return level1;
        }
        if (level1 == null) {
            return level2;
        }
        if (level2 == null) {
            return level1;
        }
        return new ObjectCache(){

            @Override
            public void clear() {
                level1.clear();
            }

            @Override
            public Object get(Object key) {
                Object check;
                Object value = level1.get(key);
                if (value == null && (check = level2.get(key)) != null) {
                    try {
                        level1.writeLock(key);
                        value = level1.peek(key);
                        if (value == null) {
                            level1.put(key, check);
                            value = check;
                        }
                    }
                    finally {
                        level1.writeUnLock(key);
                    }
                }
                return value;
            }

            @Override
            public Object peek(Object key) {
                return level1.peek(key);
            }

            @Override
            public void put(Object key, Object object) {
                level1.put(key, object);
            }

            @Override
            public void writeLock(Object key) {
                level1.writeLock(key);
            }

            @Override
            public void writeUnLock(Object key) {
                level1.writeLock(key);
            }

            @Override
            public Set<Object> getKeys() {
                return level1.getKeys();
            }

            @Override
            public void remove(Object key) {
                level1.remove(key);
            }
        };
    }

    public static ObjectCache create(Hints hints) throws FactoryRegistryException {
        if (hints == null) {
            hints = GeoTools.getDefaultHints();
        }
        String policy = (String)hints.get(Hints.CACHE_POLICY);
        int limit = Hints.CACHE_LIMIT.toValue(hints);
        return ObjectCaches.create(policy, limit);
    }

    public static ObjectCache create(String policy, int size) {
        if ("weak".equalsIgnoreCase(policy)) {
            return new WeakObjectCache(0);
        }
        if ("all".equalsIgnoreCase(policy)) {
            return new DefaultObjectCache(size);
        }
        if ("none".equalsIgnoreCase(policy)) {
            return NullObjectCache.INSTANCE;
        }
        if ("fixed".equalsIgnoreCase(policy)) {
            return new FixedSizeObjectCache(size);
        }
        if ("soft".equals(policy)) {
            return new SoftObjectCache(size);
        }
        return new DefaultObjectCache(size);
    }

    public static String toKey(Citation citation, String code) {
        GenericName name = NameFactory.create(code = code.trim());
        GenericName scope = name.scope().name();
        if (scope == null) {
            return code;
        }
        if (citation != null && Citations.identifierMatches(citation, scope.toString())) {
            return name.tip().toString().trim();
        }
        return code;
    }

    public static Object toKey(Citation citation, String code1, String code2) {
        String key1 = ObjectCaches.toKey(citation, code1);
        String key2 = ObjectCaches.toKey(citation, code2);
        return new Pair(key1, key2);
    }

    private static final class Pair {
        private final String source;
        private final String target;

        public Pair(String source, String target) {
            this.source = source;
            this.target = target;
        }

        public int hashCode() {
            int code = 0;
            if (this.source != null) {
                code = this.source.hashCode();
            }
            if (this.target != null) {
                code += this.target.hashCode() * 37;
            }
            return code;
        }

        public boolean equals(Object other) {
            if (other instanceof Pair) {
                Pair that = (Pair)other;
                return Utilities.equals(this.source, that.source) && Utilities.equals(this.target, that.target);
            }
            return false;
        }

        public String toString() {
            return String.valueOf(this.source) + " \u21e8 " + this.target;
        }
    }
}

