/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.geotools.util.Utilities;
import org.geotools.util.WeakCollectionCleaner;
import org.geotools.util.logging.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeakValueHashMap<K, V>
extends AbstractMap<K, V> {
    private static final int MIN_CAPACITY = 7;
    private static final float LOAD_FACTOR = 0.75f;
    private Entry[] table;
    private int count;
    private int threshold;
    private long lastRehashTime;
    private static final long HOLD_TIME = 20000L;

    public WeakValueHashMap() {
        this(7);
    }

    public WeakValueHashMap(int initialSize) {
        this.newEntryTable(initialSize);
        this.threshold = Math.round((float)this.table.length * 0.75f);
        this.lastRehashTime = System.currentTimeMillis();
    }

    private void newEntryTable(int size) {
        this.table = (Entry[])Array.newInstance(Entry.class, size);
    }

    public WeakValueHashMap(Map<K, V> map) {
        this(Math.round((float)map.size() / 0.75f) + 1);
        this.putAll(map);
    }

    private synchronized void removeEntry(Entry toRemove) {
        assert (this.valid()) : this.count;
        int i = toRemove.index;
        if (i < this.table.length) {
            Entry prev = null;
            Entry e = this.table[i];
            while (e != null) {
                if (e == toRemove) {
                    if (prev != null) {
                        prev.next = e.next;
                    } else {
                        this.table[i] = e.next;
                    }
                    --this.count;
                    assert (this.valid());
                    if (this.count <= this.threshold / 4) {
                        this.rehash(false);
                    }
                    return;
                }
                prev = e;
                e = e.next;
            }
        }
        assert (this.valid());
    }

    private void rehash(boolean augmentation) {
        Level level;
        assert (Thread.holdsLock(this));
        assert (this.valid());
        long currentTime = System.currentTimeMillis();
        int capacity = Math.max(Math.round((float)this.count / 0.375f), this.count + 7);
        if (augmentation ? capacity <= this.table.length : capacity >= this.table.length || currentTime - this.lastRehashTime < 20000L) {
            return;
        }
        this.lastRehashTime = currentTime;
        Entry[] oldTable = this.table;
        this.newEntryTable(capacity);
        this.threshold = Math.round((float)capacity * 0.75f);
        int i = 0;
        while (i < oldTable.length) {
            Entry old = oldTable[i];
            while (old != null) {
                Entry e = old;
                old = old.next;
                Object key = e.key;
                if (key != null) {
                    int index;
                    e.index = index = (key.hashCode() & Integer.MAX_VALUE) % this.table.length;
                    e.next = this.table[index];
                    this.table[index] = e;
                    continue;
                }
                --this.count;
            }
            ++i;
        }
        Logger logger = Logging.getLogger("org.geotools.util");
        if (logger.isLoggable(level = Level.FINEST)) {
            LogRecord record = new LogRecord(level, "Rehash from " + oldTable.length + " to " + this.table.length);
            record.setSourceMethodName(augmentation ? "unique" : "remove");
            record.setSourceClassName(WeakValueHashMap.class.getName());
            record.setLoggerName(logger.getName());
            logger.log(record);
        }
        assert (this.valid());
    }

    private boolean valid() {
        int n = 0;
        int i = 0;
        while (i < this.table.length) {
            Entry e = this.table[i];
            while (e != null) {
                ++n;
                e = e.next;
            }
            ++i;
        }
        if (n != this.count) {
            this.count = n;
            return false;
        }
        return true;
    }

    @Override
    public synchronized int size() {
        assert (this.valid());
        return this.count;
    }

    @Override
    public synchronized boolean containsValue(Object value) {
        return super.containsValue(value);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    public synchronized V get(Object key) {
        assert (WeakCollectionCleaner.DEFAULT.isAlive());
        assert (this.valid()) : this.count;
        int index = (key.hashCode() & Integer.MAX_VALUE) % this.table.length;
        Entry e = this.table[index];
        while (e != null) {
            if (key.equals(e.key)) {
                return (V)e.get();
            }
            e = e.next;
        }
        return null;
    }

    private synchronized V intern(K key, V value) {
        assert (WeakCollectionCleaner.DEFAULT.isAlive());
        assert (this.valid()) : this.count;
        V oldValue = null;
        int hash = key.hashCode() & Integer.MAX_VALUE;
        int index = hash % this.table.length;
        Entry e = this.table[index];
        while (e != null) {
            if (key.equals(e.key)) {
                oldValue = (V)e.get();
                e.clear();
            }
            e = e.next;
        }
        if (value != null) {
            if (this.count >= this.threshold) {
                this.rehash(true);
                index = hash % this.table.length;
            }
            this.table[index] = new Entry(key, value, this.table[index], index);
            ++this.count;
        }
        assert (this.valid());
        return oldValue;
    }

    @Override
    public V put(K key, V value) {
        if (value == null) {
            throw new NullPointerException("Null value not allowed");
        }
        return this.intern(key, value);
    }

    @Override
    public V remove(Object key) {
        return this.intern(key, null);
    }

    @Override
    public synchronized void clear() {
        Arrays.fill(this.table, null);
        this.count = 0;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        throw new UnsupportedOperationException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class Entry
    extends WeakReference<V>
    implements Map.Entry<K, V> {
        K key;
        Entry next;
        int index;

        Entry(K key, V value, Entry next, int index) {
            super(value, WeakCollectionCleaner.DEFAULT.referenceQueue);
            this.key = key;
            this.next = next;
            this.index = index;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.get();
        }

        @Override
        public V setValue(V value) {
            if (value != null) {
                throw new UnsupportedOperationException();
            }
            Object old = this.get();
            this.clear();
            return old;
        }

        @Override
        public void clear() {
            super.clear();
            WeakValueHashMap.this.removeEntry(this);
            this.key = null;
        }

        @Override
        public boolean equals(Object other) {
            if (other instanceof Map.Entry) {
                Map.Entry that = (Map.Entry)other;
                return Utilities.equals(this.getKey(), that.getKey()) && Utilities.equals(this.getValue(), that.getValue());
            }
            return false;
        }

        @Override
        public int hashCode() {
            Object val = this.get();
            return (this.key == null ? 0 : this.key.hashCode()) ^ (val == null ? 0 : val.hashCode());
        }
    }
}

