/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.metadata.iso.citation;

import java.net.URI;
import java.net.URISyntaxException;
import org.geotools.metadata.iso.MetadataEntity;
import org.opengis.metadata.citation.OnLineFunction;
import org.opengis.metadata.citation.OnLineResource;
import org.opengis.util.InternationalString;

public class OnLineResourceImpl
extends MetadataEntity
implements OnLineResource {
    private static final long serialVersionUID = 5412370008274334799L;
    public static final OnLineResource OGC;
    public static final OnLineResource OPEN_GIS;
    public static final OnLineResource EPSG;
    public static final OnLineResource GEOTIFF;
    public static final OnLineResource ESRI;
    public static final OnLineResource ORACLE;
    public static final OnLineResource POSTGIS;
    public static final OnLineResource SUN_MICROSYSTEMS;
    public static final OnLineResource GEOTOOLS;
    public static final OnLineResource WMS;
    private String applicationProfile;
    private InternationalString description;
    private OnLineFunction function;
    private URI linkage;
    private String name;

    public OnLineResourceImpl() {
    }

    public OnLineResourceImpl(OnLineResource source) {
        super(source);
    }

    private OnLineResourceImpl(String linkage) {
        try {
            this.setLinkage(new URI(linkage));
        }
        catch (URISyntaxException exception) {
            throw new IllegalArgumentException(exception);
        }
        this.setFunction(OnLineFunction.INFORMATION);
    }

    public OnLineResourceImpl(URI linkage) {
        this.setLinkage(linkage);
    }

    public String getApplicationProfile() {
        return this.applicationProfile;
    }

    public synchronized void setApplicationProfile(String newValue) {
        this.checkWritePermission();
        this.applicationProfile = newValue;
    }

    public String getName() {
        return this.name;
    }

    public synchronized void setName(String newValue) {
        this.checkWritePermission();
        this.name = newValue;
    }

    public InternationalString getDescription() {
        return this.description;
    }

    public synchronized void setDescription(InternationalString newValue) {
        this.checkWritePermission();
        this.description = newValue;
    }

    public OnLineFunction getFunction() {
        return this.function;
    }

    public synchronized void setFunction(OnLineFunction newValue) {
        this.checkWritePermission();
        this.function = newValue;
    }

    public URI getLinkage() {
        return this.linkage;
    }

    public synchronized void setLinkage(URI newValue) {
        this.checkWritePermission();
        this.linkage = newValue;
    }

    public String getProtocol() {
        URI linkage = this.linkage;
        return linkage != null ? linkage.getScheme() : null;
    }

    static {
        OnLineResourceImpl r = new OnLineResourceImpl("http://www.opengeospatial.org/");
        OGC = r;
        r.freeze();
        r = new OnLineResourceImpl("http://www.opengis.org");
        OPEN_GIS = r;
        r.freeze();
        r = new OnLineResourceImpl("http://www.epsg.org");
        EPSG = r;
        r.freeze();
        r = new OnLineResourceImpl("http://www.remotesensing.org/geotiff");
        GEOTIFF = r;
        r.freeze();
        r = new OnLineResourceImpl("http://www.esri.com");
        ESRI = r;
        r.freeze();
        r = new OnLineResourceImpl("http://www.oracle.com");
        ORACLE = r;
        r.freeze();
        r = new OnLineResourceImpl("http://postgis.refractions.net");
        POSTGIS = r;
        r.freeze();
        r = new OnLineResourceImpl("http://java.sun.com");
        SUN_MICROSYSTEMS = r;
        r.freeze();
        r = new OnLineResourceImpl("http://www.geotools.org");
        GEOTOOLS = r;
        r.freeze();
        r = new OnLineResourceImpl("http://portal.opengis.org/files/?artifact_id=5316");
        WMS = r;
        r.setFunction(OnLineFunction.DOWNLOAD);
        r.freeze();
    }
}

