/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.mysql;

import com.mysql.jdbc.jdbc2.optional.MysqlConnectionPoolDataSource;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import javax.sql.ConnectionPoolDataSource;
import org.geotools.data.jdbc.ConnectionPool;
import org.geotools.data.jdbc.ConnectionPoolManager;
import org.geotools.util.logging.Logging;

public class MySQLConnectionFactory {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.data.mysql");
    private static final String DRIVER_CLASS = "com.mysql.jdbc.Driver";
    private static final String MYSQL_URL_PREFIX = "jdbc:mysql://";
    private static Map _dataSources = new HashMap();
    private String _dbURL;
    private String _username = "";
    private String _password = "";

    public MySQLConnectionFactory(String url) {
        this._dbURL = url;
    }

    public MySQLConnectionFactory(String host, int port, String instance) {
        this(MYSQL_URL_PREFIX + host + ":" + String.valueOf(port) + "/" + instance);
    }

    public MySQLConnectionFactory(String host, String instance) {
        this(host, 3306, instance);
    }

    public ConnectionPool getConnectionPool(String username, String password) throws SQLException {
        this.setLogin(username, password);
        return this.getConnectionPool();
    }

    public Connection getConnection(String user, String password) throws SQLException {
        Properties props = new Properties();
        props.put("user", user);
        props.put("password", password);
        return this.getConnection(props);
    }

    public Connection getConnection(Properties props) throws SQLException {
        Connection dbConnection = null;
        try {
            Class.forName(DRIVER_CLASS);
            LOGGER.finest("getting connection at " + this._dbURL + "with props: " + props);
            dbConnection = DriverManager.getConnection(this._dbURL, props);
        }
        catch (ClassNotFoundException cnfe) {
            throw new SQLException("Postgis driver was not found.");
        }
        return dbConnection;
    }

    public ConnectionPool getConnectionPool() throws SQLException {
        String poolKey = String.valueOf(this._dbURL) + this._username + this._password;
        MysqlConnectionPoolDataSource poolDataSource = (MysqlConnectionPoolDataSource)_dataSources.get(poolKey);
        if (poolDataSource == null) {
            poolDataSource = new MysqlConnectionPoolDataSource();
            poolDataSource.setURL(this._dbURL);
            poolDataSource.setUser(this._username);
            poolDataSource.setPassword(this._password);
            _dataSources.put(poolKey, poolDataSource);
        }
        ConnectionPoolManager manager = ConnectionPoolManager.getInstance();
        ConnectionPool connectionPool = manager.getConnectionPool((ConnectionPoolDataSource)poolDataSource);
        return connectionPool;
    }

    public void setLogin(String username, String password) {
        this._username = username;
        this._password = password;
    }

    public void free(ConnectionPool connectionPool) {
        if (!connectionPool.isClosed()) {
            connectionPool.close();
        }
        ConnectionPoolManager.getInstance().free(connectionPool);
    }
}

