/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.mysql;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.io.WKTWriter;
import java.io.IOException;
import org.geotools.data.FeatureReader;
import org.geotools.data.jdbc.JDBCTextFeatureWriter;
import org.geotools.data.jdbc.QueryData;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MySQLFeatureWriter
extends JDBCTextFeatureWriter {
    private static WKTWriter geometryWriter = new WKTWriter();

    public MySQLFeatureWriter(FeatureReader<SimpleFeatureType, SimpleFeature> fReader, QueryData queryData) throws IOException {
        super(fReader, queryData);
    }

    protected String getGeometryInsertText(Geometry geom, int srid) {
        if (geom == null) {
            return "NULL";
        }
        String geoText = geometryWriter.write(geom);
        String sql = null;
        sql = GeometryCollection.class.isAssignableFrom(geom.getClass()) ? (MultiPoint.class.isAssignableFrom(geom.getClass()) ? "MultiPointFromText" : (MultiLineString.class.isAssignableFrom(geom.getClass()) ? "MultiLineStringFromText" : (MultiPolygon.class.isAssignableFrom(geom.getClass()) ? "MultiPolygonFromText" : "GeometryCollectionFromText"))) : (Point.class.isAssignableFrom(geom.getClass()) ? "PointFromText" : (LineString.class.isAssignableFrom(geom.getClass()) ? "LineStringFromText" : (Polygon.class.isAssignableFrom(geom.getClass()) ? "PolygonFromText" : "GeometryFromText")));
        sql = String.valueOf(sql) + "('" + geoText + "', " + srid + ")";
        return sql;
    }
}

