/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.mysql;

import org.geotools.data.jdbc.FilterToSQL;
import org.geotools.data.jdbc.GeoAPISQLBuilder;
import org.geotools.data.jdbc.fidmapper.FIDMapper;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;

public class MySQLSQLBuilder
extends GeoAPISQLBuilder {
    private boolean wkbEnabled;

    public MySQLSQLBuilder(FilterToSQL encoder) {
        super(encoder, null, null);
    }

    public MySQLSQLBuilder(FilterToSQL encoder, SimpleFeatureType ft) {
        super(encoder, ft, null);
    }

    public void sqlColumns(StringBuffer sql, FIDMapper mapper, AttributeDescriptor[] attributes) {
        int i = 0;
        while (i < mapper.getColumnCount()) {
            sql.append(mapper.getColumnName(i));
            if (attributes.length > 0 || i < mapper.getColumnCount() - 1) {
                sql.append(", ");
            }
            ++i;
        }
        i = 0;
        while (i < attributes.length) {
            String colName = attributes[i].getLocalName();
            if (attributes[i] instanceof GeometryDescriptor) {
                if (this.wkbEnabled) {
                    sql.append("AsBinary(");
                } else {
                    sql.append("AsText(");
                }
                sql.append(String.valueOf(attributes[i].getLocalName()) + ") AS " + attributes[i].getLocalName());
            } else {
                sql.append(colName);
            }
            if (i < attributes.length - 1) {
                sql.append(", ");
            }
            ++i;
        }
    }

    public boolean isWKBEnabled() {
        return this.wkbEnabled;
    }

    public void setWKBEnabled(boolean enabled) {
        this.wkbEnabled = enabled;
    }
}

