/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.mysql;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.geotools.data.DataSourceException;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Transaction;
import org.geotools.data.jdbc.JDBCDataStore;
import org.geotools.data.jdbc.JDBCDataStoreConfig;
import org.geotools.data.jdbc.JDBCFeatureWriter;
import org.geotools.data.jdbc.JDBCUtils;
import org.geotools.data.jdbc.QueryData;
import org.geotools.data.jdbc.SQLBuilder;
import org.geotools.data.jdbc.attributeio.AttributeIO;
import org.geotools.data.jdbc.attributeio.WKBAttributeIO;
import org.geotools.data.jdbc.attributeio.WKTAttributeIO;
import org.geotools.data.jdbc.datasource.DataSourceUtil;
import org.geotools.data.mysql.MySQLFeatureWriter;
import org.geotools.data.mysql.MySQLSQLBuilder;
import org.geotools.factory.Hints;
import org.geotools.feature.AttributeTypeBuilder;
import org.geotools.filter.SQLEncoderMySQL;
import org.geotools.referencing.CRS;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.filter.Filter;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MySQLDataStore
extends JDBCDataStore {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.data.mysql");
    protected boolean wkbEnabled;
    private static Map<String, Class> GEOM_TYPE_MAP = new HashMap<String, Class>();
    private static final Set MYSQL_HINTS;

    public MySQLDataStore(DataSource dataSource) throws IOException {
        this(dataSource, null);
    }

    public MySQLDataStore(DataSource dataSource, String databaseSchemaName) throws IOException {
        this(dataSource, databaseSchemaName, null);
    }

    public MySQLDataStore(DataSource dataSource, String databaseSchemaName, String namespace) throws IOException {
        super(dataSource, JDBCDataStoreConfig.createWithNameSpaceAndSchemaName((String)namespace, (String)databaseSchemaName));
    }

    public static MySQLDataStore getInstance(String host, String schema, String username, String password) throws IOException, SQLException {
        return MySQLDataStore.getInstance(host, 3306, schema, username, password);
    }

    public static MySQLDataStore getInstance(String host, int port, String schema, String username, String password) throws IOException, SQLException {
        String url = "jdbc:mysql://" + host + ":" + port + "/" + schema;
        String driver = "com.mysql.jdbc.Driver";
        return new MySQLDataStore((DataSource)DataSourceUtil.buildDefaultDataSource((String)url, (String)driver, (String)username, (String)password, (String)"select version()"));
    }

    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriter(String typeName) throws IOException {
        return this.getFeatureWriter(typeName, (Filter)Filter.INCLUDE, Transaction.AUTO_COMMIT);
    }

    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriterAppend(String typeName) throws IOException {
        return this.getFeatureWriterAppend(typeName, Transaction.AUTO_COMMIT);
    }

    protected AttributeDescriptor buildAttributeType(ResultSet rs) throws IOException {
        int TABLE_NAME = 3;
        int COLUMN_NAME = 4;
        int DATA_TYPE = 5;
        int TYPE_NAME = 6;
        try {
            int dataType = rs.getInt(5);
            if (dataType == 1111 || dataType == -2) {
                String typeName = rs.getString(6);
                AttributeTypeBuilder builder = new AttributeTypeBuilder();
                Class geom = MySQLDataStore.getGeomClass(typeName);
                if (geom == null) {
                    return super.buildAttributeType(rs);
                }
                builder.setBinding(geom);
                int srid = this.determineSRID(rs.getString(3), rs.getString(4));
                CoordinateReferenceSystem crs = null;
                try {
                    crs = CRS.decode((String)("EPSG:" + srid));
                }
                catch (Exception e) {
                    crs = null;
                }
                builder.setCRS(crs);
                builder.setNillable(true);
                builder.setName(rs.getString(4));
                return builder.buildDescriptor(rs.getString(4));
            }
            return super.buildAttributeType(rs);
        }
        catch (SQLException e) {
            throw new IOException("SQL exception occurred: " + e.getMessage());
        }
    }

    public static Class getGeomClass(String type) {
        return GEOM_TYPE_MAP.get(type.toUpperCase());
    }

    public SQLBuilder getSqlBuilder(String typeName) throws IOException {
        SQLEncoderMySQL encoder = new SQLEncoderMySQL();
        encoder.setFIDMapper(this.getFIDMapper(typeName));
        MySQLSQLBuilder builder = new MySQLSQLBuilder(encoder, this.getSchema(typeName));
        builder.setWKBEnabled(this.wkbEnabled);
        return builder;
    }

    protected AttributeIO getGeometryAttributeIO(AttributeDescriptor type, QueryData queryData) {
        if (this.wkbEnabled) {
            return new WKBAttributeIO(queryData.getHints());
        }
        return new WKTAttributeIO();
    }

    protected JDBCFeatureWriter createFeatureWriter(FeatureReader<SimpleFeatureType, SimpleFeature> reader, QueryData queryData) throws IOException {
        LOGGER.fine("returning jdbc feature writer");
        return new MySQLFeatureWriter(reader, queryData);
    }

    public Set getSupportedHints() {
        return MYSQL_HINTS;
    }

    protected void setAutoCommit(boolean forWrite, Connection conn) throws SQLException {
    }

    public boolean isWKBEnabled() {
        return this.wkbEnabled;
    }

    public void setWKBEnabled(boolean enabled) {
        this.wkbEnabled = enabled;
    }

    protected int determineSRID(String table, String column) throws IOException {
        Connection con = null;
        try {
            con = this.getConnection(Transaction.AUTO_COMMIT);
            Statement stmt = con.createStatement();
            ResultSet rslt = stmt.executeQuery("SELECT SRID(" + column + ") FROM  " + table + " LIMIT 1;");
            if (rslt.next()) {
                int srid = rslt.getInt(1);
                JDBCUtils.close((Statement)stmt);
                int n = srid;
                return n;
            }
            try {
                throw new DataSourceException("In table: " + table + ", geometry column: " + column + " was not able to return a valid srid.");
            }
            catch (SQLException sqle) {
                String message = sqle.getMessage();
                throw new DataSourceException(message, (Throwable)sqle);
            }
        }
        finally {
            JDBCUtils.close((Connection)con, (Transaction)Transaction.AUTO_COMMIT, null);
        }
    }

    static {
        GEOM_TYPE_MAP.put("GEOMETRY", Geometry.class);
        GEOM_TYPE_MAP.put("POINT", Point.class);
        GEOM_TYPE_MAP.put("LINESTRING", LineString.class);
        GEOM_TYPE_MAP.put("POLYGON", Polygon.class);
        GEOM_TYPE_MAP.put("MULTIPOINT", MultiPoint.class);
        GEOM_TYPE_MAP.put("MULTILINESTRING", MultiLineString.class);
        GEOM_TYPE_MAP.put("MULTIPOLYGON", MultiPolygon.class);
        GEOM_TYPE_MAP.put("GEOMETRYCOLLECTION", GeometryCollection.class);
        MYSQL_HINTS = Collections.unmodifiableSet(new HashSet<Object>(Arrays.asList(Hints.FEATURE_DETACHED, Hints.JTS_COORDINATE_SEQUENCE_FACTORY, Hints.JTS_GEOMETRY_FACTORY)));
    }
}

