/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.raster;

import com.vividsolutions.jts.algorithm.InteriorPointArea;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineSegment;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.operation.polygonize.Polygonizer;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.image.RenderedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.CancellationException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.jai.iterator.RandomIter;
import javax.media.jai.iterator.RandomIterFactory;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.InvalidGridGeometryException;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureCollections;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.geometry.Envelope2D;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.process.ProcessException;
import org.geotools.process.ProcessFactory;
import org.geotools.process.impl.AbstractProcess;
import org.geotools.process.raster.RasterToVectorFactory;
import org.geotools.referencing.CRS;
import org.geotools.util.NullProgressListener;
import org.geotools.util.SimpleInternationalString;
import org.geotools.util.SubProgressListener;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.metadata.spatial.PixelOrientation;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.InternationalString;
import org.opengis.util.ProgressListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RasterToVectorProcess
extends AbstractProcess {
    private Polygonizer polygonizer;
    private GridCoverage2D coverage;
    private MathTransform2D transformLR;
    private Rectangle imageBounds;
    private double cellWidthX;
    private double cellWidthY;
    private static final int TL = 0;
    private static final int TR = 1;
    private static final int BL = 2;
    private static final int BR = 3;
    private static final int TL_BR = 4;
    private static final int TR_BL = 5;
    private static final int CROSS = 6;
    private static final double EPSILON = 1.0E-8;
    private SortedSet<Double> outside;
    private Map<Integer, LineSegment> vertLines;
    private LineSegment horizLine;
    private List<LineString> lines;
    private GeometryFactory geomFactory;
    List<Coordinate> cornerTouches;
    private RenderedImage image;

    RasterToVectorProcess(ProcessFactory factory) {
        super(factory);
    }

    @Override
    public Map<String, Object> execute(Map<String, Object> input, ProgressListener monitor) throws ProcessException {
        GridCoverage2D cov = (GridCoverage2D)input.get(RasterToVectorFactory.RASTER.key);
        int band = (Integer)input.get(RasterToVectorFactory.BAND.key);
        org.opengis.geometry.Envelope bounds = (org.opengis.geometry.Envelope)input.get(RasterToVectorFactory.BOUNDS.key);
        Collection outsideValues = (Collection)input.get(RasterToVectorFactory.OUTSIDE.key);
        FeatureCollection<SimpleFeatureType, SimpleFeature> features = this.convert(cov, band, bounds, outsideValues, monitor);
        HashMap<String, Object> results = new HashMap<String, Object>();
        results.put(RasterToVectorFactory.RESULT_FEATURES.key, features);
        return results;
    }

    public static FeatureCollection<SimpleFeatureType, SimpleFeature> process(GridCoverage2D cov, int band, org.opengis.geometry.Envelope bounds, Collection<Double> outsideValues, ProgressListener monitor) throws ProcessException {
        RasterToVectorFactory factory = new RasterToVectorFactory();
        RasterToVectorProcess process = factory.create();
        return process.convert(cov, band, bounds, outsideValues, monitor);
    }

    private FeatureCollection<SimpleFeatureType, SimpleFeature> convert(GridCoverage2D cov, int band, org.opengis.geometry.Envelope bounds, Collection<Double> outsideValues, ProgressListener monitor) throws ProcessException {
        if (monitor == null) {
            monitor = new NullProgressListener();
        } else {
            monitor.started();
        }
        ReferencedEnvelope workingBounds = null;
        if (bounds == null) {
            workingBounds = new ReferencedEnvelope(cov.getEnvelope());
        } else {
            CoordinateReferenceSystem sourceCRS = bounds.getCoordinateReferenceSystem();
            CoordinateReferenceSystem targetCRS = cov.getCoordinateReferenceSystem();
            if (sourceCRS != null && !CRS.equalsIgnoreMetadata((Object)sourceCRS, (Object)targetCRS)) {
                throw new ProcessException("CRS of bounds must match that of the coverage");
            }
            ReferencedEnvelope inputBounds = new ReferencedEnvelope(bounds);
            ReferencedEnvelope covBounds = new ReferencedEnvelope(cov.getEnvelope());
            workingBounds = new ReferencedEnvelope(covBounds.intersection((Envelope)inputBounds), targetCRS);
            if (workingBounds == null || workingBounds.isEmpty()) {
                throw new ProcessException("Specified bounds lie wholly outside of coverage");
            }
        }
        try {
            FeatureCollection<SimpleFeatureType, SimpleFeature> features;
            monitor.setTask((InternationalString)new SimpleInternationalString("Initializing"));
            this.initialize(cov, (org.opengis.geometry.Envelope)workingBounds, (ProgressListener)new SubProgressListener(monitor, 10.0f));
            monitor.setTask((InternationalString)new SimpleInternationalString("Vectorizing"));
            this.vectorizeAndCollectBoundaries(band, outsideValues, (ProgressListener)new SubProgressListener(monitor, 70.0f));
            SimpleFeatureType schema = RasterToVectorFactory.getSchema(cov.getCoordinateReferenceSystem());
            monitor.setTask((InternationalString)new SimpleInternationalString("Creating polygon features"));
            FeatureCollection<SimpleFeatureType, SimpleFeature> featureCollection = features = this.assembleFeatures(cov, band, schema, (ProgressListener)new SubProgressListener(monitor, 20.0f));
            return featureCollection;
        }
        catch (Exception ex) {
            throw new ProcessException(ex);
        }
        finally {
            monitor.complete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FeatureCollection<SimpleFeatureType, SimpleFeature> assembleFeatures(GridCoverage2D grid, int band, SimpleFeatureType type, ProgressListener monitor) {
        if (monitor == null) {
            monitor = new NullProgressListener();
        }
        FeatureCollection features = FeatureCollections.newCollection();
        SimpleFeatureBuilder builder = new SimpleFeatureBuilder(type);
        Point2D.Double p = new Point2D.Double();
        double[] bandData = new double[grid.getNumSampleDimensions()];
        this.polygonizer.add(this.lines);
        Collection polygons = this.polygonizer.getPolygons();
        int size = polygons.size();
        try {
            float progressScale = 100.0f / (float)size;
            monitor.started();
            int index = 0;
            Iterator i = polygons.iterator();
            while (i.hasNext()) {
                if (monitor.isCanceled()) {
                    throw new CancellationException();
                }
                monitor.progress(progressScale * (float)index);
                Polygon poly = (Polygon)i.next();
                InteriorPointArea ipa = new InteriorPointArea((Geometry)poly);
                Coordinate c = ipa.getInteriorPoint();
                Point inside = this.geomFactory.createPoint(c);
                if (!poly.contains((Geometry)inside)) {
                    boolean found = false;
                    for (Coordinate ringC : poly.getExteriorRing().getCoordinates()) {
                        c.x = ringC.x + this.cellWidthX / 2.0;
                        c.y = ringC.y;
                        inside = this.geomFactory.createPoint(c);
                        if (!poly.contains((Geometry)inside)) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        throw new IllegalStateException("Can't locate interior point for polygon");
                    }
                }
                ((Point2D)p).setLocation(c.x, c.y);
                bandData = grid.evaluate((Point2D)p, bandData);
                if (!this.isOutside(bandData[band])) {
                    builder.add((Object)poly);
                    builder.add((Object)((int)bandData[band]));
                    features.add((Feature)builder.buildFeature(null));
                }
                ++index;
            }
            FeatureCollection featureCollection = features;
            return featureCollection;
        }
        finally {
            monitor.complete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize(GridCoverage2D coverage, org.opengis.geometry.Envelope bounds, ProgressListener monitor) throws TransformException, InvalidGridGeometryException {
        if (monitor == null) {
            monitor = new NullProgressListener();
        }
        try {
            monitor.started();
            this.coverage = coverage;
            GridGeometry2D gridGeom = coverage.getGridGeometry();
            this.image = coverage.getRenderedImage();
            this.transformLR = coverage.getGridGeometry().getGridToCRS2D(PixelOrientation.LOWER_RIGHT);
            monitor.progress(30.0f);
            this.imageBounds = coverage.getGridGeometry().worldToGrid(new Envelope2D(bounds));
            this.cellWidthX = gridGeom.getEnvelope2D().getSpan(gridGeom.axisDimensionX) / (double)gridGeom.getGridRange2D().getSpan(gridGeom.gridDimensionX);
            this.cellWidthY = gridGeom.getEnvelope2D().getSpan(gridGeom.axisDimensionY) / (double)gridGeom.getGridRange2D().getSpan(gridGeom.gridDimensionY);
            this.lines = new ArrayList<LineString>();
            this.geomFactory = new GeometryFactory();
            this.polygonizer = new Polygonizer();
            monitor.progress(80.0f);
            this.vertLines = new HashMap<Integer, LineSegment>();
            this.cornerTouches = new ArrayList<Coordinate>();
        }
        finally {
            monitor.complete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void vectorizeAndCollectBoundaries(int band, Collection<Double> outsideValues, ProgressListener monitor) {
        if (monitor == null) {
            monitor = new NullProgressListener();
        }
        try {
            double[] curData = new double[4];
            RandomIter imageIter = RandomIterFactory.create((RenderedImage)this.image, null);
            this.outside = new TreeSet<Double>();
            if (outsideValues == null || outsideValues.isEmpty()) {
                this.outside.add(Double.NaN);
            } else {
                this.outside.addAll(outsideValues);
            }
            float progressScale = 100.0f / (float)(this.imageBounds.y + this.imageBounds.height - 1);
            for (int row = this.imageBounds.y - 1; row < this.imageBounds.y + this.imageBounds.height; ++row) {
                if (monitor.isCanceled()) {
                    throw new CancellationException();
                }
                monitor.progress(progressScale * (float)row);
                curData[1] = curData[3] = this.outside.first().doubleValue();
                for (int col = this.imageBounds.x - 1; col < this.imageBounds.x + this.imageBounds.width; ++col) {
                    boolean[] ok = this.inDataWindow(row, col);
                    curData[0] = curData[1];
                    curData[2] = curData[3];
                    double d = curData[1] = ok[1] ? imageIter.getSampleDouble(col + 1, row, band) : this.outside.first().doubleValue();
                    if (this.isOutside(curData[1])) {
                        curData[1] = this.outside.first();
                    }
                    double d2 = curData[3] = ok[3] ? imageIter.getSampleDouble(col + 1, row + 1, band) : this.outside.first().doubleValue();
                    if (this.isOutside(curData[3])) {
                        curData[3] = this.outside.first();
                    }
                    this.updateCoordList(row, col, curData);
                }
            }
        }
        finally {
            monitor.complete();
        }
    }

    private boolean[] inDataWindow(int row, int col) {
        int rowflag;
        boolean[] ok = new boolean[4];
        int n = row < this.imageBounds.y ? -1 : (rowflag = row >= this.imageBounds.y + this.imageBounds.height - 1 ? 1 : 0);
        int colflag = col < this.imageBounds.x ? -1 : (col >= this.imageBounds.x + this.imageBounds.width - 1 ? 1 : 0);
        ok[0] = rowflag >= 0 && colflag >= 0;
        ok[1] = rowflag >= 0 && colflag < 1;
        ok[2] = rowflag < 1 && colflag >= 0;
        ok[3] = rowflag < 1 && colflag < 1;
        return ok;
    }

    private void updateCoordList(int row, int col, double[] curData) {
        switch (this.nbrConfig(curData)) {
            case 0: {
                break;
            }
            case 1: {
                this.horizLine = new LineSegment();
                this.horizLine.p0.x = col;
                LineSegment seg = new LineSegment();
                seg.p0.y = row;
                this.vertLines.put(col, seg);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                this.horizLine.p1.x = col;
                this.addHorizLine(row);
                this.horizLine = null;
                LineSegment seg = new LineSegment();
                seg.p0.y = row;
                this.vertLines.put(col, seg);
                break;
            }
            case 4: {
                this.horizLine.p1.x = col;
                this.addHorizLine(row);
                this.horizLine = null;
                LineSegment seg = this.vertLines.get(col);
                seg.p1.y = row;
                this.addVertLine(col);
                this.vertLines.remove(col);
                break;
            }
            case 5: {
                this.horizLine = new LineSegment();
                this.horizLine.p0.x = col;
                LineSegment seg = this.vertLines.get(col);
                seg.p1.y = row;
                this.addVertLine(col);
                this.vertLines.remove(col);
                break;
            }
            case 6: {
                this.horizLine.p1.x = col;
                this.addHorizLine(row);
                this.horizLine.p0.x = col;
                LineSegment seg = this.vertLines.get(col);
                seg.p1.y = row;
                this.addVertLine(col);
                this.vertLines.remove(col);
                break;
            }
            case 7: {
                this.horizLine.p1.x = col;
                this.addHorizLine(row);
                this.horizLine.p0.x = col;
                LineSegment seg = new LineSegment();
                seg.p0.y = row;
                this.vertLines.put(col, seg);
                break;
            }
            case 8: {
                this.horizLine.p1.x = col;
                this.addHorizLine(row);
                this.horizLine = null;
                LineSegment seg = this.vertLines.get(col);
                seg.p1.y = row;
                this.addVertLine(col);
                seg = new LineSegment();
                seg.p0.y = row;
                this.vertLines.put(col, seg);
                break;
            }
            case 9: {
                this.horizLine = new LineSegment();
                this.horizLine.p0.x = col;
                LineSegment seg = this.vertLines.get(col);
                seg.p1.y = row;
                this.addVertLine(col);
                seg = new LineSegment();
                seg.p0.y = row;
                this.vertLines.put(col, seg);
                break;
            }
            case 10: {
                this.horizLine.p1.x = col;
                this.addHorizLine(row);
                this.horizLine.p0.x = col;
                LineSegment seg = this.vertLines.get(col);
                seg.p1.y = row;
                this.addVertLine(col);
                seg = new LineSegment();
                seg.p0.y = row;
                this.vertLines.put(col, seg);
                int z = -1;
                if (this.isDifferent(curData[0], curData[3])) {
                    if (!this.isDifferent(curData[1], curData[2])) {
                        z = 6;
                    }
                } else {
                    z = this.isDifferent(curData[1], curData[2]) ? 4 : 5;
                }
                if (z == -1) break;
                this.cornerTouches.add(new Coordinate((double)col, (double)row, (double)z));
                break;
            }
        }
    }

    private int nbrConfig(double[] curData) {
        if (this.isDifferent(curData[0], curData[1])) {
            if (this.isDifferent(curData[0], curData[2])) {
                if (this.isDifferent(curData[2], curData[3])) {
                    if (this.isDifferent(curData[1], curData[3])) {
                        return 10;
                    }
                    return 8;
                }
                if (this.isDifferent(curData[1], curData[3])) {
                    return 6;
                }
                return 4;
            }
            if (this.isDifferent(curData[2], curData[3])) {
                if (this.isDifferent(curData[1], curData[3])) {
                    return 9;
                }
                return 0;
            }
            return 5;
        }
        if (this.isDifferent(curData[0], curData[2])) {
            if (this.isDifferent(curData[2], curData[3])) {
                if (this.isDifferent(curData[1], curData[3])) {
                    return 7;
                }
                return 3;
            }
            return 2;
        }
        if (this.isDifferent(curData[1], curData[3])) {
            return 1;
        }
        return 11;
    }

    private void addHorizLine(int row) {
        Point2D.Double pixelStart = new Point2D.Double(this.horizLine.p0.x, row);
        Point2D.Double pixelEnd = new Point2D.Double(this.horizLine.p1.x, row);
        Point2D.Double rwStart = new Point2D.Double();
        Point2D.Double rwEnd = new Point2D.Double();
        try {
            this.transformLR.transform((Point2D)pixelStart, (Point2D)rwStart);
            this.transformLR.transform((Point2D)pixelEnd, (Point2D)rwEnd);
        }
        catch (TransformException ex) {
            Logger.getLogger(RasterToVectorProcess.class.getName()).log(Level.SEVERE, null, ex);
        }
        Coordinate[] coords = new Coordinate[]{new Coordinate(((Point2D)rwStart).getX(), ((Point2D)rwStart).getY()), new Coordinate(((Point2D)rwEnd).getX(), ((Point2D)rwEnd).getY())};
        this.lines.add(this.geomFactory.createLineString(coords));
    }

    private void addVertLine(int col) {
        Point2D.Double pixelStart = new Point2D.Double(col, this.vertLines.get((Object)Integer.valueOf((int)col)).p0.y);
        Point2D.Double pixelEnd = new Point2D.Double(col, this.vertLines.get((Object)Integer.valueOf((int)col)).p1.y);
        Point2D.Double rwStart = new Point2D.Double();
        Point2D.Double rwEnd = new Point2D.Double();
        try {
            this.transformLR.transform((Point2D)pixelStart, (Point2D)rwStart);
            this.transformLR.transform((Point2D)pixelEnd, (Point2D)rwEnd);
        }
        catch (TransformException ex) {
            Logger.getLogger(RasterToVectorProcess.class.getName()).log(Level.SEVERE, null, ex);
        }
        Coordinate[] coords = new Coordinate[]{new Coordinate(((Point2D)rwStart).getX(), ((Point2D)rwStart).getY()), new Coordinate(((Point2D)rwEnd).getX(), ((Point2D)rwEnd).getY())};
        GeometryFactory gf = new GeometryFactory();
        this.lines.add(gf.createLineString(coords));
    }

    private boolean isOutside(double value) {
        for (Double d : this.outside) {
            if (this.isDifferent(d, value)) continue;
            return true;
        }
        return false;
    }

    private boolean isDifferent(double a, double b) {
        if (Double.isNaN(a) ^ Double.isNaN(b)) {
            return true;
        }
        if (Double.isNaN(a) && Double.isNaN(b)) {
            return false;
        }
        return Math.abs(a - b) > 1.0E-8;
    }
}

