/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.literal;

import com.vividsolutions.jts.geom.Geometry;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.geotools.process.Process;
import org.geotools.process.literal.UnionFactory;
import org.geotools.text.Text;
import org.geotools.util.NullProgressListener;
import org.opengis.util.ProgressListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class UnionProcess
implements Process {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> execute(Map<String, Object> input, ProgressListener monitor) {
        if (monitor == null) {
            monitor = new NullProgressListener();
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>(1);
        try {
            monitor.started();
            monitor.setTask(Text.text("Grabbing arguments"));
            monitor.progress(10.0f);
            List list = (List)input.get(UnionFactory.GEOM1.key);
            int div = list.size();
            if (div < 1) {
                div = 1;
            }
            int chunk = 80 / div;
            int count = 1;
            Geometry result = null;
            for (Geometry geom : list) {
                if (monitor.isCanceled()) {
                    Map<String, Object> map = null;
                    return map;
                }
                if (result == null) {
                    result = geom;
                    continue;
                }
                monitor.setTask(Text.text("Processing Union " + count + " of " + list.size()));
                ++count;
                monitor.progress(10.0f + (float)chunk);
                result = result.union(geom);
            }
            monitor.setTask(Text.text("Encoding result"));
            monitor.progress(90.0f);
            resultMap.put(UnionFactory.RESULT.key, result);
            monitor.complete();
            HashMap<String, Object> hashMap = resultMap;
            return hashMap;
        }
        catch (Exception eek) {
            monitor.exceptionOccurred((Throwable)eek);
            Map<String, Object> map = null;
            return map;
        }
        finally {
            monitor.dispose();
        }
    }
}

