/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.awt.BasicStroke;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.image.BufferedImage;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.geometry.Envelope2D;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.GeodeticCalculator;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.operation.builder.GridToEnvelopeMapper;
import org.geotools.referencing.operation.matrix.XAffineTransform;
import org.geotools.renderer.style.GraphicStyle2D;
import org.geotools.renderer.style.IconStyle2D;
import org.geotools.renderer.style.LineStyle2D;
import org.geotools.renderer.style.Style2D;
import org.geotools.resources.i18n.Errors;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.EngineeringCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public final class RendererUtilities {
    private static final Logger LOGGER = Logging.getLogger((String)RendererUtilities.class.getName());
    private static final ThreadLocal<GridToEnvelopeMapper> gridToEnvelopeMappers = new ThreadLocal<GridToEnvelopeMapper>(){

        @Override
        protected GridToEnvelopeMapper initialValue() {
            GridToEnvelopeMapper mapper = new GridToEnvelopeMapper();
            mapper.setGridType(PixelInCell.CELL_CORNER);
            return mapper;
        }
    };
    static final double OGC_DEGREE_TO_METERS = 111319.49079327358;

    private RendererUtilities() {
    }

    public static AffineTransform worldToScreenTransform(Envelope mapExtent, Rectangle paintArea) {
        double scaleX = paintArea.getWidth() / mapExtent.getWidth();
        double scaleY = paintArea.getHeight() / mapExtent.getHeight();
        double tx = -mapExtent.getMinX() * scaleX;
        double ty = mapExtent.getMinY() * scaleY + paintArea.getHeight();
        AffineTransform at = new AffineTransform(scaleX, 0.0, 0.0, -scaleY, tx, ty);
        AffineTransform originTranslation = AffineTransform.getTranslateInstance(paintArea.x, paintArea.y);
        originTranslation.concatenate(at);
        return originTranslation != null ? originTranslation : at;
    }

    public static AffineTransform worldToScreenTransform(ReferencedEnvelope mapExtent, Rectangle paintArea) {
        Envelope2D genvelope = new Envelope2D((org.opengis.geometry.Envelope)mapExtent);
        GridToEnvelopeMapper m = gridToEnvelopeMappers.get();
        try {
            m.setGridRange((GridEnvelope)new GridEnvelope2D(paintArea));
            m.setEnvelope((org.opengis.geometry.Envelope)genvelope);
            return m.createAffineTransform().createInverse();
        }
        catch (MismatchedDimensionException e) {
            LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            return null;
        }
        catch (NoninvertibleTransformException e) {
            LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            return null;
        }
    }

    public static Envelope createMapEnvelope(Rectangle paintArea, AffineTransform worldToScreen) throws NoninvertibleTransformException {
        double[] pts = new double[]{paintArea.getMinX(), paintArea.getMinY(), paintArea.getMaxX(), paintArea.getMinY(), paintArea.getMaxX(), paintArea.getMaxY(), paintArea.getMinX(), paintArea.getMaxY()};
        worldToScreen.inverseTransform(pts, 0, pts, 0, 4);
        double xMin = Double.MAX_VALUE;
        double yMin = Double.MAX_VALUE;
        double xMax = -1.7976931348623157E308;
        double yMax = -1.7976931348623157E308;
        for (int i = 0; i < 4; ++i) {
            xMin = Math.min(xMin, pts[2 * i]);
            yMin = Math.min(yMin, pts[2 * i + 1]);
            xMax = Math.max(xMax, pts[2 * i]);
            yMax = Math.max(yMax, pts[2 * i + 1]);
        }
        return new Envelope(xMin, xMax, yMin, yMax);
    }

    public static ReferencedEnvelope createMapEnvelope(Rectangle paintArea, AffineTransform worldToScreen, CoordinateReferenceSystem crs) throws NoninvertibleTransformException {
        SingleCRS crs2d = CRS.getHorizontalCRS((CoordinateReferenceSystem)crs);
        if (crs2d == null) {
            throw new UnsupportedOperationException(Errors.format((int)29, (Object)crs));
        }
        Envelope env = RendererUtilities.createMapEnvelope(paintArea, worldToScreen);
        return new ReferencedEnvelope(env, (CoordinateReferenceSystem)crs2d);
    }

    public static double calculateScale(Envelope envelope, CoordinateReferenceSystem coordinateReferenceSystem, int imageWidth, int imageHeight, double DPI) throws TransformException, FactoryException {
        SingleCRS tempCRS = CRS.getHorizontalCRS((CoordinateReferenceSystem)coordinateReferenceSystem);
        if (tempCRS == null) {
            throw new TransformException(Errors.format((int)29, (Object)coordinateReferenceSystem));
        }
        double[] cs = new double[4];
        double[] csLatLong = new double[4];
        Coordinate p1 = new Coordinate(envelope.getMinX(), envelope.getMinY());
        Coordinate p2 = new Coordinate(envelope.getMaxX(), envelope.getMaxY());
        cs[0] = p1.x;
        cs[1] = p1.y;
        cs[2] = p2.x;
        cs[3] = p2.y;
        MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)tempCRS, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, (boolean)true);
        transform.transform(cs, 0, csLatLong, 0, 2);
        if (csLatLong[0] < -180.0 || csLatLong[0] > 180.0 || csLatLong[2] < -180.0 || csLatLong[2] > 180.0 || csLatLong[1] < -90.0 || csLatLong[1] > 90.0 || csLatLong[3] < -90.0 || csLatLong[3] > 90.0) {
            if (csLatLong[0] > csLatLong[2] || csLatLong[1] > csLatLong[3]) {
                throw new IllegalArgumentException("BBox is backwards");
            }
            if ((csLatLong[0] < -180.0 || csLatLong[0] > 180.0) && (csLatLong[2] < -180.0 || csLatLong[2] > 180.0) && (csLatLong[1] < -90.0 || csLatLong[1] > 90.0) && (csLatLong[3] < -90.0 || csLatLong[3] > 90.0)) {
                throw new IllegalArgumentException("World isn't in the requested bbox");
            }
            double[] newCsLatLong = new double[]{Math.min(Math.max(csLatLong[0], -180.0), 180.0), Math.min(Math.max(csLatLong[1], -90.0), 90.0), Math.min(Math.max(csLatLong[2], -180.0), 180.0), Math.min(Math.max(csLatLong[3], -90.0), 90.0)};
            double[] origProject = new double[4];
            transform.transform(newCsLatLong, 0, origProject, 0, 2);
            double image_min_x = (origProject[0] - envelope.getMinX()) / envelope.getWidth() * (double)imageWidth;
            double image_max_x = (origProject[2] - envelope.getMinX()) / envelope.getWidth() * (double)imageWidth;
            double image_min_y = (origProject[1] - envelope.getMinY()) / envelope.getHeight() * (double)imageHeight;
            double image_max_y = (origProject[3] - envelope.getMinY()) / envelope.getHeight() * (double)imageHeight;
            double distance_ground = JTS.orthodromicDistance((Coordinate)new Coordinate(newCsLatLong[0], newCsLatLong[1]), (Coordinate)new Coordinate(newCsLatLong[2], newCsLatLong[3]), (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
            double pixel_distance = Math.sqrt((image_max_x - image_min_x) * (image_max_x - image_min_x) + (image_max_y - image_min_y) * (image_max_y - image_min_y));
            double pixel_distance_m = pixel_distance / DPI * 2.54 / 100.0;
            return distance_ground / pixel_distance_m;
        }
        double diagonalGroundDistance = JTS.orthodromicDistance((Coordinate)new Coordinate(csLatLong[0], csLatLong[1]), (Coordinate)new Coordinate(csLatLong[2], csLatLong[3]), (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        double diagonalPixelDistancePixels = Math.sqrt(imageWidth * imageWidth + imageHeight * imageHeight);
        double diagonalPixelDistanceMeters = diagonalPixelDistancePixels / DPI * 2.54 / 100.0;
        return diagonalGroundDistance / diagonalPixelDistanceMeters;
    }

    public static double calculatePixelsPerMeterRatio(double scaleDenominator, Map hints) {
        if (scaleDenominator <= 0.0) {
            throw new IllegalArgumentException("The scale denominator must be positive.");
        }
        double scale = 1.0 / scaleDenominator;
        return scale * (RendererUtilities.getDpi(hints) / 0.0254);
    }

    public static double calculateOGCScale(ReferencedEnvelope envelope, int imageWidth, Map hints) {
        if (envelope.getCoordinateReferenceSystem() instanceof GeographicCRS) {
            return envelope.getWidth() * 111319.49079327358 / ((double)imageWidth / RendererUtilities.getDpi(hints) * 0.0254);
        }
        return envelope.getWidth() / ((double)imageWidth / RendererUtilities.getDpi(hints) * 0.0254);
    }

    public static double calculateOGCScaleAffine(CoordinateReferenceSystem crs, AffineTransform worldToScreen, Map hints) {
        double scale = XAffineTransform.getScale((AffineTransform)worldToScreen);
        if (crs instanceof GeographicCRS) {
            return 111319.49079327358 * RendererUtilities.getDpi(hints) / (scale * 0.0254);
        }
        return RendererUtilities.getDpi(hints) / (scale * 0.0254);
    }

    public static double calculateScale(ReferencedEnvelope envelope, int imageWidth, int imageHeight, Map hints) throws TransformException, FactoryException {
        if (hints != null && hints.containsKey("declaredScaleDenominator")) {
            Double scale = (Double)hints.get("declaredScaleDenominator");
            if (scale <= 0.0) {
                throw new IllegalArgumentException("the declaredScaleDenominator must be greater than 0, was: " + scale);
            }
            return scale;
        }
        return RendererUtilities.calculateScale(envelope, imageWidth, imageHeight, RendererUtilities.getDpi(hints));
    }

    public static double getDpi(Map hints) {
        if (hints != null && hints.containsKey("dpi")) {
            return ((Number)hints.get("dpi")).doubleValue();
        }
        return 90.7142857142857;
    }

    public static double calculateScale(ReferencedEnvelope envelope, int imageWidth, int imageHeight, double DPI) throws TransformException, FactoryException {
        double diagonalGroundDistance;
        if (!(envelope.getCoordinateReferenceSystem() instanceof EngineeringCRS)) {
            SingleCRS tempCRS = CRS.getHorizontalCRS((CoordinateReferenceSystem)envelope.getCoordinateReferenceSystem());
            if (tempCRS == null) {
                throw new TransformException(Errors.format((int)29, (Object)envelope.getCoordinateReferenceSystem()));
            }
            envelope = new ReferencedEnvelope((Envelope)envelope, (CoordinateReferenceSystem)tempCRS);
            MathTransform toWGS84 = CRS.findMathTransform((CoordinateReferenceSystem)tempCRS, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, (boolean)true);
            GeneralEnvelope sourceCRSEnvelope = (GeneralEnvelope)CRS.getEnvelope((CoordinateReferenceSystem)tempCRS);
            if (sourceCRSEnvelope == null) {
                try {
                    sourceCRSEnvelope = CRS.transform((MathTransform)toWGS84.inverse(), (org.opengis.geometry.Envelope)CRS.getEnvelope((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84));
                }
                catch (TransformException e) {
                }
                catch (AssertionError ae) {
                    // empty catch block
                }
            }
            GeneralEnvelope intersectedEnvelope = new GeneralEnvelope((org.opengis.geometry.Envelope)envelope);
            if (sourceCRSEnvelope != null) {
                intersectedEnvelope.intersect((org.opengis.geometry.Envelope)sourceCRSEnvelope);
                if (intersectedEnvelope.isEmpty()) {
                    throw new IllegalArgumentException("The provided envelope is outside the source CRS definition area");
                }
                if (!intersectedEnvelope.equals((Object)envelope)) {
                    double scale0 = intersectedEnvelope.getLength(0) / envelope.getLength(0);
                    double scale1 = intersectedEnvelope.getLength(1) / envelope.getLength(1);
                    imageWidth = (int)((double)imageWidth * scale0);
                    imageHeight = (int)((double)imageHeight * scale1);
                }
            }
            GeneralEnvelope geographicEnvelope = CRS.transform((MathTransform)toWGS84, (org.opengis.geometry.Envelope)intersectedEnvelope);
            geographicEnvelope.setCoordinateReferenceSystem((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
            GeodeticCalculator calculator = new GeodeticCalculator((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
            DirectPosition lowerLeftCorner = geographicEnvelope.getLowerCorner();
            DirectPosition upperRightCorner = geographicEnvelope.getUpperCorner();
            calculator.setStartingGeographicPoint(lowerLeftCorner.getOrdinate(0), lowerLeftCorner.getOrdinate(1));
            calculator.setDestinationGeographicPoint(upperRightCorner.getOrdinate(0), upperRightCorner.getOrdinate(1));
            diagonalGroundDistance = calculator.getOrthodromicDistance();
        } else {
            diagonalGroundDistance = Math.sqrt(envelope.getWidth() * envelope.getWidth() + envelope.getHeight() * envelope.getHeight());
        }
        double diagonalPixelDistancePixels = Math.sqrt(imageWidth * imageWidth + imageHeight * imageHeight);
        double diagonalPixelDistanceMeters = diagonalPixelDistancePixels / DPI * 2.54 / 100.0;
        return diagonalGroundDistance / diagonalPixelDistanceMeters;
    }

    public static AffineTransform worldToScreenTransform(Envelope mapExtent, Rectangle paintArea, CoordinateReferenceSystem destinationCrs) throws TransformException {
        SingleCRS crs2D = CRS.getHorizontalCRS((CoordinateReferenceSystem)destinationCrs);
        if (crs2D == null) {
            throw new TransformException(Errors.format((int)29, (Object)destinationCrs));
        }
        boolean lonFirst = crs2D.getCoordinateSystem().getAxis(0).getDirection().absolute().equals((Object)AxisDirection.EAST);
        GeneralEnvelope newEnvelope = lonFirst ? new GeneralEnvelope(new double[]{mapExtent.getMinX(), mapExtent.getMinY()}, new double[]{mapExtent.getMaxX(), mapExtent.getMaxY()}) : new GeneralEnvelope(new double[]{mapExtent.getMinY(), mapExtent.getMinX()}, new double[]{mapExtent.getMaxY(), mapExtent.getMaxX()});
        newEnvelope.setCoordinateReferenceSystem(destinationCrs);
        GridToEnvelopeMapper m = gridToEnvelopeMappers.get();
        m.setGridRange((GridEnvelope)new GridEnvelope2D(paintArea));
        m.setEnvelope((org.opengis.geometry.Envelope)newEnvelope);
        return (AffineTransform)m.createTransform().inverse();
    }

    public static Geometry getCentroid(Geometry g) {
        if (g instanceof MultiPoint) {
            return g;
        }
        if (g instanceof GeometryCollection) {
            GeometryCollection gc = (GeometryCollection)g;
            Coordinate[] pts = new Coordinate[gc.getNumGeometries()];
            int length = gc.getNumGeometries();
            for (int t = 0; t < length; ++t) {
                pts[t] = RendererUtilities.pointInGeometry(gc.getGeometryN(t)).getCoordinate();
            }
            return g.getFactory().createMultiPoint(pts);
        }
        if (g != null) {
            return RendererUtilities.pointInGeometry(g);
        }
        return null;
    }

    private static Geometry pointInGeometry(Geometry g) {
        Point p = g.getCentroid();
        if (g instanceof Polygon) {
            if (Double.isNaN(p.getX()) || Double.isNaN(p.getY())) {
                return g.getFactory().createPoint(g.getCoordinate());
            }
            if (g.isValid() && !g.contains((Geometry)p)) {
                try {
                    p = g.getInteriorPoint();
                }
                catch (Exception e) {
                    return p;
                }
            } else {
                return p;
            }
        }
        return p;
    }

    public static double getStyle2DSize(Style2D style) {
        if (style instanceof GraphicStyle2D) {
            BufferedImage image = ((GraphicStyle2D)style).getImage();
            return RendererUtilities.maxSize(image.getWidth(), image.getHeight());
        }
        if (style instanceof IconStyle2D) {
            Icon icon = ((IconStyle2D)style).getIcon();
            return RendererUtilities.maxSize(icon.getIconWidth(), icon.getIconHeight());
        }
        if (style instanceof LineStyle2D) {
            LineStyle2D ls = (LineStyle2D)style;
            double gsSize = RendererUtilities.getStyle2DSize(ls.getGraphicStroke());
            double strokeSize = 0.0;
            if (ls.getStroke() instanceof BasicStroke) {
                strokeSize = ((BasicStroke)ls.getStroke()).getLineWidth();
            }
            return RendererUtilities.maxSize(gsSize, strokeSize);
        }
        return 0.0;
    }

    private static double maxSize(double d1, double d2) {
        if (Double.isNaN(d1)) {
            d1 = 0.0;
        }
        if (Double.isNaN(d2)) {
            d2 = 0.0;
        }
        return Math.max(d1, d2);
    }
}

