/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite.gridcoverage2d;

import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.factory.Hints;
import org.geotools.image.ImageWorker;
import org.geotools.renderer.i18n.Vocabulary;
import org.geotools.renderer.lite.gridcoverage2d.ChannelSelectionNode;
import org.geotools.renderer.lite.gridcoverage2d.ColorMapNode;
import org.geotools.renderer.lite.gridcoverage2d.ColorMapUtilities;
import org.geotools.renderer.lite.gridcoverage2d.ContrastEnhancementNode;
import org.geotools.renderer.lite.gridcoverage2d.RootNode;
import org.geotools.renderer.lite.gridcoverage2d.SubchainStyleVisitorCoverageProcessingAdapter;
import org.geotools.resources.coverage.CoverageUtilities;
import org.geotools.styling.ChannelSelection;
import org.geotools.styling.ColorMap;
import org.geotools.styling.ContrastEnhancement;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.StyleVisitor;
import org.geotools.util.SimpleInternationalString;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.util.InternationalString;

public class RasterSymbolizerHelper
extends SubchainStyleVisitorCoverageProcessingAdapter
implements StyleVisitor {
    public synchronized GridCoverage2D execute() {
        GridSampleDimension[] sd;
        GridCoverage2D output = (GridCoverage2D)super.execute();
        RenderedImage outputImage = output.getRenderedImage();
        SampleModel outputImageSampleModel = outputImage.getSampleModel();
        int numBands = outputImageSampleModel.getNumBands();
        int dataType = outputImageSampleModel.getDataType();
        if (numBands > 4) {
            int visibleBand = CoverageUtilities.getVisibleBand((Object)outputImage);
            outputImage = new ImageWorker(outputImage).setRenderingHints((RenderingHints)this.getHints()).retainBands(new int[]{visibleBand}).getRenderedImage();
            sd = new GridSampleDimension[]{output.getSampleDimension(visibleBand)};
        } else {
            sd = output.getSampleDimensions();
        }
        switch (dataType) {
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                outputImage = new ImageWorker(outputImage).setRenderingHints((RenderingHints)this.getHints()).rescaleToBytes().getRenderedImage();
            }
        }
        return this.getCoverageFactory().create((CharSequence)output.getName(), outputImage, output.getGridGeometry(), sd, new GridCoverage[]{output}, output.getProperties());
    }

    public RasterSymbolizerHelper(GridCoverage2D sourceCoverage, Hints hints) {
        super(1, hints, (InternationalString)SimpleInternationalString.wrap((CharSequence)Vocabulary.format(8)), (InternationalString)SimpleInternationalString.wrap((CharSequence)"Simple Coverage Processing Node for RasterSymbolizerHelper"));
        this.addSource(new RootNode(sourceCoverage, hints));
    }

    public synchronized void visit(RasterSymbolizer rs) {
        ColorMapUtilities.ensureNonNull("RasterSymbolizer", rs);
        ChannelSelectionNode csNode = new ChannelSelectionNode();
        ColorMapNode cmNode = new ColorMapNode(this.getHints());
        ContrastEnhancementNode ceNode = new ContrastEnhancementNode(this.getHints());
        this.setSink(ceNode);
        ChannelSelection cs = rs.getChannelSelection();
        csNode.addSource(this.getSource(0));
        csNode.addSink(cmNode);
        csNode.visit(cs);
        ColorMap cm = rs.getColorMap();
        cmNode.addSource(csNode);
        csNode.addSink(cmNode);
        cmNode.visit(cm);
        ContrastEnhancement ce = rs.getContrastEnhancement();
        ceNode.addSource(cmNode);
        cmNode.addSink(ceNode);
        ceNode.visit(ce);
    }
}

