/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.bridge.UserAgentAdapter;
import org.apache.batik.dom.svg.SAXSVGDocumentFactory;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.util.XMLResourceDescriptor;
import org.geotools.renderer.lite.GlyphRenderer;
import org.geotools.renderer.lite.InternalTranscoder;
import org.geotools.styling.Displacement;
import org.geotools.styling.ExternalGraphic;
import org.geotools.styling.Graphic;
import org.geotools.util.logging.Logging;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.svg.SVGDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SVGGlyphRenderer
implements GlyphRenderer {
    private static Hashtable<URL, Document> cache = new Hashtable(10);
    private static Hashtable<URL, GraphicsNode> _gvtCache = new Hashtable();
    private static final List<String> formats = Collections.unmodifiableList(Arrays.asList("image/svg", "image/svg+xml", "image/svg-xml"));
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.rendering");

    private Document getDocument(URL url) throws Exception {
        if (cache.contains(url)) {
            return cache.get(url);
        }
        String parser = XMLResourceDescriptor.getXMLParserClassName();
        SAXSVGDocumentFactory f = new SAXSVGDocumentFactory(parser);
        Document doc = f.createDocument(url.toString());
        cache.put(url, doc);
        return doc;
    }

    @Override
    public boolean canRender(String format) {
        return formats.contains(format.toLowerCase());
    }

    @Override
    public List<String> getFormats() {
        return formats;
    }

    @Override
    public BufferedImage render(Graphic graphic, ExternalGraphic eg, Object feature, int height) {
        try {
            URL svgfile = eg.getLocation();
            InternalTranscoder magic = new InternalTranscoder();
            if (height > 0) {
                magic.addTranscodingHint(InternalTranscoder.KEY_HEIGHT, new Float(height));
            }
            Document inputDoc = this.getDocument(svgfile);
            magic.transcode(inputDoc);
            BufferedImage img = magic.getImage();
            return img;
        }
        catch (IOException mue) {
            LOGGER.log(Level.WARNING, "Unable to load external svg file", mue);
            return null;
        }
        catch (Exception te) {
            LOGGER.log(Level.WARNING, "Unable to load external svg file", te);
            return null;
        }
    }

    @Override
    public void render(Graphics2D g, Graphic graphic, ExternalGraphic eg, Object feature, int height, float centerX, float centerY) {
        try {
            AffineTransform oldTransform;
            URL svgLocation = eg.getLocation();
            GraphicsNode node = this.getGraphicNode(svgLocation);
            Rectangle2D bounds = this.getSvgDocBounds(svgLocation);
            if (bounds == null) {
                bounds = node.getBounds();
            }
            double newWidth = bounds.getWidth();
            double newHeight = bounds.getHeight();
            if (height > 0) {
                double shapeAspectRatio = bounds.getHeight() > 0.0 && bounds.getWidth() > 0.0 ? bounds.getWidth() / bounds.getHeight() : 1.0;
                newWidth = shapeAspectRatio * (double)height;
                newHeight = height;
            }
            if ((oldTransform = node.getTransform()) == null) {
                oldTransform = new AffineTransform();
            }
            AffineTransform transform = new AffineTransform(oldTransform);
            if (graphic.getRotation() != null) {
                Object value = graphic.getRotation().evaluate(feature);
                double rotation = 0.0;
                if (value instanceof Number) {
                    rotation = ((Number)value).doubleValue();
                }
                transform.rotate(Math.toRadians(rotation));
            }
            transform.translate((double)centerX - newWidth / 2.0, (double)centerY - newHeight / 2.0);
            Displacement displacement = graphic.getDisplacement();
            if (displacement != null) {
                Object value;
                double displacementX = 0.0;
                double displacementY = 0.0;
                if (displacement.getDisplacementX() != null && (value = displacement.getDisplacementX().evaluate(feature)) instanceof Number) {
                    displacementX = ((Number)value).doubleValue();
                }
                if (displacement.getDisplacementY() != null && (value = displacement.getDisplacementY().evaluate(feature)) instanceof Number) {
                    displacementY = ((Number)value).doubleValue();
                }
                transform.translate(displacementX, displacementY);
            }
            transform.scale(newWidth / bounds.getWidth(), newHeight / bounds.getHeight());
            node.setTransform(transform);
            node.paint(g);
            node.setTransform(oldTransform);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Unable to load external svg file", e);
        }
        catch (URISyntaxException e) {
            LOGGER.log(Level.WARNING, "Unable to load external svg file", e);
        }
    }

    private Rectangle2D getSvgDocBounds(URL svgLocation) {
        SVGDocument doc = (SVGDocument)cache.get(svgLocation);
        NodeList list = doc.getElementsByTagName("svg");
        Node svgNode = list.item(0);
        NamedNodeMap attrbiutes = svgNode.getAttributes();
        Node widthNode = attrbiutes.getNamedItem("width");
        Node heightNode = attrbiutes.getNamedItem("height");
        if (widthNode != null && heightNode != null) {
            double width = Double.parseDouble(widthNode.getNodeValue());
            double height = Double.parseDouble(heightNode.getNodeValue());
            return new Rectangle2D.Double(0.0, 0.0, width, height);
        }
        return null;
    }

    private GraphicsNode getGraphicNode(URL svgLocation) throws IOException, URISyntaxException {
        if (_gvtCache.contains(svgLocation)) {
            return _gvtCache.get(svgLocation);
        }
        String xmlParser = XMLResourceDescriptor.getXMLParserClassName();
        SAXSVGDocumentFactory df = new SAXSVGDocumentFactory(xmlParser);
        SVGDocument doc = df.createSVGDocument(svgLocation.toURI().toString());
        cache.put(svgLocation, (Document)doc);
        UserAgentAdapter userAgent = new UserAgentAdapter();
        DocumentLoader loader = new DocumentLoader((UserAgent)userAgent);
        BridgeContext ctx = new BridgeContext((UserAgent)userAgent, loader);
        ctx.setDynamic(true);
        GVTBuilder builder = new GVTBuilder();
        GraphicsNode rootNode = builder.build(ctx, (Document)doc);
        _gvtCache.put(svgLocation, rootNode);
        return rootNode;
    }
}

