/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.style;

import com.vividsolutions.jts.geom.Geometry;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.MediaTracker;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.renderer.lite.CustomGlyphRenderer;
import org.geotools.renderer.lite.GlyphRenderer;
import org.geotools.renderer.lite.SVGGlyphRenderer;
import org.geotools.renderer.style.DynamicLineStyle2D;
import org.geotools.renderer.style.DynamicPolygonStyle2D;
import org.geotools.renderer.style.DynamicSymbolFactoryFinder;
import org.geotools.renderer.style.ExpressionExtractor;
import org.geotools.renderer.style.ExternalGraphicFactory;
import org.geotools.renderer.style.FontCache;
import org.geotools.renderer.style.GlyphStyle2D;
import org.geotools.renderer.style.GraphicStyle2D;
import org.geotools.renderer.style.LineStyle2D;
import org.geotools.renderer.style.MarkFactory;
import org.geotools.renderer.style.MarkStyle2D;
import org.geotools.renderer.style.PolygonStyle2D;
import org.geotools.renderer.style.Style;
import org.geotools.renderer.style.Style2D;
import org.geotools.renderer.style.TextStyle2D;
import org.geotools.styling.ExternalGraphic;
import org.geotools.styling.Fill;
import org.geotools.styling.Graphic;
import org.geotools.styling.Halo;
import org.geotools.styling.LabelPlacement;
import org.geotools.styling.LinePlacement;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.Mark;
import org.geotools.styling.PointPlacement;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.Stroke;
import org.geotools.styling.StyleAttributeExtractorTruncated;
import org.geotools.styling.StyleFactoryFinder;
import org.geotools.styling.Symbolizer;
import org.geotools.styling.TextMark;
import org.geotools.styling.TextSymbolizer;
import org.geotools.styling.TextSymbolizer2;
import org.geotools.util.Range;
import org.geotools.util.SoftValueHashMap;
import org.geotools.util.logging.Logging;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;
import org.opengis.style.GraphicalSymbol;

public class SLDStyleFactory {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.rendering");
    private static final Map joinLookup = new HashMap();
    private static final Map capLookup = new HashMap();
    private static final Map fontStyleLookup = new HashMap();
    private static final FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
    private static final Canvas obs = new Canvas();
    private static List glyphRenderers = new ArrayList();
    Map dynamicSymbolizers = new SoftValueHashMap();
    Map staticSymbolizers = new SoftValueHashMap();
    RenderingHints renderingHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
    private boolean lineOptimizationEnabled = false;
    private boolean vectorRenderingEnabled = false;
    private long hits;
    private long requests;
    private double mapScaleDenominator = Double.NaN;

    public RenderingHints getRenderingHints() {
        return this.renderingHints;
    }

    public void setRenderingHints(RenderingHints renderingHints) {
        if (renderingHints == null) {
            return;
        }
        this.renderingHints = renderingHints;
    }

    public boolean isLineOptimizationEnabled() {
        return this.lineOptimizationEnabled;
    }

    public void setLineOptimizationEnabled(boolean lineOptimizationEnabled) {
        this.lineOptimizationEnabled = lineOptimizationEnabled;
    }

    public boolean isVectorRenderingEnabled() {
        return this.vectorRenderingEnabled;
    }

    public void setVectorRenderingEnabled(boolean vectorRenderingEnabled) {
        this.vectorRenderingEnabled = vectorRenderingEnabled;
    }

    public double getHitRatio() {
        return (double)this.hits / (double)this.requests;
    }

    public long getHits() {
        return this.hits;
    }

    public long getRequests() {
        return this.requests;
    }

    public Style2D createStyle(Object drawMe, Symbolizer symbolizer, Range scaleRange) {
        Style2D style = null;
        SymbolizerKey key = new SymbolizerKey(symbolizer, scaleRange);
        style = (Style2D)this.staticSymbolizers.get(key);
        ++this.requests;
        if (style != null) {
            ++this.hits;
        } else {
            style = this.createStyleInternal(drawMe, symbolizer, scaleRange);
            if (this.dynamicSymbolizers.containsKey(key)) {
                return style;
            }
            StyleAttributeExtractorTruncated sae = new StyleAttributeExtractorTruncated();
            sae.visit(symbolizer);
            Set nameSet = sae.getAttributeNameSet();
            if (nameSet == null || nameSet.size() == 0) {
                this.staticSymbolizers.put(key, style);
            } else {
                this.dynamicSymbolizers.put(key, Boolean.TRUE);
            }
        }
        return style;
    }

    private Style2D createStyleInternal(Object drawMe, Symbolizer symbolizer, Range scaleRange) {
        Style2D style = null;
        if (symbolizer instanceof PolygonSymbolizer) {
            style = this.createPolygonStyle(drawMe, (PolygonSymbolizer)symbolizer, scaleRange);
        } else if (symbolizer instanceof LineSymbolizer) {
            style = this.createLineStyle(drawMe, (LineSymbolizer)symbolizer, scaleRange);
        } else if (symbolizer instanceof PointSymbolizer) {
            style = this.createPointStyle(drawMe, (PointSymbolizer)symbolizer, scaleRange);
        } else if (symbolizer instanceof TextSymbolizer) {
            style = this.createTextStyle(drawMe, (TextSymbolizer)symbolizer, scaleRange);
        }
        return style;
    }

    public Style2D createDynamicStyle(SimpleFeature f, Symbolizer symbolizer, Range scaleRange) {
        Style2D style = null;
        if (symbolizer instanceof PolygonSymbolizer) {
            style = this.createDynamicPolygonStyle(f, (PolygonSymbolizer)symbolizer, scaleRange);
        } else if (symbolizer instanceof LineSymbolizer) {
            style = this.createDynamicLineStyle(f, (LineSymbolizer)symbolizer, scaleRange);
        } else {
            throw new UnsupportedOperationException("This kind of symbolizer is not yet supported");
        }
        return style;
    }

    PolygonStyle2D createPolygonStyle(Object feature, PolygonSymbolizer symbolizer, Range scaleRange) {
        PolygonStyle2D style = new PolygonStyle2D();
        this.setScaleRange(style, scaleRange);
        style.setStroke(this.getStroke(symbolizer.getStroke(), feature));
        style.setGraphicStroke(this.getGraphicStroke(symbolizer.getStroke(), feature));
        style.setContour(this.getStrokePaint(symbolizer.getStroke(), feature));
        style.setContourComposite(this.getStrokeComposite(symbolizer.getStroke(), feature));
        this.setPolygonStyleFill(feature, style, symbolizer, scaleRange);
        return style;
    }

    void setPolygonStyleFill(Object feature, PolygonStyle2D style, PolygonSymbolizer symbolizer, Range scaleRange) {
        Fill fill = symbolizer.getFill();
        if (fill == null) {
            return;
        }
        if (fill.getGraphicFill() != null && this.isVectorRenderingEnabled()) {
            Style2D style2DFill = this.createPointStyle(feature, fill.getGraphicFill(), scaleRange);
            style.setGraphicFill(style2DFill);
        } else {
            style.setFill(this.getPaint(symbolizer.getFill(), feature));
            style.setFillComposite(this.getComposite(symbolizer.getFill(), feature));
        }
    }

    Style2D createDynamicPolygonStyle(SimpleFeature feature, PolygonSymbolizer symbolizer, Range scaleRange) {
        DynamicPolygonStyle2D style = new DynamicPolygonStyle2D(feature, symbolizer);
        this.setScaleRange(style, scaleRange);
        return style;
    }

    Style2D createLineStyle(Object feature, LineSymbolizer symbolizer, Range scaleRange) {
        LineStyle2D style = new LineStyle2D();
        this.setScaleRange(style, scaleRange);
        style.setStroke(this.getStroke(symbolizer.getStroke(), feature));
        style.setGraphicStroke(this.getGraphicStroke(symbolizer.getStroke(), feature));
        style.setContour(this.getStrokePaint(symbolizer.getStroke(), feature));
        style.setContourComposite(this.getStrokeComposite(symbolizer.getStroke(), feature));
        return style;
    }

    Style2D createDynamicLineStyle(SimpleFeature feature, LineSymbolizer symbolizer, Range scaleRange) {
        DynamicLineStyle2D style = new DynamicLineStyle2D(feature, symbolizer);
        this.setScaleRange(style, scaleRange);
        return style;
    }

    Style2D createPointStyle(Object feature, PointSymbolizer symbolizer, Range scaleRange) {
        return this.createPointStyle(feature, symbolizer.getGraphic(), scaleRange);
    }

    Style2D createPointStyle(Object feature, Graphic sldGraphic, Range scaleRange) {
        Style2D retval = null;
        float opacity = this.evalOpacity(sldGraphic.getOpacity(), feature);
        double size = 0.0;
        try {
            if (sldGraphic.getSize() != null && !Expression.NIL.equals(sldGraphic.getSize())) {
                size = this.evalToDouble(sldGraphic.getSize(), feature, 0.0);
            }
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        float rotation = (float)((double)this.evalToFloat(sldGraphic.getRotation(), feature, 0.0f) * Math.PI / 180.0);
        ArrayList<Mark> symbols = sldGraphic.graphicalSymbols();
        if (symbols.isEmpty()) {
            symbols = new ArrayList<Mark>();
            Mark square = StyleFactoryFinder.createStyleFactory().createMark();
            symbols.add(square);
        }
        int length = symbols.size();
        BufferedImage img = null;
        for (GraphicalSymbol graphicalSymbol : symbols) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("trying to render symbol " + graphicalSymbol);
            }
            if (graphicalSymbol instanceof ExternalGraphic) {
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer("rendering External graphic");
                }
                if (this.vectorRenderingEnabled) {
                    Iterator it = glyphRenderers.iterator();
                    while (it.hasNext() && img == null) {
                        GlyphRenderer r = (GlyphRenderer)it.next();
                        if (!r.canRender(((ExternalGraphic)graphicalSymbol).getFormat())) continue;
                        retval = new GlyphStyle2D(r, sldGraphic, (ExternalGraphic)graphicalSymbol, feature, (int)size);
                        break;
                    }
                } else {
                    ExternalGraphic eg = (ExternalGraphic)graphicalSymbol;
                    img = this.externalGraphicToImage(feature, sldGraphic, (int)size, eg);
                    if (img == null) continue;
                    retval = new GraphicStyle2D(img, rotation, opacity);
                    break;
                }
            }
            if (graphicalSymbol instanceof Mark) {
                Mark mark;
                Shape shape;
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer("rendering mark @ PointRenderer " + graphicalSymbol.toString());
                }
                if ((shape = this.getShape(mark = (Mark)graphicalSymbol, feature)) == null) {
                    throw new IllegalArgumentException("The specified mark " + mark.getWellKnownName() + " was not found!");
                }
                MarkStyle2D ms2d = new MarkStyle2D();
                ms2d.setShape(shape);
                ms2d.setFill(this.getPaint(mark.getFill(), feature));
                ms2d.setFillComposite(this.getComposite(mark.getFill(), feature));
                ms2d.setStroke(this.getStroke(mark.getStroke(), feature));
                ms2d.setContour(this.getStrokePaint(mark.getStroke(), feature));
                ms2d.setContourComposite(this.getStrokeComposite(mark.getStroke(), feature));
                if (size <= 0.0) {
                    size = 16.0;
                }
                ms2d.setSize((int)size);
                ms2d.setRotation(rotation);
                retval = ms2d;
                break;
            }
            if (!(graphicalSymbol instanceof TextMark)) continue;
        }
        if (retval != null) {
            this.setScaleRange(retval, scaleRange);
        }
        return retval;
    }

    private BufferedImage externalGraphicToImage(Object feature, Graphic sldGraphic, int size, ExternalGraphic eg) {
        BufferedImage img = null;
        Iterator it = glyphRenderers.iterator();
        while (it.hasNext() && img == null) {
            GlyphRenderer r = (GlyphRenderer)it.next();
            if (!r.canRender(eg.getFormat())) continue;
            img = r.render(sldGraphic, eg, feature, size);
            break;
        }
        if (img == null) {
            img = this.getImage(eg, (Object)((Feature)feature), size);
        }
        return img;
    }

    Style2D createTextStyle(Object feature, TextSymbolizer symbolizer, Range scaleRange) {
        PointPlacement p;
        TextStyle2D ts2d = new TextStyle2D();
        this.setScaleRange(ts2d, scaleRange);
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("creating text style");
        }
        String geomName = symbolizer.getGeometryPropertyName();
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("geomName = " + geomName);
        }
        String label = this.evalToString(symbolizer.getLabel(), feature, "");
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("label is " + label);
        }
        ts2d.setLabel(label);
        org.geotools.styling.Font[] fonts = symbolizer.getFonts();
        Font javaFont = this.getFont(feature, fonts);
        ts2d.setFont(javaFont);
        LabelPlacement placement = symbolizer.getLabelPlacement();
        double anchorX = 0.0;
        double anchorY = 0.0;
        double rotation = 0.0;
        double dispX = 0.0;
        double dispY = 0.0;
        if (placement instanceof PointPlacement) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("setting pointPlacement");
            }
            if ((p = (PointPlacement)placement).getAnchorPoint() != null) {
                anchorX = this.evalToDouble(p.getAnchorPoint().getAnchorPointX(), feature, 0.0);
                anchorY = this.evalToDouble(p.getAnchorPoint().getAnchorPointY(), feature, 0.5);
            }
            if (p.getDisplacement() != null) {
                dispX = this.evalToDouble(p.getDisplacement().getDisplacementX(), feature, 0.0);
                dispY = this.evalToDouble(p.getDisplacement().getDisplacementY(), feature, 0.0);
            }
            if (symbolizer instanceof TextSymbolizer2 && ((TextSymbolizer2)symbolizer).getGraphic() != null) {
                rotation = 0.0;
            } else {
                rotation = this.evalToDouble(p.getRotation(), feature, 0.0);
                rotation *= Math.PI / 180;
            }
            ts2d.setPointPlacement(true);
        } else if (placement instanceof LinePlacement) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("setting pointPlacement");
            }
            ts2d.setPointPlacement(false);
            p = (LinePlacement)placement;
            int displace = this.evalToInt(p.getPerpendicularOffset(), feature, 0);
            ts2d.setPerpendicularOffset(displace);
        }
        ts2d.setAnchorX(anchorX);
        ts2d.setAnchorY(anchorY);
        ts2d.setRotation((float)rotation);
        ts2d.setDisplacementX(dispX);
        ts2d.setDisplacementY(dispY);
        ts2d.setFill(this.getPaint(symbolizer.getFill(), feature));
        ts2d.setComposite(this.getComposite(symbolizer.getFill(), feature));
        Halo halo = symbolizer.getHalo();
        if (halo != null) {
            ts2d.setHaloFill(this.getPaint(halo.getFill(), feature));
            ts2d.setHaloComposite(this.getComposite(halo.getFill(), feature));
            ts2d.setHaloRadius(this.evalToFloat(halo.getRadius(), feature, 1.0f));
        }
        Graphic graphicShield = null;
        if (symbolizer instanceof TextSymbolizer2 && (graphicShield = ((TextSymbolizer2)symbolizer).getGraphic()) != null) {
            PointSymbolizer p2 = StyleFactoryFinder.createStyleFactory().createPointSymbolizer();
            p2.setGraphic((org.opengis.style.Graphic)graphicShield);
            Style2D shieldStyle = this.createPointStyle(feature, p2, scaleRange);
            ts2d.setGraphic(shieldStyle);
        }
        return ts2d;
    }

    private Geometry findGeometry(Object feature, String geomName) {
        Object geom = null;
        if (geomName == null) {
            geomName = "";
        }
        PropertyName property = ff.property(geomName);
        return (Geometry)property.evaluate(feature, Geometry.class);
    }

    private Font getFont(Object feature, org.geotools.styling.Font[] fonts) {
        if (fonts != null) {
            for (int k = 0; k < fonts.length; ++k) {
                String requestedFont = this.evalToString(fonts[k].getFontFamily(), feature, null);
                Font javaFont = FontCache.getDefaultInsance().getFont(requestedFont);
                if (javaFont == null) continue;
                String reqStyle = this.evalToString(fonts[k].getFontStyle(), feature, null);
                int styleCode = fontStyleLookup.containsKey(reqStyle) ? (Integer)fontStyleLookup.get(reqStyle) : 0;
                String reqWeight = this.evalToString(fonts[k].getFontWeight(), feature, null);
                if ("Bold".equalsIgnoreCase(reqWeight)) {
                    styleCode |= 1;
                }
                int size = this.evalToInt(fonts[k].getFontSize(), feature, 10);
                return javaFont.deriveFont(styleCode, size);
            }
        }
        return new Font("Serif", 0, 12);
    }

    void setScaleRange(Style style, Range scaleRange) {
        double min = ((Number)((Object)scaleRange.getMinValue())).doubleValue();
        double max = ((Number)((Object)scaleRange.getMaxValue())).doubleValue();
        style.setMinMaxScale(min, max);
    }

    private BufferedImage getGraphicStroke(Stroke stroke, Object feature) {
        int size;
        if (stroke == null || stroke.getGraphicStroke() == null) {
            return null;
        }
        Graphic graphicStroke = stroke.getGraphicStroke();
        BufferedImage image = this.getImage(graphicStroke, (Object)((Feature)feature), size = this.evalToInt(graphicStroke.getSize(), feature, 1));
        if (image == null) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("going for the mark from graphic fill");
            }
            Mark mark = this.getMark(graphicStroke, feature);
            image = new BufferedImage(size, size, 2);
            Graphics2D ig2d = image.createGraphics();
            ig2d.setRenderingHints(this.renderingHints);
            double rotation = 0.0;
            rotation = this.evalToDouble(graphicStroke.getRotation(), feature, 0.0);
            this.fillDrawMark(ig2d, size / 2, size / 2, mark, size, rotation *= Math.PI / 180, feature);
            MediaTracker track = new MediaTracker(obs);
            track.addImage(image, 1);
            try {
                track.waitForID(1);
            }
            catch (InterruptedException e) {
                LOGGER.warning(e.toString());
            }
        }
        return image;
    }

    private java.awt.Stroke getStroke(Stroke stroke, Object feature) {
        if (stroke == null) {
            return null;
        }
        String joinType = this.evalToString(stroke.getLineJoin(), feature, "miter");
        int joinCode = joinLookup.containsKey(joinType) ? (Integer)joinLookup.get(joinType) : 0;
        String capType = this.evalToString(stroke.getLineCap(), feature, "square");
        int capCode = capLookup.containsKey(capType) ? (Integer)capLookup.get(capType) : 2;
        float[] dashes = stroke.getDashArray();
        float width = this.evalToFloat(stroke.getWidth(), feature, 1.0f);
        float dashOffset = this.evalToFloat(stroke.getDashOffset(), feature, 0.0f);
        if ((double)width < 1.5 & this.lineOptimizationEnabled) {
            width = 0.0f;
        }
        BasicStroke stroke2d = dashes != null && dashes.length > 0 ? new BasicStroke(width, capCode, joinCode, 1.0f, dashes, dashOffset) : new BasicStroke(width, capCode, joinCode, 1.0f);
        return stroke2d;
    }

    private Paint getStrokePaint(Stroke stroke, Object feature) {
        if (stroke == null) {
            return null;
        }
        Paint contourPaint = this.evalToColor(stroke.getColor(), feature, Color.BLACK);
        Graphic gr = stroke.getGraphicFill();
        if (gr != null) {
            contourPaint = this.getTexturePaint(gr, feature);
        }
        return contourPaint;
    }

    private Composite getStrokeComposite(Stroke stroke, Object feature) {
        if (stroke == null) {
            return null;
        }
        float opacity = this.evalOpacity(stroke.getOpacity(), feature);
        AlphaComposite composite = AlphaComposite.getInstance(3, opacity);
        return composite;
    }

    protected Paint getPaint(Fill fill, Object feature) {
        if (fill == null) {
            return null;
        }
        Paint fillPaint = this.evalToColor(fill.getColor(), feature, null);
        Graphic gr = fill.getGraphicFill();
        if (gr != null) {
            fillPaint = this.getTexturePaint(gr, feature);
        }
        return fillPaint;
    }

    protected Composite getComposite(Fill fill, Object feature) {
        if (fill == null) {
            return null;
        }
        float opacity = this.evalOpacity(fill.getOpacity(), feature);
        AlphaComposite composite = AlphaComposite.getInstance(3, opacity);
        return composite;
    }

    public TexturePaint getTexturePaint(Graphic gr, Object feature) {
        int iSizeY;
        int iSizeX;
        int graphicSize = this.evalToInt(gr.getSize(), feature, -1);
        BufferedImage image = this.getImage(gr, feature, graphicSize);
        if (image != null) {
            iSizeY = iSizeX = image.getWidth();
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("got an image in graphic fill");
            }
        } else {
            Mark mark;
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("going for the mark from graphic fill");
            }
            if ((mark = this.getMark(gr, feature)) == null) {
                return null;
            }
            Shape shape = this.getShape(mark, feature);
            if (shape == null) {
                return null;
            }
            Rectangle2D shapeBounds = shape.getBounds2D();
            double shapeAspectRatio = shapeBounds.getHeight() > 0.0 && shapeBounds.getWidth() > 0.0 ? shapeBounds.getWidth() / shapeBounds.getHeight() : 1.0;
            int size = this.evalToInt(gr.getSize(), feature, 16);
            double sizeX = (double)size * shapeAspectRatio;
            double sizeY = size;
            image = new BufferedImage((int)Math.ceil(sizeX * 3.0), (int)Math.ceil(sizeY * 3.0), 2);
            Graphics2D g2d = image.createGraphics();
            g2d.setRenderingHints(this.renderingHints);
            double rotation = this.evalToDouble(gr.getRotation(), feature, 0.0);
            for (int i = -1; i < 2; ++i) {
                for (int j = -1; j < 2; ++j) {
                    double tx = sizeX * 1.5 + sizeX * (double)i;
                    double ty = sizeY * 1.5 + sizeY * (double)j;
                    this.fillDrawMark(g2d, tx, ty, mark, size, rotation, feature);
                }
            }
            g2d.dispose();
            iSizeX = (int)Math.floor(sizeX);
            iSizeY = (int)Math.floor(sizeY);
            image = image.getSubimage(iSizeX, iSizeY, iSizeX + 1, iSizeY + 1);
        }
        Rectangle2D.Double rect = new Rectangle2D.Double(0.0, 0.0, iSizeX, iSizeY);
        TexturePaint imagePaint = new TexturePaint(image, rect);
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("applied TexturePaint " + imagePaint);
        }
        return imagePaint;
    }

    private BufferedImage getImage(Graphic graphic, Object feature, int size) {
        if (graphic == null) {
            return null;
        }
        ExternalGraphic[] extgraphics = graphic.getExternalGraphics();
        if (extgraphics != null) {
            for (int i = 0; i < extgraphics.length; ++i) {
                BufferedImage image = this.externalGraphicToImage(feature, graphic, size, extgraphics[i]);
                if (image == null) continue;
                return image;
            }
        }
        return null;
    }

    private BufferedImage getImage(ExternalGraphic eg, Object feature, int size) {
        Expression location;
        String strLocation;
        if (eg == null) {
            return null;
        }
        try {
            strLocation = eg.getLocation().toExternalForm();
        }
        catch (MalformedURLException e) {
            LOGGER.log(Level.INFO, "Malformed URL processing external graphic", e);
            return null;
        }
        try {
            location = ExpressionExtractor.extractCqlExpressions(strLocation);
        }
        catch (IllegalArgumentException e) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Could not parse cql expressions out of " + strLocation, e);
            }
            location = ff.literal((Object)strLocation);
        }
        Iterator<ExternalGraphicFactory> it = DynamicSymbolFactoryFinder.getExternalGraphicFactories();
        while (it.hasNext()) {
            try {
                Icon icon = it.next().getIcon((Feature)feature, location, eg.getFormat(), size);
                if (icon == null) continue;
                return this.rasterizeIcon(icon);
            }
            catch (Exception e) {
                LOGGER.log(Level.FINE, "Error occurred evaluating external graphic", e);
            }
        }
        return null;
    }

    private BufferedImage rasterizeIcon(Icon icon) {
        ImageIcon img;
        if (icon instanceof ImageIcon && (img = (ImageIcon)icon).getImage() instanceof BufferedImage) {
            return (BufferedImage)img.getImage();
        }
        BufferedImage result = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 6);
        Graphics g = result.getGraphics();
        icon.paintIcon(null, g, 0, 0);
        g.dispose();
        return result;
    }

    private Mark getMark(Graphic graphic, Object feature) {
        if (graphic == null) {
            return null;
        }
        Mark[] marks = graphic.getMarks();
        for (int i = 0; i < marks.length; ++i) {
            Mark mark = marks[i];
            Shape shape = this.getShape(mark, feature);
            if (shape == null) continue;
            return mark;
        }
        return null;
    }

    private Shape getShape(Mark mark, Object feature) {
        String expression;
        if (mark == null) {
            return null;
        }
        Expression name = mark.getWellKnownName();
        if (name instanceof Literal && (expression = this.evalToString(name, null, null)) != null) {
            name = ExpressionExtractor.extractCqlExpressions(expression);
        }
        Iterator<MarkFactory> it = DynamicSymbolFactoryFinder.getMarkFactories();
        while (it.hasNext()) {
            MarkFactory factory = it.next();
            try {
                Shape shape = factory.getShape(null, name, (Feature)feature);
                if (shape == null) continue;
                return shape;
            }
            catch (Exception e) {
                LOGGER.log(Level.FINE, "Exception while scanning for the appropriate mark factory", e);
            }
        }
        return null;
    }

    private void fillDrawMark(Graphics2D g2d, double tx, double ty, Mark mark, double size, double rotation, Object feature) {
        if (mark == null) {
            return;
        }
        Shape originalShape = this.getShape(mark, feature);
        AffineTransform markAT = new AffineTransform();
        markAT.translate(tx, ty);
        markAT.rotate(rotation);
        double unitSize = 1.0;
        double drawSize = size / unitSize;
        markAT.scale(drawSize, -drawSize);
        Shape shape = markAT.createTransformedShape(originalShape);
        if (mark.getFill() != null) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("applying fill to mark");
            }
            g2d.setPaint(this.getPaint(mark.getFill(), feature));
            g2d.setComposite(this.getComposite(mark.getFill(), feature));
            g2d.fill(shape);
        }
        if (mark.getStroke() != null) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("applying stroke to mark");
            }
            g2d.setPaint(this.getStrokePaint(mark.getStroke(), feature));
            g2d.setComposite(this.getStrokeComposite(mark.getStroke(), feature));
            g2d.setStroke(this.getStroke(mark.getStroke(), feature));
            g2d.draw(shape);
        }
        if (mark.getFill() != null) {
            g2d.setComposite(AlphaComposite.getInstance(3, 1.0f));
        }
    }

    public static int lookUpJoin(String joinType) {
        if (joinLookup.containsKey(joinType)) {
            return (Integer)joinLookup.get(joinType);
        }
        return 0;
    }

    public static int lookUpCap(String capType) {
        if (capLookup.containsKey(capType)) {
            return (Integer)capLookup.get(capType);
        }
        return 2;
    }

    public double getMapScaleDenominator() {
        return this.mapScaleDenominator;
    }

    public void setMapScaleDenominator(double mapScaleDenominator) {
        this.mapScaleDenominator = mapScaleDenominator;
    }

    private String evalToString(Expression exp, Object f, String fallback) {
        if (exp == null) {
            return fallback;
        }
        Object o = exp.evaluate(f);
        if (o instanceof String) {
            return (String)o;
        }
        String s = (String)exp.evaluate(f, String.class);
        if (s != null) {
            return s;
        }
        return fallback;
    }

    private float evalToFloat(Expression exp, Object f, float fallback) {
        if (exp == null) {
            return fallback;
        }
        Object o = exp.evaluate(f);
        if (o instanceof Number) {
            return ((Number)o).floatValue();
        }
        Float fo = (Float)exp.evaluate(f, Float.class);
        if (fo != null) {
            return fo.floatValue();
        }
        return fallback;
    }

    private double evalToDouble(Expression exp, Object f, double fallback) {
        if (exp == null) {
            return fallback;
        }
        Object o = exp.evaluate(f);
        if (o instanceof Number) {
            return ((Number)o).doubleValue();
        }
        Double d = (Double)exp.evaluate(f, Double.class);
        if (d != null) {
            return d;
        }
        return fallback;
    }

    private int evalToInt(Expression exp, Object f, int fallback) {
        if (exp == null) {
            return fallback;
        }
        Object o = exp.evaluate(f);
        if (o instanceof Number) {
            return ((Number)o).intValue();
        }
        Integer i = (Integer)exp.evaluate(f, Integer.class);
        if (i != null) {
            return i;
        }
        return fallback;
    }

    private Color evalToColor(Expression exp, Object f, Color fallback) {
        if (exp == null) {
            return fallback;
        }
        Color color = (Color)exp.evaluate(f, Color.class);
        if (color != null) {
            return color;
        }
        return fallback;
    }

    private float evalOpacity(Expression e, Object f) {
        return this.evalToFloat(e, f, 1.0f);
    }

    static {
        joinLookup.put("miter", new Integer(0));
        joinLookup.put("bevel", new Integer(2));
        joinLookup.put("round", new Integer(1));
        capLookup.put("butt", new Integer(0));
        capLookup.put("round", new Integer(1));
        capLookup.put("square", new Integer(2));
        fontStyleLookup.put("normal", new Integer(0));
        fontStyleLookup.put("italic", new Integer(2));
        fontStyleLookup.put("oblique", new Integer(2));
        fontStyleLookup.put("bold", new Integer(1));
        glyphRenderers.add(new CustomGlyphRenderer());
        try {
            glyphRenderers.add(new SVGGlyphRenderer());
        }
        catch (Exception e) {
            LOGGER.warning("Will not support SVG External Graphics " + e);
        }
    }

    static class SymbolizerKey {
        private Symbolizer symbolizer;
        private double minScale;
        private double maxScale;

        public SymbolizerKey(Symbolizer symbolizer, Range scaleRange) {
            this.symbolizer = symbolizer;
            this.minScale = ((Number)((Object)scaleRange.getMinValue())).doubleValue();
            this.maxScale = ((Number)((Object)scaleRange.getMaxValue())).doubleValue();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof SymbolizerKey)) {
                return false;
            }
            SymbolizerKey other = (SymbolizerKey)obj;
            return other.symbolizer == this.symbolizer && other.minScale == this.minScale && other.maxScale == this.maxScale;
        }

        public int hashCode() {
            return ((17 + System.identityHashCode(this.symbolizer)) * 37 + this.doubleHash(this.minScale)) * 37 + this.doubleHash(this.maxScale);
        }

        private int doubleHash(double value) {
            long bits = Double.doubleToLongBits(value);
            return (int)(bits ^ bits >>> 32);
        }
    }
}

