/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.style.shape;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class ExplicitBoundsShape
implements Shape {
    private Shape _shape;
    private Rectangle2D _bounds = null;

    public ExplicitBoundsShape(Shape shape) {
        if (shape == null) {
            throw new IllegalArgumentException("Shape can't be null.");
        }
        this._shape = shape;
    }

    public void setBounds(Rectangle2D bounds) {
        this._bounds = bounds;
    }

    public boolean contains(double x, double y, double w, double h) {
        return this._shape.contains(x, y, w, h);
    }

    public boolean contains(double x, double y) {
        return this._shape.contains(x, y);
    }

    public boolean contains(Point2D p) {
        return this._shape.contains(p);
    }

    public boolean contains(Rectangle2D r) {
        return this._shape.contains(r);
    }

    public Rectangle getBounds() {
        if (this._bounds != null) {
            return new Rectangle((int)this._bounds.getMinX(), (int)this._bounds.getMinY(), (int)this._bounds.getWidth(), (int)this._bounds.getHeight());
        }
        return this._shape.getBounds();
    }

    public Rectangle2D getBounds2D() {
        if (this._bounds != null) {
            return this._bounds;
        }
        return this._shape.getBounds2D();
    }

    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return this._shape.getPathIterator(at, flatness);
    }

    public PathIterator getPathIterator(AffineTransform at) {
        return this._shape.getPathIterator(at);
    }

    public boolean intersects(double x, double y, double w, double h) {
        return this._shape.intersects(x, y, w, h);
    }

    public boolean intersects(Rectangle2D r) {
        return this._shape.intersects(r);
    }

    public boolean equals(Object obj) {
        if (obj instanceof ExplicitBoundsShape) {
            ExplicitBoundsShape other = (ExplicitBoundsShape)obj;
            boolean result = this._shape.equals(other._shape);
            if (this._bounds == null) {
                return result & other._bounds == null;
            }
            return result & this._bounds.equals(other._bounds);
        }
        if (obj instanceof Shape) {
            if (this._bounds == null) {
                return this._shape.equals(obj);
            }
            return false;
        }
        return super.equals(obj);
    }

    public int hashCode() {
        int hascode = this._shape.hashCode();
        if (this._bounds != null) {
            hascode += hascode * 37 + this._bounds.hashCode();
        }
        return hascode;
    }
}

