/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.label;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.prep.PreparedGeometry;
import com.vividsolutions.jts.geom.prep.PreparedGeometryFactory;
import com.vividsolutions.jts.operation.linemerge.LineMerger;
import com.vividsolutions.jts.precision.EnhancedPrecisionOp;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.geotools.geometry.jts.Decimator;
import org.geotools.geometry.jts.LiteShape2;
import org.geotools.renderer.label.LabelCacheItem;
import org.geotools.renderer.label.LabelIndex;
import org.geotools.renderer.label.LabelPainter;
import org.geotools.renderer.label.LineStringCursor;
import org.geotools.renderer.lite.LabelCache;
import org.geotools.renderer.style.SLDStyleFactory;
import org.geotools.renderer.style.TextStyle2D;
import org.geotools.styling.Symbolizer;
import org.geotools.styling.TextSymbolizer;
import org.geotools.util.NumberRange;
import org.geotools.util.Range;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.expression.Literal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LabelCacheImpl
implements LabelCache {
    public double DEFAULT_PRIORITY = 1000.0;
    protected Map<String, LabelCacheItem> labelCache = new HashMap<String, LabelCacheItem>();
    protected ArrayList<LabelCacheItem> labelCacheNonGrouped = new ArrayList();
    private List<Rectangle2D> reserved = new ArrayList<Rectangle2D>();
    public boolean DEFAULT_GROUP = false;
    public int DEFAULT_SPACE_AROUND = 0;
    public int DEFAULT_MAX_DISPLACEMENT = 0;
    public int DEFAULT_MAX_DISPLACEMENT_POINT = 0;
    public int DEFAULT_MIN_GROUP_DISTANCE = -1;
    public int DEFAULT_LABEL_REPEAT = 0;
    public boolean DEFAULT_LABEL_ALL_GROUP = false;
    public boolean DEFAULT_ALLOW_OVERRUNS = true;
    public boolean DEFAULT_REMOVE_OVERLAPS = false;
    public boolean DEFAULT_FOLLOW_LINE = false;
    public double DEFAULT_MAX_ANGLE_DELTA = 22.5;
    static final double MIN_CURVED_DELTA = 0.05235987755982988;
    static final int DEFAULT_AUTO_WRAP = 0;
    static final boolean DEFAULT_FORCE_LEFT_TO_RIGHT = true;
    static final boolean DEFAULT_CONFLICT_RESOLUTION = true;
    static final double DEFAULT_GOODNESS_OF_FIT = 0.5;
    static final double[] RIGHT_ANCHOR_CANDIDATES = new double[]{0.0, 0.5, 0.0, 0.0, 0.0, 1.0};
    static final double[] MID_ANCHOR_CANDIDATES = new double[]{0.5, 0.5, 0.0, 0.5, 1.0, 0.5};
    static final double[] LEFT_ANCHOR_CANDIDATES = new double[]{1.0, 0.5, 1.0, 0.0, 1.0, 1.0};
    protected boolean outlineRenderingEnabled = false;
    protected SLDStyleFactory styleFactory = new SLDStyleFactory();
    boolean stop = false;
    Set<String> enabledLayers = new HashSet<String>();
    Set<String> activeLayers = new HashSet<String>();
    LineLengthComparator lineLengthComparator = new LineLengthComparator();
    GeometryFactory gf = new GeometryFactory();
    private boolean needsOrdering = false;

    @Override
    public void enableLayer(String layerId) {
        this.needsOrdering = true;
        this.enabledLayers.add(layerId);
    }

    public boolean isOutlineRenderingEnabled() {
        return this.outlineRenderingEnabled;
    }

    public void setOutlineRenderingEnabled(boolean outlineRenderingEnabled) {
        this.outlineRenderingEnabled = outlineRenderingEnabled;
    }

    @Override
    public void stop() {
        this.stop = true;
        this.activeLayers.clear();
    }

    @Override
    public void start() {
        this.stop = false;
    }

    @Override
    public void clear() {
        if (!this.activeLayers.isEmpty()) {
            throw new IllegalStateException(this.activeLayers + " are layers that started rendering but have not completed," + " stop() or endLayer() must be called before clear is called");
        }
        this.needsOrdering = true;
        this.labelCache.clear();
        this.labelCacheNonGrouped.clear();
        this.enabledLayers.clear();
    }

    @Override
    public void clear(String layerId) {
        LabelCacheItem item;
        if (this.activeLayers.contains(layerId)) {
            throw new IllegalStateException(layerId + " is still rendering, end the layer before calling clear.");
        }
        this.needsOrdering = true;
        Iterator<LabelCacheItem> iter = this.labelCache.values().iterator();
        while (iter.hasNext()) {
            item = iter.next();
            if (!item.getLayerIds().contains(layerId)) continue;
            iter.remove();
        }
        iter = this.labelCacheNonGrouped.iterator();
        while (iter.hasNext()) {
            item = iter.next();
            if (!item.getLayerIds().contains(layerId)) continue;
            iter.remove();
        }
        this.enabledLayers.remove(layerId);
    }

    @Override
    public void disableLayer(String layerId) {
        this.needsOrdering = true;
        this.enabledLayers.remove(layerId);
    }

    @Override
    public void startLayer(String layerId) {
        this.enabledLayers.add(layerId);
        this.activeLayers.add(layerId);
    }

    public double getPriority(TextSymbolizer symbolizer, SimpleFeature feature) {
        if (symbolizer.getPriority() == null) {
            return this.DEFAULT_PRIORITY;
        }
        try {
            Double number = (Double)symbolizer.getPriority().evaluate((Object)feature, Double.class);
            return number;
        }
        catch (Exception e) {
            return this.DEFAULT_PRIORITY;
        }
    }

    public void put(String layerId, TextSymbolizer symbolizer, SimpleFeature feature, LiteShape2 shape, NumberRange scaleRange) {
        this.needsOrdering = true;
        try {
            String label = (String)symbolizer.getLabel().evaluate((Object)feature, String.class);
            if (label == null) {
                return;
            }
            if ((label = label.trim()).length() == 0) {
                return;
            }
            double priorityValue = this.getPriority(symbolizer, feature);
            boolean group = this.getBooleanOption(symbolizer, "group", false);
            if (!group) {
                LabelCacheItem item = this.buildLabelCacheItem(layerId, symbolizer, feature, shape, scaleRange, label, priorityValue);
                this.labelCacheNonGrouped.add(item);
            } else {
                LabelCacheItem lci = this.labelCache.get(label);
                if (lci == null) {
                    lci = this.buildLabelCacheItem(layerId, symbolizer, feature, shape, scaleRange, label, priorityValue);
                    this.labelCache.put(label, lci);
                } else {
                    if (symbolizer.getPriority() != null && !(symbolizer.getPriority() instanceof Literal)) {
                        lci.setPriority(lci.getPriority() + priorityValue);
                    }
                    lci.getGeoms().add(shape.getGeometry());
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    @Override
    public void put(Rectangle2D area) {
        this.reserved.add(area);
    }

    private LabelCacheItem buildLabelCacheItem(String layerId, TextSymbolizer symbolizer, SimpleFeature feature, LiteShape2 shape, NumberRange scaleRange, String label, double priorityValue) {
        TextStyle2D textStyle = (TextStyle2D)this.styleFactory.createStyle(feature, (Symbolizer)symbolizer, (Range)scaleRange);
        LabelCacheItem item = new LabelCacheItem(layerId, textStyle, shape, label);
        item.setPriority(priorityValue);
        item.setSpaceAround(this.getIntOption(symbolizer, "spaceAround", this.DEFAULT_SPACE_AROUND));
        item.setMaxDisplacement(this.getIntOption(symbolizer, "maxDisplacement", this.DEFAULT_MAX_DISPLACEMENT));
        item.setMinGroupDistance(this.getIntOption(symbolizer, "minGroupDistance", this.DEFAULT_MIN_GROUP_DISTANCE));
        item.setRepeat(this.getIntOption(symbolizer, "repeat", this.DEFAULT_LABEL_REPEAT));
        item.setLabelAllGroup(this.getBooleanOption(symbolizer, "labelAllGroup", this.DEFAULT_LABEL_ALL_GROUP));
        item.setRemoveGroupOverlaps(this.getBooleanOption(symbolizer, "removeOverlaps", this.DEFAULT_REMOVE_OVERLAPS));
        item.setAllowOverruns(this.getBooleanOption(symbolizer, "allowOverruns", this.DEFAULT_ALLOW_OVERRUNS));
        item.setFollowLineEnabled(this.getBooleanOption(symbolizer, "followLine", this.DEFAULT_FOLLOW_LINE));
        double maxAngleDelta = this.getDoubleOption(symbolizer, "maxAngleDelta", this.DEFAULT_MAX_ANGLE_DELTA);
        item.setMaxAngleDelta(Math.toRadians(maxAngleDelta));
        item.setAutoWrap(this.getIntOption(symbolizer, "autoWrap", 0));
        item.setForceLeftToRightEnabled(this.getBooleanOption(symbolizer, "forceLeftToRight", true));
        item.setConflictResolutionEnabled(this.getBooleanOption(symbolizer, "conflictResolution", true));
        item.setGoodnessOfFit(this.getDoubleOption(symbolizer, "goodnessOfFit", 0.5));
        return item;
    }

    private int getIntOption(TextSymbolizer symbolizer, String optionName, int defaultValue) {
        String value = symbolizer.getOption(optionName);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    private double getDoubleOption(TextSymbolizer symbolizer, String optionName, double defaultValue) {
        String value = symbolizer.getOption(optionName);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(value);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    private boolean getBooleanOption(TextSymbolizer symbolizer, String optionName, boolean defaultValue) {
        String value = symbolizer.getOption(optionName);
        if (value == null) {
            return defaultValue;
        }
        return value.equalsIgnoreCase("yes") || value.equalsIgnoreCase("true") || value.equalsIgnoreCase("1");
    }

    @Override
    public void endLayer(String layerId, Graphics2D graphics, Rectangle displayArea) {
        this.activeLayers.remove(layerId);
    }

    @Override
    public List<LabelCacheItem> orderedLabels() {
        List<LabelCacheItem> al = this.getActiveLabels();
        Collections.sort(al);
        Collections.reverse(al);
        return al;
    }

    private List<LabelCacheItem> getActiveLabels() {
        ArrayList<LabelCacheItem> al = new ArrayList<LabelCacheItem>();
        for (LabelCacheItem item : this.labelCache.values()) {
            if (!this.isActive(item.getLayerIds())) continue;
            al.add(item);
        }
        for (LabelCacheItem item : this.labelCacheNonGrouped) {
            if (!this.isActive(item.getLayerIds())) continue;
            al.add(item);
        }
        return al;
    }

    private boolean isActive(Set<String> layerIds) {
        for (String layerName : layerIds) {
            if (!this.enabledLayers.contains(layerName)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void end(Graphics2D graphics, Rectangle displayArea) {
        Object antialiasing = graphics.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        Object textAntialiasing = graphics.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
        try {
            if (this.outlineRenderingEnabled && antialiasing == RenderingHints.VALUE_ANTIALIAS_OFF && textAntialiasing == RenderingHints.VALUE_TEXT_ANTIALIAS_ON) {
                graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            this.paintLabels(graphics, displayArea);
        }
        finally {
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, antialiasing);
        }
    }

    void paintLabels(Graphics2D graphics, Rectangle displayArea) {
        if (!this.activeLayers.isEmpty()) {
            throw new IllegalStateException(this.activeLayers + " are layers that started rendering but have not completed," + " stop() or endLayer() must be called before end() is called");
        }
        LabelIndex glyphs = new LabelIndex();
        glyphs.reserveArea(this.reserved);
        displayArea = new Rectangle(displayArea);
        --displayArea.width;
        --displayArea.height;
        List<LabelCacheItem> items = this.needsOrdering ? this.orderedLabels() : this.getActiveLabels();
        LabelPainter painter = new LabelPainter(graphics, this.outlineRenderingEnabled);
        for (LabelCacheItem labelItem : items) {
            if (this.stop) {
                return;
            }
            painter.setLabel(labelItem);
            try {
                AffineTransform tempTransform = new AffineTransform();
                Geometry geom = labelItem.getGeometry();
                if (geom instanceof Point || geom instanceof MultiPoint) {
                    this.paintPointLabel(painter, tempTransform, displayArea, glyphs);
                    continue;
                }
                if (geom instanceof LineString && !(geom instanceof LinearRing) || geom instanceof MultiLineString) {
                    this.paintLineLabels(painter, tempTransform, displayArea, glyphs);
                    continue;
                }
                if (!(geom instanceof Polygon) && !(geom instanceof MultiPolygon) && !(geom instanceof LinearRing)) continue;
                this.paintPolygonLabel(painter, tempTransform, displayArea, glyphs);
            }
            catch (Exception e) {
                System.out.println("Issues painting " + labelItem.getLabel());
                e.printStackTrace();
            }
        }
    }

    private Envelope toEnvelope(Rectangle2D bounds) {
        return new Envelope(bounds.getMinX(), bounds.getMaxX(), bounds.getMinY(), bounds.getMaxY());
    }

    private double goodnessOfFit(LabelPainter painter, Rectangle2D glyphBounds, PreparedGeometry representativeGeom) {
        if (representativeGeom.getGeometry() instanceof Point) {
            return 1.0;
        }
        if (representativeGeom.getGeometry() instanceof LineString) {
            return 1.0;
        }
        if (representativeGeom.getGeometry() instanceof Polygon) {
            try {
                int count = 0;
                int n = 10;
                Coordinate c = new Coordinate();
                Point pp = this.gf.createPoint(c);
                for (int i = 1; i < painter.getLineCount() + 1; ++i) {
                    double y = glyphBounds.getY() + glyphBounds.getHeight() * ((double)i / (double)(painter.getLineCount() + 1));
                    for (int j = 1; j < n + 1; ++j) {
                        c.x = glyphBounds.getX() + glyphBounds.getWidth() * ((double)j / (double)(n + 1));
                        c.y = y;
                        pp.geometryChanged();
                        if (!representativeGeom.contains((Geometry)pp)) continue;
                        ++count;
                    }
                }
                return (double)count / (double)(n * painter.getLineCount());
            }
            catch (Exception e) {
                Geometry g = representativeGeom.getGeometry();
                g.geometryChanged();
                Envelope ePoly = g.getEnvelopeInternal();
                Envelope eglyph = this.toEnvelope(glyphBounds);
                Envelope inter = this.intersection(ePoly, eglyph);
                if (inter != null) {
                    return inter.getWidth() * inter.getHeight() / (eglyph.getWidth() * eglyph.getHeight());
                }
                return 0.0;
            }
        }
        return 0.0;
    }

    private boolean paintLineLabels(LabelPainter painter, AffineTransform originalTransform, Rectangle displayArea, LabelIndex paintedBounds) throws Exception {
        LabelCacheItem labelItem = painter.getLabel();
        List<LineString> lines = this.getLineSetRepresentativeLocation(labelItem.getGeoms(), displayArea, labelItem.removeGroupOverlaps());
        if (lines == null || lines.size() == 0) {
            return false;
        }
        if (!labelItem.labelAllGroup() && lines.size() > 1) {
            lines = Collections.singletonList(lines.get(0));
        }
        Rectangle2D textBounds = painter.getFullLabelBounds();
        double step = painter.getAscent() > 2.0 ? painter.getAscent() : 2.0;
        int space = labelItem.getSpaceAround();
        int haloRadius = Math.round(labelItem.getTextStyle().getHaloFill() != null ? labelItem.getTextStyle().getHaloRadius() : 0.0f);
        int extraSpace = space + haloRadius;
        int labelDistance = labelItem.getRepeat();
        int minDistance = labelItem.getMinGroupDistance();
        LabelIndex groupLabels = new LabelIndex();
        double labelOffset = labelItem.getMaxDisplacement();
        boolean allowOverruns = labelItem.allowOverruns();
        double maxAngleDelta = labelItem.getMaxAngleDelta();
        int labelCount = 0;
        for (LineString line : lines) {
            int i;
            double[] labelPositions;
            if (labelItem.isFollowLineEnabled()) {
                line = this.decimateLineString(line, step);
            }
            double lineStringLength = line.getLength();
            if ((!allowOverruns || labelItem.isFollowLineEnabled()) && line.getLength() < textBounds.getWidth()) {
                return labelCount > 0;
            }
            if (labelDistance > 0 && (double)labelDistance < lineStringLength / 2.0) {
                labelPositions = new double[(int)(lineStringLength / (double)labelDistance)];
                labelPositions[0] = lineStringLength / 2.0;
                double offset = labelDistance;
                for (i = 1; i < labelPositions.length; ++i) {
                    labelPositions[i] = labelPositions[i - 1] + offset;
                    double signum = Math.signum(offset);
                    offset = -1.0 * signum * (Math.abs(offset) + (double)labelDistance);
                }
            } else {
                labelPositions = new double[]{lineStringLength / 2.0};
            }
            LineStringCursor cursor = new LineStringCursor(line);
            AffineTransform tx = new AffineTransform();
            for (i = 0; i < labelPositions.length; ++i) {
                cursor.moveTo(labelPositions[i]);
                Coordinate centroid = cursor.getCurrentPosition();
                double currOffset = 0.0;
                boolean painted = false;
                while (Math.abs(currOffset) <= labelOffset * 2.0 && !painted) {
                    Rectangle2D labelEnvelope;
                    tx.setToIdentity();
                    double maxAngleChange = 0.0;
                    double startOrdinate = cursor.getCurrentOrdinate() - textBounds.getWidth() / 2.0;
                    double endOrdinate = cursor.getCurrentOrdinate() + textBounds.getWidth() / 2.0;
                    if (labelItem.followLineEnabled) {
                        maxAngleChange = cursor.getMaxAngleChange(startOrdinate, endOrdinate);
                        if (maxAngleChange < 0.05235987755982988) {
                            this.setupLineTransform(painter, cursor, centroid, tx, true);
                            labelEnvelope = tx.createTransformedShape(textBounds).getBounds2D();
                        } else {
                            labelEnvelope = this.getCurvedLabelBounds(cursor, startOrdinate, endOrdinate, textBounds.getHeight() / 2.0);
                        }
                    } else {
                        this.setupLineTransform(painter, cursor, centroid, tx, false);
                        labelEnvelope = tx.createTransformedShape(textBounds).getBounds2D();
                    }
                    if (!(!displayArea.contains(labelEnvelope) || labelItem.isConflictResolutionEnabled() && paintedBounds.labelsWithinDistance(labelEnvelope, extraSpace) || groupLabels.labelsWithinDistance(labelEnvelope, minDistance))) {
                        if (labelItem.isFollowLineEnabled()) {
                            if (startOrdinate > 0.0 && endOrdinate <= cursor.getLineStringLength() && maxAngleChange < maxAngleDelta) {
                                if (maxAngleChange < 0.05235987755982988) {
                                    painter.paintStraightLabel(tx);
                                } else {
                                    painter.paintCurvedLabel(cursor);
                                }
                                painted = true;
                            }
                        } else if (allowOverruns || startOrdinate > 0.0 && endOrdinate <= cursor.getLineStringLength()) {
                            painter.paintStraightLabel(tx);
                            painted = true;
                        }
                    }
                    if (painted) {
                        ++labelCount;
                        groupLabels.addLabel(labelItem, labelEnvelope);
                        if (!labelItem.isConflictResolutionEnabled()) continue;
                        paintedBounds.addLabel(labelItem, labelEnvelope);
                        continue;
                    }
                    double signum = Math.signum(currOffset);
                    currOffset = signum == 0.0 ? step : -1.0 * signum * (Math.abs(currOffset) + step);
                    cursor.moveRelative(currOffset);
                    cursor.getCurrentPosition(centroid);
                }
            }
        }
        return labelCount > 0;
    }

    private Rectangle2D getCurvedLabelBounds(LineStringCursor cursor, double startOrdinate, double endOrdinate, double bufferSize) {
        LineString cut = cursor.getSubLineString(startOrdinate, endOrdinate);
        Envelope e = cut.getEnvelopeInternal();
        e.expandBy(bufferSize);
        return new Rectangle2D.Double(e.getMinX(), e.getMinY(), e.getWidth(), e.getHeight());
    }

    private LineString decimateLineString(LineString line, double step) {
        Coordinate[] inputCoordinates = line.getCoordinates();
        ArrayList<Coordinate> simplified = new ArrayList<Coordinate>();
        Coordinate prev = inputCoordinates[0];
        simplified.add(prev);
        for (int i = 1; i < inputCoordinates.length; ++i) {
            Coordinate curr = inputCoordinates[i];
            if (!(Math.abs(curr.x - prev.x) > step) && !(Math.abs(curr.y - prev.y) > step)) continue;
            simplified.add(curr);
            prev = curr;
        }
        if (simplified.size() == 1) {
            simplified.add(inputCoordinates[inputCoordinates.length - 1]);
        }
        Coordinate[] newCoords = simplified.toArray(new Coordinate[simplified.size()]);
        return line.getFactory().createLineString(newCoords);
    }

    private void setupPointTransform(AffineTransform tempTransform, Point centroid, TextStyle2D textStyle, LabelPainter painter) {
        tempTransform.translate(centroid.getX(), centroid.getY());
        double rotation = textStyle.getRotation();
        if (rotation != rotation) {
            rotation = 0.0;
        }
        if (Double.isInfinite(rotation)) {
            rotation = 0.0;
        }
        tempTransform.rotate(rotation);
        Rectangle2D textBounds = painter.getLabelBounds();
        double displacementX = textStyle.getAnchorX() * -textBounds.getWidth() + textStyle.getDisplacementX();
        double displacementY = textStyle.getAnchorY() * textBounds.getHeight() - textStyle.getDisplacementY() - textBounds.getHeight() + painter.getLineHeight();
        tempTransform.translate(displacementX, displacementY);
    }

    private void setupLineTransform(LabelPainter painter, LineStringCursor cursor, Coordinate centroid, AffineTransform tempTransform, boolean followLine) {
        double rotation;
        tempTransform.translate(centroid.x, centroid.y);
        TextStyle2D textStyle = painter.getLabel().getTextStyle();
        double anchorX = textStyle.getAnchorX();
        double anchorY = textStyle.getAnchorY();
        double displacementX = 0.0;
        double displacementY = 0.0;
        if (textStyle.isPointPlacement() && !followLine) {
            rotation = textStyle.getRotation();
        } else {
            rotation = painter.getLabel().isForceLeftToRightEnabled() ? cursor.getLabelOrientation() : cursor.getCurrentAngle();
            displacementY -= (double)textStyle.getPerpendicularOffset();
            anchorX = 0.5;
            anchorY = painter.getLinePlacementYAnchor();
        }
        Rectangle2D textBounds = painter.getLabelBounds();
        displacementX = anchorX * -textBounds.getWidth() + textStyle.getDisplacementX();
        displacementY += anchorY * textBounds.getHeight() - textStyle.getDisplacementY();
        if (Double.isNaN(rotation) || Double.isInfinite(rotation)) {
            rotation = 0.0;
        }
        tempTransform.rotate(rotation);
        tempTransform.translate(displacementX, displacementY);
    }

    private boolean paintPointLabel(LabelPainter painter, AffineTransform tempTransform, Rectangle displayArea, LabelIndex glyphs) throws Exception {
        int startAngle;
        LabelCacheItem labelItem = painter.getLabel();
        Point point = this.getPointSetRepresentativeLocation(labelItem.getGeoms(), displayArea);
        if (point == null) {
            return false;
        }
        TextStyle2D ts = labelItem.getTextStyle();
        double step = painter.getAscent() > 2.0 ? painter.getAscent() : 2.0;
        AffineTransform tx = new AffineTransform(tempTransform);
        if (this.paintPointLabelInternal(painter, tx, displayArea, glyphs, labelItem, point, ts)) {
            return true;
        }
        TextStyle2D cloned = new TextStyle2D(ts);
        int angle = startAngle = this.getClosestStandardAngle(ts.getDisplacementX(), ts.getDisplacementY());
        for (double radius = Math.sqrt(ts.getDisplacementX() * ts.getDisplacementX() + ts.getDisplacementY() * ts.getDisplacementY()); radius <= (double)labelItem.maxDisplacement; radius += step) {
            for (int offset = 45; offset <= 360; offset += 45) {
                double dx = radius * Math.cos(Math.toRadians(angle));
                double dy = radius * Math.sin(Math.toRadians(angle));
                int normAngle = angle % 360;
                if (normAngle < 0) {
                    normAngle = 360 + normAngle;
                }
                double[] anchorPointCandidates = normAngle < 90 || normAngle > 270 ? RIGHT_ANCHOR_CANDIDATES : (normAngle > 90 && normAngle < 270 ? LEFT_ANCHOR_CANDIDATES : MID_ANCHOR_CANDIDATES);
                for (int i = 0; i < anchorPointCandidates.length; i += 2) {
                    double ax = anchorPointCandidates[i];
                    double ay = anchorPointCandidates[i + 1];
                    cloned.setAnchorX(ax);
                    cloned.setAnchorY(ay);
                    cloned.setDisplacementX(dx);
                    cloned.setDisplacementY(dy);
                    tx = new AffineTransform(tempTransform);
                    if (!this.paintPointLabelInternal(painter, tx, displayArea, glyphs, labelItem, point, cloned)) continue;
                    return true;
                }
                if (angle <= startAngle) {
                    angle += offset;
                    continue;
                }
                angle -= offset;
            }
        }
        return false;
    }

    int getClosestStandardAngle(double x, double y) {
        double angle = Math.toDegrees(Math.atan2(y, x));
        return (int)Math.round(angle / 45.0) * 45;
    }

    private boolean paintPointLabelInternal(LabelPainter painter, AffineTransform tempTransform, Rectangle displayArea, LabelIndex glyphs, LabelCacheItem labelItem, Point point, TextStyle2D textStyle) throws Exception {
        this.setupPointTransform(tempTransform, point, textStyle, painter);
        Rectangle2D transformed = tempTransform.createTransformedShape(painter.getFullLabelBounds()).getBounds2D();
        if (!displayArea.contains(transformed) || labelItem.isConflictResolutionEnabled() && glyphs.labelsWithinDistance(transformed, labelItem.getSpaceAround())) {
            return false;
        }
        painter.paintStraightLabel(tempTransform);
        if (labelItem.isConflictResolutionEnabled()) {
            glyphs.addLabel(labelItem, transformed);
        }
        return true;
    }

    private boolean paintPolygonLabel(LabelPainter painter, AffineTransform tempTransform, Rectangle displayArea, LabelIndex glyphs) throws Exception {
        double step;
        AffineTransform tx;
        Point centroid;
        LabelCacheItem labelItem = painter.getLabel();
        Polygon geom = this.getPolySetRepresentativeLocation(labelItem.getGeoms(), displayArea);
        if (geom == null) {
            return false;
        }
        try {
            centroid = geom.getCentroid();
        }
        catch (Exception e) {
            try {
                centroid = geom.getExteriorRing().getCentroid();
            }
            catch (Exception ee) {
                try {
                    centroid = geom.getFactory().createPoint(geom.getCoordinate());
                }
                catch (Exception eee) {
                    return false;
                }
            }
        }
        PreparedGeometry pg = PreparedGeometryFactory.prepare((Geometry)geom);
        if (!pg.contains((Geometry)centroid)) {
            Envelope env = geom.getEnvelopeInternal();
            LineString bisector = geom.getFactory().createLineString(new Coordinate[]{new Coordinate(env.getMinX(), centroid.getY()), new Coordinate(env.getMaxX(), centroid.getY())});
            Geometry intersection = bisector.intersection((Geometry)geom);
            Envelope widestEnv = this.widestGeometry(intersection).getEnvelopeInternal();
            double midX = (widestEnv.getMinX() + widestEnv.getMaxX()) / 2.0;
            centroid = geom.getFactory().createPoint(new Coordinate(midX, centroid.getY()));
        }
        TextStyle2D textStyle = new TextStyle2D(labelItem.getTextStyle());
        if (labelItem.getMaxDisplacement() > 0) {
            textStyle.setDisplacementX(0.0);
            textStyle.setDisplacementY(0.0);
            textStyle.setAnchorX(0.5);
            textStyle.setAnchorY(0.5);
        }
        if (this.paintPolygonLabelInternal(painter, tx = new AffineTransform(tempTransform), displayArea, glyphs, labelItem, pg, centroid, textStyle)) {
            return true;
        }
        Coordinate c = new Coordinate(centroid.getCoordinate());
        Coordinate cc = centroid.getCoordinate();
        Point testPoint = centroid.getFactory().createPoint(c);
        for (double radius = step = painter.getAscent() > 2.0 ? painter.getAscent() : 2.0; radius < (double)labelItem.getMaxDisplacement(); radius += step) {
            for (int angle = 0; angle < 360; angle += 45) {
                double dx = Math.cos(Math.toRadians(angle)) * radius;
                double dy = Math.sin(Math.toRadians(angle)) * radius;
                c.x = cc.x + dx;
                c.y = cc.y + dy;
                testPoint.geometryChanged();
                if (!pg.contains((Geometry)testPoint)) continue;
                textStyle.setDisplacementX(dx);
                textStyle.setDisplacementY(dy);
                tx = new AffineTransform(tempTransform);
                if (!this.paintPolygonLabelInternal(painter, tx, displayArea, glyphs, labelItem, pg, centroid, textStyle)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean paintPolygonLabelInternal(LabelPainter painter, AffineTransform tempTransform, Rectangle displayArea, LabelIndex glyphs, LabelCacheItem labelItem, PreparedGeometry pg, Point centroid, TextStyle2D textStyle) throws Exception {
        this.setupPointTransform(tempTransform, centroid, textStyle, painter);
        Rectangle2D transformed = tempTransform.createTransformedShape(painter.getFullLabelBounds()).getBounds2D();
        if (!displayArea.contains(transformed) || labelItem.isConflictResolutionEnabled() && glyphs.labelsWithinDistance(transformed, labelItem.getSpaceAround()) || this.goodnessOfFit(painter, transformed, pg) < painter.getLabel().getGoodnessOfFit()) {
            return false;
        }
        painter.paintStraightLabel(tempTransform);
        if (labelItem.isConflictResolutionEnabled()) {
            glyphs.addLabel(labelItem, transformed);
        }
        return true;
    }

    Geometry widestGeometry(Geometry geometry) {
        if (!(geometry instanceof GeometryCollection)) {
            return geometry;
        }
        return this.widestGeometry((GeometryCollection)geometry);
    }

    Geometry widestGeometry(GeometryCollection gc) {
        if (gc.isEmpty()) {
            return gc;
        }
        Geometry widest = gc.getGeometryN(0);
        for (int i = 1; i < gc.getNumGeometries(); ++i) {
            Geometry curr = gc.getGeometryN(i);
            if (!(curr.getEnvelopeInternal().getWidth() > widest.getEnvelopeInternal().getWidth())) continue;
            widest = curr;
        }
        return widest;
    }

    Point getPointSetRepresentativeLocation(List<Geometry> geoms, Rectangle displayArea) {
        ArrayList<Point> pts = new ArrayList<Point>();
        for (Geometry g : geoms) {
            if (!(g instanceof Point) && !(g instanceof MultiPoint)) {
                g = g.getCentroid();
            }
            if (g instanceof Point) {
                Point point = (Point)g;
                if (!displayArea.contains(point.getX(), point.getY())) continue;
                pts.add(point);
                continue;
            }
            if (!(g instanceof MultiPoint)) continue;
            for (int t = 0; t < g.getNumGeometries(); ++t) {
                Point gg = (Point)g.getGeometryN(t);
                if (!displayArea.contains(gg.getX(), gg.getY())) continue;
                pts.add(gg);
            }
        }
        if (pts.size() == 0) {
            return null;
        }
        return (Point)pts.get(0);
    }

    List<LineString> getLineSetRepresentativeLocation(List<Geometry> geoms, Rectangle displayArea, boolean removeOverlaps) {
        Geometry displayGeom = this.gf.toGeometry(this.toEnvelope(displayArea));
        Envelope displayGeomEnv = displayGeom.getEnvelopeInternal();
        ArrayList<LineString> lines = new ArrayList<LineString>();
        for (Geometry g : geoms) {
            this.accumulateLineStrings(g, lines);
        }
        if (lines.size() == 0) {
            return null;
        }
        ArrayList<Object> clippedLines = new ArrayList<LineString>();
        for (LineString ls : lines) {
            MultiLineString ll = this.clipLineString(ls, (Polygon)displayGeom, displayGeomEnv);
            if (ll == null || ll.isEmpty()) continue;
            for (int t = 0; t < ll.getNumGeometries(); ++t) {
                clippedLines.add((LineString)ll.getGeometryN(t));
            }
        }
        if (removeOverlaps) {
            ArrayList<LineString> cleanedLines = new ArrayList<LineString>();
            ArrayList<Geometry> bufferCache = new ArrayList<Geometry>();
            Iterator i$ = clippedLines.iterator();
            while (i$.hasNext()) {
                LineString ls;
                LineString g = ls = (LineString)i$.next();
                for (int i = 0; i < cleanedLines.size(); ++i) {
                    LineString cleaned = (LineString)cleanedLines.get(i);
                    if (!g.getEnvelopeInternal().intersects(cleaned.getEnvelopeInternal())) continue;
                    Geometry buffer = (Geometry)bufferCache.get(i);
                    if (buffer == null) {
                        buffer = cleaned.buffer(2.0);
                        bufferCache.set(i, buffer);
                    }
                    g = g.difference(buffer);
                }
                int added = this.accumulateLineStrings((Geometry)g, cleanedLines);
                for (int i = 0; i < added; ++i) {
                    bufferCache.add(null);
                }
            }
            clippedLines = cleanedLines;
        }
        if (clippedLines == null || clippedLines.size() == 0) {
            return null;
        }
        List<LineString> merged = this.mergeLines(clippedLines);
        if (merged.size() == 0) {
            return null;
        }
        Collections.sort(merged, new LineLengthComparator());
        return merged;
    }

    private int accumulateLineStrings(Geometry g, List<LineString> lines) {
        if (!(g instanceof LineString || g instanceof MultiLineString || g instanceof Polygon || g instanceof MultiPolygon)) {
            return 0;
        }
        if ((g instanceof Polygon || g instanceof MultiPolygon) && !((g = g.getBoundary()) instanceof LineString) && !(g instanceof MultiLineString)) {
            return 0;
        }
        if (g instanceof LineString) {
            if (g.getLength() != 0.0) {
                lines.add((LineString)g);
                return 1;
            }
            return 0;
        }
        if (g instanceof MultiLineString) {
            for (int t = 0; t < g.getNumGeometries(); ++t) {
                LineString gg = (LineString)g.getGeometryN(t);
                lines.add(gg);
            }
            return g.getNumGeometries();
        }
        int count = 0;
        for (int t = 0; t < g.getNumGeometries(); ++t) {
            count += this.accumulateLineStrings(g.getGeometryN(t), lines);
        }
        return count;
    }

    public MultiLineString clipLineString(LineString line, Polygon bbox, Envelope displayGeomEnv) {
        LineString clip = line;
        line.geometryChanged();
        if (displayGeomEnv.contains(line.getEnvelopeInternal())) {
            LineString[] lns = new LineString[]{clip};
            return line.getFactory().createMultiLineString(lns);
        }
        try {
            return this.clipLineToEnvelope(line, bbox, displayGeomEnv);
        }
        catch (Exception e) {
            return line.getFactory().createMultiLineString(new LineString[]{line});
        }
    }

    private MultiLineString clipLineToEnvelope(LineString line, Polygon bbox, Envelope displayGeomEnv) {
        Coordinate[] coords = line.getCoordinates();
        ArrayList<LineString> clipped = new ArrayList<LineString>();
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
        boolean prevInside = displayGeomEnv.contains(coords[0]);
        if (prevInside) {
            coordinates.add(coords[0]);
        }
        for (int i = 1; i < coords.length; ++i) {
            LineString segment;
            boolean inside = displayGeomEnv.contains(coords[i]);
            if (inside == prevInside) {
                if (inside) {
                    coordinates.add(coords[i]);
                } else {
                    segment = this.gf.createLineString(new Coordinate[]{coords[i - 1], coords[i]});
                    Geometry g = segment.intersection((Geometry)bbox);
                    if (g instanceof LineString) {
                        clipped.add((LineString)g);
                    }
                }
            } else {
                segment = this.gf.createLineString(new Coordinate[]{coords[i - 1], coords[i]});
                LineString ls = (LineString)segment.intersection((Geometry)bbox);
                if (prevInside) {
                    coordinates.add(ls.getCoordinateN(1));
                } else {
                    coordinates.add(ls.getCoordinateN(0));
                    coordinates.add(coords[i]);
                }
                if (prevInside) {
                    clipped.add(this.gf.createLineString(coordinates.toArray(new Coordinate[coordinates.size()])));
                    coordinates.clear();
                }
            }
            prevInside = inside;
        }
        if (coordinates.size() > 0) {
            clipped.add(this.gf.createLineString(coordinates.toArray(new Coordinate[coordinates.size()])));
        }
        return this.gf.createMultiLineString(clipped.toArray(new LineString[clipped.size()]));
    }

    Polygon getPolySetRepresentativeLocation(List<Geometry> geoms, Rectangle displayArea) {
        ArrayList<Polygon> polys = new ArrayList<Polygon>();
        Geometry displayGeometry = this.gf.toGeometry(this.toEnvelope(displayArea));
        for (Geometry g : geoms) {
            if (!(g instanceof Polygon) && !(g instanceof MultiPolygon)) continue;
            if (g instanceof Polygon) {
                polys.add((Polygon)g);
                continue;
            }
            for (int t = 0; t < g.getNumGeometries(); ++t) {
                Polygon gg = (Polygon)g.getGeometryN(t);
                polys.add(gg);
            }
        }
        if (polys.size() == 0) {
            return null;
        }
        ArrayList<Polygon> clippedPolys = new ArrayList<Polygon>();
        Envelope displayGeomEnv = displayGeometry.getEnvelopeInternal();
        for (Polygon p : polys) {
            MultiPolygon pp = this.clipPolygon(p, (Polygon)displayGeometry, displayGeomEnv);
            if (pp == null || pp.isEmpty()) continue;
            for (int t = 0; t < pp.getNumGeometries(); ++t) {
                clippedPolys.add((Polygon)pp.getGeometryN(t));
            }
        }
        if (clippedPolys.size() == 0) {
            return null;
        }
        if (clippedPolys.size() == 1) {
            return (Polygon)clippedPolys.get(0);
        }
        double maxSize = -1.0;
        Polygon maxPoly = null;
        for (int t = 0; t < clippedPolys.size(); ++t) {
            Polygon cpoly = (Polygon)clippedPolys.get(t);
            if (!(cpoly.getArea() > maxSize)) continue;
            maxPoly = cpoly;
            maxSize = cpoly.getArea();
        }
        return maxPoly;
    }

    public MultiPolygon clipPolygon(Polygon poly, Polygon bbox, Envelope displayGeomEnv) {
        Polygon clip = poly;
        poly.geometryChanged();
        if (displayGeomEnv.contains(poly.getEnvelopeInternal())) {
            Polygon[] polys = new Polygon[]{clip};
            return poly.getFactory().createMultiPolygon(polys);
        }
        try {
            Decimator d = new Decimator(10.0, 10.0);
            d.decimate((Geometry)poly);
            poly.geometryChanged();
            clip = EnhancedPrecisionOp.intersection((Geometry)poly, (Geometry)bbox);
        }
        catch (Exception e) {
            clip = poly;
        }
        if (clip instanceof MultiPolygon) {
            return (MultiPolygon)clip;
        }
        if (clip instanceof Polygon) {
            Polygon[] polys = new Polygon[]{clip};
            return poly.getFactory().createMultiPolygon(polys);
        }
        if (clip instanceof Point) {
            return null;
        }
        if (clip instanceof MultiPoint) {
            return null;
        }
        if (clip instanceof LineString) {
            return null;
        }
        if (clip instanceof MultiLineString) {
            return null;
        }
        GeometryCollection gc = (GeometryCollection)clip;
        ArrayList<Polygon> polys = new ArrayList<Polygon>();
        for (int t = 0; t < gc.getNumGeometries(); ++t) {
            Geometry g = gc.getGeometryN(t);
            if (!(g instanceof Polygon)) continue;
            polys.add((Polygon)g);
        }
        if (polys.size() == 0) {
            return null;
        }
        return poly.getFactory().createMultiPolygon(polys.toArray(new Polygon[1]));
    }

    private List<LineString> mergeLines(Collection<LineString> lines) {
        LineMerger lm = new LineMerger();
        lm.add(lines);
        ArrayList<LineString> merged = new ArrayList<LineString>(lm.getMergedLineStrings());
        if (merged.size() == 0) {
            return null;
        }
        if (merged.size() == 1) {
            return merged;
        }
        HashMap<Coordinate, List<LineString>> nodes = new HashMap<Coordinate, List<LineString>>(merged.size() * 2);
        for (LineString ls : merged) {
            this.putInNodeHash(ls.getCoordinateN(0), ls, nodes);
            this.putInNodeHash(ls.getCoordinateN(ls.getNumPoints() - 1), ls, nodes);
        }
        ArrayList<LineString> merged_list = new ArrayList<LineString>(merged);
        Collections.sort(merged_list, this.lineLengthComparator);
        return this.processNodes(merged_list, nodes);
    }

    public List<LineString> processNodes(List<LineString> edges, Map<Coordinate, List<LineString>> nodes) {
        ArrayList<LineString> result = new ArrayList<LineString>();
        int index = 0;
        while (index < edges.size()) {
            LineString ls2;
            LineString ls = edges.get(index);
            Coordinate key = ls.getCoordinateN(0);
            List<LineString> nodeList = nodes.get(key);
            if (nodeList == null) {
                ++index;
                continue;
            }
            if (!nodeList.contains(ls)) {
                ++index;
                continue;
            }
            this.removeFromHash(nodes, ls);
            Coordinate key2 = ls.getCoordinateN(ls.getNumPoints() - 1);
            List<LineString> nodeList2 = nodes.get(key2);
            if (nodeList.size() == 0 && nodeList2.size() == 0) {
                result.add(ls);
                ++index;
                continue;
            }
            if (nodeList.size() > 0) {
                ls2 = this.getLongest(nodeList);
                ls = this.merge(ls, ls2);
                this.removeFromHash(nodes, ls2);
            }
            if (nodeList2.size() > 0) {
                ls2 = this.getLongest(nodeList2);
                ls = this.merge(ls, ls2);
                this.removeFromHash(nodes, ls2);
            }
            edges.set(index, ls);
            this.putInNodeHash(ls.getCoordinateN(0), ls, nodes);
            this.putInNodeHash(ls.getCoordinateN(ls.getNumPoints() - 1), ls, nodes);
        }
        return result;
    }

    public void removeFromHash(Map<Coordinate, List<LineString>> nodes, LineString ls) {
        Coordinate key = ls.getCoordinateN(0);
        List<LineString> nodeList = nodes.get(key);
        if (nodeList != null) {
            nodeList.remove(ls);
        }
        if ((nodeList = nodes.get(key = ls.getCoordinateN(ls.getNumPoints() - 1))) != null) {
            nodeList.remove(ls);
        }
    }

    private LineString getLongest(List<LineString> al) {
        if (al.size() == 1) {
            return al.get(0);
        }
        double maxLength = -1.0;
        LineString result = null;
        for (LineString l : al) {
            if (!(l.getLength() > maxLength)) continue;
            result = l;
            maxLength = l.getLength();
        }
        return result;
    }

    private void putInNodeHash(Coordinate node, LineString ls, Map<Coordinate, List<LineString>> nodes) {
        List<LineString> nodeList = nodes.get(node);
        if (nodeList == null) {
            nodeList = new ArrayList<LineString>();
            nodeList.add(ls);
            nodes.put(node, nodeList);
        } else {
            nodeList.add(ls);
        }
    }

    private LineString reverse(LineString l) {
        List<Coordinate> clist = Arrays.asList(l.getCoordinates());
        Collections.reverse(clist);
        return l.getFactory().createLineString(clist.toArray(new Coordinate[1]));
    }

    private LineString merge(LineString major, LineString minor) {
        Coordinate major_s = major.getCoordinateN(0);
        Coordinate major_e = major.getCoordinateN(major.getNumPoints() - 1);
        Coordinate minor_s = minor.getCoordinateN(0);
        Coordinate minor_e = minor.getCoordinateN(minor.getNumPoints() - 1);
        if (major_s.equals2D(minor_s)) {
            return this.mergeSimple(this.reverse(minor), major);
        }
        if (major_s.equals2D(minor_e)) {
            return this.mergeSimple(minor, major);
        }
        if (major_e.equals2D(minor_s)) {
            return this.mergeSimple(major, minor);
        }
        if (major_e.equals2D(minor_e)) {
            return this.mergeSimple(major, this.reverse(minor));
        }
        return null;
    }

    private LineString mergeSimple(LineString l1, LineString l2) {
        ArrayList<Coordinate> clist = new ArrayList<Coordinate>(Arrays.asList(l1.getCoordinates()));
        clist.addAll(Arrays.asList(l2.getCoordinates()));
        return l1.getFactory().createLineString(clist.toArray(new Coordinate[1]));
    }

    private Envelope intersection(Envelope e1, Envelope e2) {
        Envelope r = e1.intersection(e2);
        if (r.getWidth() < 0.0) {
            return null;
        }
        if (r.getHeight() < 0.0) {
            return null;
        }
        return r;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class LineLengthComparator
    implements Comparator<LineString> {
        private LineLengthComparator() {
        }

        @Override
        public int compare(LineString o1, LineString o2) {
            return Double.compare(o2.getLength(), o1.getLength());
        }
    }
}

