/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.test;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import junit.framework.TestCase;
import junit.framework.TestResult;
import org.geotools.test.FixtureUtilities;

public abstract class OnlineTestCase
extends TestCase {
    public static final String ONLINE_TEST_PROFILE = "onlineTestProfile";
    public static final String SKIP_ON_FAILURE_KEY = "skip.on.failure";
    public static final String SKIP_ON_FAILURE_DEFAULT = "true";
    protected static Map<String, Boolean> online = new HashMap<String, Boolean>();
    protected static Map<String, Boolean> found = new HashMap<String, Boolean>();
    protected Properties fixture;
    protected boolean skipOnFailure = true;

    public void run(TestResult result) {
        if (this.checkAvailable()) {
            super.run(result);
        }
    }

    boolean checkAvailable() {
        this.configureFixture();
        if (this.fixture == null) {
            return false;
        }
        String fixtureId = this.getFixtureId();
        Boolean available = online.get(fixtureId);
        if (available == null || available.booleanValue()) {
            try {
                available = this.isOnline();
            }
            catch (Throwable t) {
                System.out.println("Skipping " + fixtureId + " tests, resources not available: " + t.getMessage());
                t.printStackTrace();
                available = Boolean.FALSE;
            }
            online.put(fixtureId, available);
        }
        return available;
    }

    private void configureFixture() {
        if (this.fixture == null) {
            String fixtureId = this.getFixtureId();
            if (fixtureId == null) {
                return;
            }
            try {
                File fixtureFile;
                Boolean exists;
                File base = FixtureUtilities.getFixtureDirectory();
                String profile = System.getProperty(ONLINE_TEST_PROFILE);
                if (profile != null && !"".equals(profile)) {
                    base = new File(base, profile);
                }
                if ((exists = found.get((fixtureFile = FixtureUtilities.getFixtureFile(base, fixtureId)).getCanonicalPath())) == null || exists.booleanValue()) {
                    if (fixtureFile.exists()) {
                        this.fixture = FixtureUtilities.loadProperties(fixtureFile);
                        found.put(fixtureFile.getCanonicalPath(), true);
                    } else {
                        File exFixtureFile;
                        Properties exampleFixture;
                        if (profile == null && (exampleFixture = this.createExampleFixture()) != null && !(exFixtureFile = new File(fixtureFile.getAbsolutePath() + ".example")).exists()) {
                            this.createExampleFixture(exFixtureFile, exampleFixture);
                        }
                        found.put(fixtureFile.getCanonicalPath(), false);
                    }
                }
                if (this.fixture == null) {
                    this.fixture = this.createOfflineFixture();
                }
                if (this.fixture == null && exists == null) {
                    FixtureUtilities.printSkipNotice(fixtureId, fixtureFile);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    void createExampleFixture(File exFixtureFile, Properties exampleFixture) {
        try {
            exFixtureFile.getParentFile().mkdirs();
            exFixtureFile.createNewFile();
            FileOutputStream fout = new FileOutputStream(exFixtureFile);
            exampleFixture.store(fout, "This is an example fixture. Update the values and remove the .example suffix to enable the test");
            fout.flush();
            fout.close();
            System.out.println("Wrote example fixture file to " + exFixtureFile);
        }
        catch (IOException ioe) {
            System.out.println("Unable to write out example fixture " + exFixtureFile);
            ioe.printStackTrace();
        }
    }

    protected final void setUp() throws Exception {
        super.setUp();
        this.setUpInternal();
        this.skipOnFailure = Boolean.parseBoolean(this.fixture.getProperty(SKIP_ON_FAILURE_KEY, SKIP_ON_FAILURE_DEFAULT));
        try {
            this.connect();
        }
        catch (Exception e) {
            if (this.skipOnFailure) {
                this.fixture = null;
                e.printStackTrace();
            }
            throw e;
        }
    }

    protected void setUpInternal() throws Exception {
    }

    protected final void tearDown() throws Exception {
        block3: {
            this.tearDownInternal();
            if (this.fixture != null) {
                try {
                    this.disconnect();
                }
                catch (Exception e) {
                    if (this.skipOnFailure) break block3;
                    throw e;
                }
            }
        }
    }

    protected void tearDownInternal() throws Exception {
    }

    protected boolean isOnline() throws Exception {
        return true;
    }

    protected void connect() throws Exception {
    }

    protected void disconnect() throws Exception {
    }

    protected Properties createOfflineFixture() {
        return null;
    }

    protected Properties createExampleFixture() {
        return null;
    }

    protected abstract String getFixtureId();
}

