/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.test;

import java.util.Properties;
import org.geotools.test.OnlineTestCase;
import org.junit.After;
import org.junit.Assume;
import org.junit.Before;

public abstract class OnlineTestSupport {
    private final DelegateOnlineTestCase delegate = new DelegateOnlineTestCase();

    @Before
    public void before() throws Exception {
        Assume.assumeTrue((boolean)this.delegate.checkAvailable());
        this.delegate.setUp();
    }

    @After
    public void after() throws Exception {
        this.delegate.tearDown();
    }

    protected abstract String getFixtureId();

    protected void connect() throws Exception {
    }

    protected void disconnect() throws Exception {
    }

    protected boolean isOnline() throws Exception {
        return true;
    }

    protected void setUpInternal() throws Exception {
    }

    protected void tearDownInternal() throws Exception {
    }

    protected Properties createOfflineFixture() {
        return null;
    }

    protected Properties createExampleFixture() {
        return null;
    }

    protected Properties getFixture() {
        return this.delegate.fixture;
    }

    private class DelegateOnlineTestCase
    extends OnlineTestCase {
        private DelegateOnlineTestCase() {
        }

        protected String getFixtureId() {
            return OnlineTestSupport.this.getFixtureId();
        }

        protected void connect() throws Exception {
            OnlineTestSupport.this.connect();
        }

        protected void disconnect() throws Exception {
            OnlineTestSupport.this.disconnect();
        }

        protected boolean isOnline() throws Exception {
            return OnlineTestSupport.this.isOnline();
        }

        protected void setUpInternal() throws Exception {
            OnlineTestSupport.this.setUpInternal();
        }

        protected void tearDownInternal() throws Exception {
            OnlineTestSupport.this.tearDownInternal();
        }

        protected Properties createExampleFixture() {
            return OnlineTestSupport.this.createExampleFixture();
        }

        protected Properties createOfflineFixture() {
            return OnlineTestSupport.this.createOfflineFixture();
        }
    }
}

