/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.index.quadtree;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.util.AbstractCollection;
import java.util.Iterator;
import java.util.logging.Level;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.index.CloseableCollection;
import org.geotools.index.Data;
import org.geotools.index.quadtree.LazySearchIterator;
import org.geotools.index.quadtree.QuadTree;
import org.geotools.index.quadtree.StoreException;
import org.geotools.util.logging.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LazySearchCollection
extends AbstractCollection<Data>
implements CloseableCollection<Data> {
    private QuadTree tree;
    private Envelope bounds;

    public LazySearchCollection(QuadTree tree, Envelope bounds) {
        this.tree = tree;
        this.bounds = bounds;
    }

    @Override
    public Iterator<Data> iterator() {
        LazySearchIterator object;
        try {
            object = new LazySearchIterator(this.tree.getRoot().copy(), this.tree.getIndexfile(), this.bounds);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.tree.registerIterator(object);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        Iterator<Data> iter = this.iterator();
        try {
            int count = 0;
            while (iter.hasNext()) {
                iter.next();
                ++count;
            }
            int n = count;
            return n;
        }
        finally {
            try {
                this.tree.close(iter);
            }
            catch (StoreException e) {
                Logging.getLogger((String)"org.geotools.index.quadtree").severe("Couldn't close iterator");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        Iterator<Data> iter = this.iterator();
        boolean isEmtpy = true;
        try {
            isEmtpy = !iter.hasNext();
        }
        finally {
            try {
                this.tree.close(iter);
            }
            catch (StoreException e) {
                Logging.getLogger((String)"org.geotools.index.quadtree").severe("Couldn't close iterator");
            }
        }
        return isEmtpy;
    }

    @Override
    public void close() {
        try {
            this.tree.close();
        }
        catch (StoreException e) {
            ShapefileDataStoreFactory.LOGGER.log(Level.SEVERE, "Error closing QuadTree", e);
        }
    }

    @Override
    public void closeIterator(Iterator<Data> iter) throws IOException {
        try {
            this.tree.close(iter);
        }
        catch (StoreException e) {
            throw (IOException)new IOException(e.getLocalizedMessage()).initCause(e);
        }
    }
}

