/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.index;

import java.util.ArrayList;
import org.geotools.index.DataDefinition;
import org.geotools.index.TreeException;

public class Data {
    private DataDefinition def;
    private ArrayList values;

    public Data(DataDefinition def) {
        this.def = def;
        this.values = new ArrayList(def.getFieldsCount());
    }

    public final boolean isValid() {
        if (this.getValuesCount() != this.def.getFieldsCount()) {
            return false;
        }
        boolean ret = true;
        int i = 0;
        while (i < this.def.getFieldsCount()) {
            if (!this.def.getField(i).getFieldClass().isInstance(this.getValue(i))) {
                ret = false;
                break;
            }
            ++i;
        }
        return ret;
    }

    public Data addValue(Object val) throws TreeException {
        if (this.values.size() == this.def.getFieldsCount()) {
            throw new TreeException("Max number of values reached!");
        }
        int pos = this.values.size();
        if (!val.getClass().equals(this.def.getField(pos).getFieldClass())) {
            throw new TreeException("Wrong class type, was expecting " + this.def.getField(pos).getFieldClass());
        }
        this.values.add(val);
        return this;
    }

    public DataDefinition getDefinition() {
        return this.def;
    }

    public int getValuesCount() {
        return this.values.size();
    }

    public Object getValue(int i) {
        return this.values.get(i);
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        int i = 0;
        while (i < this.values.size()) {
            if (i > 0) {
                ret.append(" - ");
            }
            ret.append(this.def.getField(i).getFieldClass());
            ret.append(": ");
            ret.append(this.values.get(i));
            ++i;
        }
        return ret.toString();
    }

    public void clear() {
        this.values.clear();
    }
}

