/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swing.utils;

import java.util.Collection;
import org.geotools.map.MapLayer;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridCoverageReader;
import org.opengis.feature.type.PropertyDescriptor;

public class MapLayerUtils {
    private static final Class<?> BASE_GRID_CLASS = GridCoverage.class;
    private static final Class<?> BASE_READER_CLASS = GridCoverageReader.class;

    public static boolean isGridLayer(MapLayer layer) {
        Collection descriptors = layer.getFeatureSource().getSchema().getDescriptors();
        for (PropertyDescriptor desc : descriptors) {
            Class binding = desc.getType().getBinding();
            if (!BASE_GRID_CLASS.isAssignableFrom(binding) && !BASE_READER_CLASS.isAssignableFrom(binding)) continue;
            return true;
        }
        return false;
    }

    public static String getGridAttributeName(MapLayer layer) {
        String attrName = null;
        Collection descriptors = layer.getFeatureSource().getSchema().getDescriptors();
        for (PropertyDescriptor desc : descriptors) {
            Class binding = desc.getType().getBinding();
            if (!BASE_GRID_CLASS.isAssignableFrom(binding) && !BASE_READER_CLASS.isAssignableFrom(binding)) continue;
            attrName = desc.getName().getLocalPart();
            break;
        }
        return attrName;
    }
}

