/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;
import org.geotools.map.MapContext;
import org.geotools.renderer.GTRenderer;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.swing.JMapPane;
import org.geotools.swing.MapLayerTable;
import org.geotools.swing.StatusBar;
import org.geotools.swing.action.InfoAction;
import org.geotools.swing.action.PanAction;
import org.geotools.swing.action.ResetAction;
import org.geotools.swing.action.ZoomInAction;
import org.geotools.swing.action.ZoomOutAction;

public class JMapFrame
extends JFrame {
    private Set<Tool> toolSet;
    private JMapPane mapPane;
    private MapLayerTable mapLayerTable;
    private JToolBar toolBar;
    private StatusBar statusBar;
    private boolean showStatusBar;
    private boolean showLayerTable;
    private boolean uiSet;

    public static void showMap(MapContext context) {
        final JMapFrame frame = new JMapFrame(context);
        frame.enableStatusBar(true);
        frame.enableToolBar(true);
        frame.initComponents();
        frame.setSize(500, 500);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                frame.setVisible(true);
            }
        });
    }

    public JMapFrame() {
        this((MapContext)null);
    }

    public JMapFrame(MapContext context) {
        this(context, (GTRenderer)new StreamingRenderer());
    }

    public JMapFrame(MapContext context, GTRenderer renderer) {
        super(context == null ? "" : context.getTitle());
        this.setDefaultCloseOperation(3);
        this.showLayerTable = false;
        this.showStatusBar = false;
        this.toolSet = new HashSet<Tool>();
        this.mapPane = new JMapPane();
        this.mapPane.setBackground(Color.WHITE);
        this.mapPane.setMapContext(context);
        this.mapPane.setRenderer(renderer);
    }

    public void enableToolBar(boolean state) {
        if (state) {
            this.toolSet.addAll(EnumSet.allOf(Tool.class));
        } else {
            this.toolSet.clear();
        }
    }

    public void enableTool(Tool ... tool) {
        for (Tool t : tool) {
            this.toolSet.add(t);
        }
    }

    public void enableStatusBar(boolean state) {
        this.showStatusBar = state;
    }

    public void enableLayerTable(boolean state) {
        this.showLayerTable = state;
    }

    public void setVisible(boolean state) {
        if (state && !this.uiSet) {
            this.initComponents();
        }
        super.setVisible(state);
    }

    public void initComponents() {
        if (this.uiSet) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        if (!this.toolSet.isEmpty()) {
            sb.append("[]");
        }
        sb.append("[grow]");
        if (this.showStatusBar) {
            sb.append("[30px::]");
        }
        JPanel panel = new JPanel((LayoutManager)new MigLayout("wrap 1, insets 0", "[grow]", sb.toString()));
        if (!this.toolSet.isEmpty()) {
            this.toolBar = new JToolBar();
            this.toolBar.setOrientation(0);
            this.toolBar.setFloatable(false);
            ButtonGroup cursorToolGrp = new ButtonGroup();
            if (this.toolSet.contains((Object)Tool.ZOOM)) {
                JButton zoomInBtn = new JButton(new ZoomInAction(this.mapPane));
                this.toolBar.add(zoomInBtn);
                cursorToolGrp.add(zoomInBtn);
                JButton zoomOutBtn = new JButton(new ZoomOutAction(this.mapPane));
                this.toolBar.add(zoomOutBtn);
                cursorToolGrp.add(zoomOutBtn);
                this.toolBar.addSeparator();
            }
            if (this.toolSet.contains((Object)Tool.PAN)) {
                JButton panBtn = new JButton(new PanAction(this.mapPane));
                this.toolBar.add(panBtn);
                cursorToolGrp.add(panBtn);
                this.toolBar.addSeparator();
            }
            if (this.toolSet.contains((Object)Tool.INFO)) {
                JButton infoBtn = new JButton(new InfoAction(this.mapPane));
                this.toolBar.add(infoBtn);
                this.toolBar.addSeparator();
            }
            if (this.toolSet.contains((Object)Tool.RESET)) {
                JButton resetBtn = new JButton(new ResetAction(this.mapPane));
                this.toolBar.add(resetBtn);
            }
            panel.add((Component)this.toolBar, "grow");
        }
        if (this.showLayerTable) {
            this.mapLayerTable = new MapLayerTable(this.mapPane);
            this.mapLayerTable.setPreferredSize(new Dimension(200, -1));
            JSplitPane splitPane = new JSplitPane(1, false, this.mapLayerTable, this.mapPane);
            panel.add((Component)splitPane, "grow");
        } else {
            panel.add((Component)this.mapPane, "grow");
        }
        if (this.showStatusBar) {
            this.statusBar = new StatusBar(this.mapPane);
            panel.add((Component)this.statusBar, "grow");
        }
        this.getContentPane().add(panel);
        this.uiSet = true;
    }

    public MapContext getMapContext() {
        return this.mapPane.getMapContext();
    }

    public void setMapContext(MapContext context) {
        if (context == null) {
            throw new IllegalArgumentException("context must not be null");
        }
        this.mapPane.setMapContext(context);
    }

    public GTRenderer getRenderer() {
        return this.mapPane.getRenderer();
    }

    public void setRenderer(GTRenderer renderer) {
        if (renderer == null) {
            throw new IllegalArgumentException("renderer must not be null");
        }
        this.mapPane.setRenderer(renderer);
    }

    public JMapPane getMapPane() {
        return this.mapPane;
    }

    public JToolBar getToolBar() {
        if (!this.uiSet) {
            this.initComponents();
        }
        return this.toolBar;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Tool {
        NONE,
        INFO,
        PAN,
        RESET,
        ZOOM;

    }
}

