/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swing.data;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.miginfocom.swing.MigLayout;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.data.DataStoreFinder;
import org.geotools.swing.data.JDataStoreWizard;
import org.geotools.swing.wizard.JPage;

public class JDataChoosePage
extends JPage {
    protected DataStoreFactorySpi format;
    private final int MAX_DESCRIPTION_WIDTH = 60;
    private JList list;

    public JDataChoosePage() {
        this((DataStoreFactorySpi)null);
    }

    public JDataChoosePage(DataStoreFactorySpi format) {
        this.format = format;
    }

    public JPanel createPanel() {
        JPanel page = super.createPanel();
        page.setLayout((LayoutManager)new MigLayout());
        JLabel title = new JLabel("Choose DataStore");
        Font titleFont = new Font("Arial", 1, 14);
        title.setFont(titleFont);
        page.add((Component)title, "span");
        JLabel description = new JLabel("Available DataStores on your classpath");
        page.add((Component)description, "grow, span");
        ArrayList factoryList = new ArrayList();
        Iterator iter = DataStoreFinder.getAvailableDataStores();
        while (iter.hasNext()) {
            factoryList.add(iter.next());
        }
        this.list = new JList<Object>(factoryList.toArray());
        DefaultListCellRenderer cellRenderer = new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                DataStoreFactorySpi factory = (DataStoreFactorySpi)value;
                this.setText(factory.getDisplayName());
                this.setToolTipText(factory.getDescription());
                return this;
            }
        };
        this.list.setCellRenderer(cellRenderer);
        this.list.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                JDataChoosePage.this.format = (DataStoreFactorySpi)JDataChoosePage.this.list.getSelectedValue();
            }
        });
        JScrollPane scroll = new JScrollPane(this.list);
        scroll.setVerticalScrollBarPolicy(22);
        scroll.setPreferredSize(new Dimension(300, 100));
        page.add((Component)scroll, "growx,growy,span");
        return page;
    }

    public void preDisplayPanel() {
        this.list.addListSelectionListener(this.getJWizard().getController());
    }

    public void preClosePanel() {
        this.list.addListSelectionListener(this.getJWizard().getController());
        JDataStoreWizard dataStoreWizard = (JDataStoreWizard)this.getJWizard();
        dataStoreWizard.setFormat(this.format);
    }

    public boolean isValid() {
        return this.format != null;
    }
}

