/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swing.wms;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.geotools.data.ows.Layer;
import org.geotools.data.ows.WMSCapabilities;
import org.geotools.data.wms.WMSUtils;
import org.geotools.data.wms.WebMapServer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WMSLayerChooser
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = -409825958139086013L;
    WebMapServer wms;
    WMSCapabilities caps;
    JList list;
    private DefaultListModel model;

    public WMSLayerChooser() throws HeadlessException {
        this.init();
    }

    public WMSLayerChooser(Frame owner, boolean modal) throws HeadlessException {
        super(owner, modal);
        this.init();
    }

    public WMSLayerChooser(Frame owner, String title, boolean modal, GraphicsConfiguration gc) {
        super(owner, title, modal, gc);
        this.init();
    }

    public WMSLayerChooser(Frame owner, String title, boolean modal) throws HeadlessException {
        super(owner, title, modal);
        this.init();
    }

    public WMSLayerChooser(Frame owner, String title) throws HeadlessException {
        super(owner, title);
        this.init();
    }

    public WMSLayerChooser(Frame owner) throws HeadlessException {
        super(owner);
        this.init();
    }

    private void init() {
        this.setSize(400, 200);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(this);
        final JButton setButton = new JButton("Select");
        setButton.setActionCommand("Select");
        setButton.addActionListener(this);
        this.getRootPane().setDefaultButton(setButton);
        this.model = new DefaultListModel();
        this.list = new JList(this.model);
        this.list.setSelectionMode(2);
        this.list.setLayoutOrientation(0);
        this.list.setVisibleRowCount(-1);
        this.list.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    setButton.doClick();
                }
            }
        });
        JScrollPane listScroller = new JScrollPane(this.list);
        listScroller.setPreferredSize(new Dimension(400, 280));
        JPanel listPane = new JPanel();
        listPane.setLayout(new BoxLayout(listPane, 3));
        JLabel label = new JLabel("Layers");
        label.setLabelFor(this.list);
        listPane.add(label);
        listPane.add(Box.createRigidArea(new Dimension(0, 5)));
        listPane.add(listScroller);
        listPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new BoxLayout(buttonPane, 2));
        buttonPane.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        buttonPane.add(Box.createHorizontalGlue());
        buttonPane.add(cancelButton);
        buttonPane.add(Box.createRigidArea(new Dimension(10, 0)));
        buttonPane.add(setButton);
        Container contentPane = this.getContentPane();
        contentPane.add((Component)listPane, "Center");
        contentPane.add((Component)buttonPane, "Last");
    }

    private void setupLayersList() {
        this.caps = this.wms.getCapabilities();
        this.model.clear();
        for (Layer layer : WMSUtils.getNamedLayers((WMSCapabilities)this.caps)) {
            String title = layer.getTitle();
            if (title == null) {
                title = layer.getName();
            }
            this.model.addElement(layer);
        }
    }

    public int getLayer() {
        return this.list.getSelectedIndex();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equalsIgnoreCase("cancel")) {
            this.list.clearSelection();
        }
        this.setVisible(false);
    }

    public ArrayList<Layer> getLayers() {
        ArrayList<Layer> layers = new ArrayList<Layer>();
        for (Object selected : this.list.getSelectedValues()) {
            layers.add((Layer)selected);
        }
        return layers;
    }

    public WebMapServer getWms() {
        return this.wms;
    }

    public void setWMS(WebMapServer wms) {
        this.wms = wms;
        this.setupLayersList();
    }

    public static List<Layer> showSelectLayer(WebMapServer wms) {
        if (wms == null) {
            return null;
        }
        WMSLayerChooser prompt = new WMSLayerChooser();
        prompt.setWMS(wms);
        prompt.setModal(true);
        prompt.pack();
        prompt.setVisible(true);
        return prompt.getLayers();
    }
}

